/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.touchnfce.helpers.impostos.cbs.calculo;

import com.touchcomp.basementor.constants.enums.modelocbsibs.EnumConstModCbsIbsIndValorBC;
import com.touchcomp.basementor.constants.enums.number.EnumConstTipoArredondamento;
import com.touchcomp.basementorrules.constants.EnumConstTipoCalcImp;
import com.touchcomp.basementortools.tools.number.ToolNumber;
import com.touchcomp.touchnfce.helpers.impostos.cbs.calculo.adapter.CBSInterfaceCalculo;
import com.touchcomp.touchnfce.model.ClassificacaoTributariaCbsIbs;
import com.touchcomp.touchnfce.model.ModeloFiscalCbsIbs;
import com.touchcomp.touchnfce.model.NFCeItem;
import com.touchcomp.touchnfce.model.NFCeItemCbs;
import com.touchcomp.touchnfce.model.ParamTribCbsIbsClass;

public class NFCeItemCBSCalcAdapter
implements CBSInterfaceCalculo {
    final NFCeItem item;
    final NFCeItemCbs itemCbs;

    public NFCeItemCBSCalcAdapter(NFCeItem item) {
        this.item = item;
        this.itemCbs = item.getCbs();
    }

    @Override
    public void setAliquotaCBS(double aliquotaCBS) {
        this.itemCbs.setAliquotaCBS(aliquotaCBS);
    }

    @Override
    public void setAliquotaEfetivaCBS(double aliquotaCBS) {
        this.itemCbs.setAliquotaEfetivaCBS(aliquotaCBS);
    }

    @Override
    public void setBaseCalculoCBS(double baseCalculo) {
        this.itemCbs.setBaseCalculoCBS(baseCalculo);
    }

    @Override
    public void setValorCBS(double valorCBS) {
        this.itemCbs.setValorCBS(valorCBS);
    }

    @Override
    public Double getAliquotaCBS() {
        return this.itemCbs.getAliquotaCBS();
    }

    @Override
    public Double getPercRedAliquotaCBS() {
        return this.itemCbs.getPercRedAliquotaCBS();
    }

    @Override
    public Double getPercRedBC() {
        return 0.0;
    }

    @Override
    public Double getQuantidade() {
        return this.item.getQuantidadeComercial();
    }

    @Override
    public Double getValorDesconto() {
        return this.item.getValorDesconto();
    }

    @Override
    public Double getValorDespAcess() {
        return this.item.getValorDespesasAcessorias();
    }

    @Override
    public Double getValorFrete() {
        return this.item.getValorFrete();
    }

    @Override
    public Double getValorSeguro() {
        return this.item.getValorSeguro();
    }

    @Override
    public Double getValorProdutosServicos() {
        return this.item.getValorTotalBruto();
    }

    @Override
    public EnumConstModCbsIbsIndValorBC getIncluirFreteBC() {
        if (this.item.getParamTribCbsIbsClass() != null && this.item.getParamTribCbsIbsClass().getParamTribCbsIbs().getModeloFiscalCbsIbs() != null) {
            return EnumConstModCbsIbsIndValorBC.get((Object)this.item.getParamTribCbsIbsClass().getParamTribCbsIbs().getModeloFiscalCbsIbs().getIncluiFreteBC());
        }
        return EnumConstModCbsIbsIndValorBC.SOMA;
    }

    @Override
    public EnumConstModCbsIbsIndValorBC getIncluirSeguroBC() {
        if (this.item.getParamTribCbsIbsClass() != null && this.item.getParamTribCbsIbsClass().getParamTribCbsIbs().getModeloFiscalCbsIbs() != null) {
            return EnumConstModCbsIbsIndValorBC.get((Object)this.item.getParamTribCbsIbsClass().getParamTribCbsIbs().getModeloFiscalCbsIbs().getIncluiSeguroBC());
        }
        return EnumConstModCbsIbsIndValorBC.SOMA;
    }

    @Override
    public EnumConstModCbsIbsIndValorBC getIncluirDescontoBC() {
        if (this.item.getParamTribCbsIbsClass() != null && this.item.getParamTribCbsIbsClass().getParamTribCbsIbs().getModeloFiscalCbsIbs() != null) {
            return EnumConstModCbsIbsIndValorBC.get((Object)this.item.getParamTribCbsIbsClass().getParamTribCbsIbs().getModeloFiscalCbsIbs().getIncluiDescontoBC());
        }
        return EnumConstModCbsIbsIndValorBC.SUBTRAI;
    }

    @Override
    public EnumConstModCbsIbsIndValorBC getIncluirDespAcessBC() {
        if (this.item.getParamTribCbsIbsClass() != null && this.item.getParamTribCbsIbsClass().getParamTribCbsIbs().getModeloFiscalCbsIbs() != null) {
            return EnumConstModCbsIbsIndValorBC.get((Object)this.item.getParamTribCbsIbsClass().getParamTribCbsIbs().getModeloFiscalCbsIbs().getIncluiDespAcessBC());
        }
        return EnumConstModCbsIbsIndValorBC.SOMA;
    }

    @Override
    public EnumConstTipoCalcImp getTipoCalculo() {
        return EnumConstTipoCalcImp.CALCULAR_NORMAL;
    }

    @Override
    public EnumConstTipoArredondamento getModoArredondamento() {
        return EnumConstTipoArredondamento.ROUND_HALF_UP;
    }

    @Override
    public ClassificacaoTributariaCbsIbs getClassificacaoTributariaCbsIbs() {
        return this.item.getCbs() != null ? this.item.getCbs().getIncidenciaTributariaClass() : null;
    }

    @Override
    public EnumConstModCbsIbsIndValorBC getIncluirCofinsBC() {
        if (this.item.getParamTribCbsIbsClass() != null && this.item.getParamTribCbsIbsClass().getParamTribCbsIbs().getModeloFiscalCbsIbs() != null) {
            return EnumConstModCbsIbsIndValorBC.get((Object)this.item.getParamTribCbsIbsClass().getParamTribCbsIbs().getModeloFiscalCbsIbs().getIncluiCofinsBC());
        }
        return EnumConstModCbsIbsIndValorBC.SUBTRAI;
    }

    @Override
    public EnumConstModCbsIbsIndValorBC getIncluirPisBC() {
        if (this.item.getParamTribCbsIbsClass() != null && this.item.getParamTribCbsIbsClass().getParamTribCbsIbs().getModeloFiscalCbsIbs() != null) {
            return EnumConstModCbsIbsIndValorBC.get((Object)this.item.getParamTribCbsIbsClass().getParamTribCbsIbs().getModeloFiscalCbsIbs().getIncluiPisBC());
        }
        return EnumConstModCbsIbsIndValorBC.SUBTRAI;
    }

    @Override
    public EnumConstModCbsIbsIndValorBC getIncluirIssBC() {
        if (this.item.getParamTribCbsIbsClass() != null && this.item.getParamTribCbsIbsClass().getParamTribCbsIbs().getModeloFiscalCbsIbs() != null) {
            return EnumConstModCbsIbsIndValorBC.get((Object)this.item.getParamTribCbsIbsClass().getParamTribCbsIbs().getModeloFiscalCbsIbs().getIncluiIssBC());
        }
        return EnumConstModCbsIbsIndValorBC.SUBTRAI;
    }

    @Override
    public EnumConstModCbsIbsIndValorBC getIncluirIcmsBC() {
        if (this.item.getParamTribCbsIbsClass() != null && this.item.getParamTribCbsIbsClass().getParamTribCbsIbs().getModeloFiscalCbsIbs() != null) {
            return EnumConstModCbsIbsIndValorBC.get((Object)this.item.getParamTribCbsIbsClass().getParamTribCbsIbs().getModeloFiscalCbsIbs().getIncluiIcmsBC());
        }
        return EnumConstModCbsIbsIndValorBC.SUBTRAI;
    }

    @Override
    public EnumConstModCbsIbsIndValorBC getIncluirImpostoSeletivoBC() {
        if (this.item.getParamTribCbsIbsClass() != null && this.item.getParamTribCbsIbsClass().getParamTribCbsIbs().getModeloFiscalCbsIbs() != null) {
            return EnumConstModCbsIbsIndValorBC.get((Object)this.item.getParamTribCbsIbsClass().getParamTribCbsIbs().getModeloFiscalCbsIbs().getIncluiImpostoSeletivoBC());
        }
        return EnumConstModCbsIbsIndValorBC.SUBTRAI;
    }

    @Override
    public Double getValorIcms() {
        if (this.item.getIcms() == null) {
            return 0.0;
        }
        return ToolNumber.asZeroIfNull((Double)this.item.getIcms().getValorIcms());
    }

    @Override
    public Double getValorPis() {
        if (this.item.getPis() == null) {
            return 0.0;
        }
        return ToolNumber.asZeroIfNull((Double)this.item.getPis().getValor());
    }

    @Override
    public Double getValorCofins() {
        if (this.item.getCofins() == null) {
            return 0.0;
        }
        return ToolNumber.asZeroIfNull((Double)this.item.getCofins().getValor());
    }

    @Override
    public Double getValorIpi() {
        if (this.item.getIpi() == null) {
            return 0.0;
        }
        return ToolNumber.asZeroIfNull((Double)this.item.getIpi().getValorIpiIndustria()) + ToolNumber.asZeroIfNull((Double)this.item.getIpi().getValorIpiComercio());
    }

    @Override
    public Double getValorIcmsST() {
        return 0.0;
    }

    @Override
    public ModeloFiscalCbsIbs getModeloFiscalCbsIbs() {
        if (this.item.getModeloFiscal() != null && this.item.getModeloFiscal().getModeloFiscalCbsIbs() != null) {
            return this.item.getModeloFiscal().getModeloFiscalCbsIbs();
        }
        if (this.item.getParamTribCbsIbsClass() != null) {
            return this.item.getParamTribCbsIbsClass().getParamTribCbsIbs().getModeloFiscalCbsIbs();
        }
        return null;
    }

    @Override
    public ClassificacaoTributariaCbsIbs getClassificacaoTributariaCbsIbsReg() {
        return this.itemCbs.getIncidenciaTributariaClassReg();
    }

    @Override
    public Double getValorIss() {
        return 0.0;
    }

    @Override
    public Double getImpostoSeletivo() {
        return 0.0;
    }

    @Override
    public Double getValorImpostoImportacao() {
        return 0.0;
    }

    @Override
    public ParamTribCbsIbsClass getParamTribCbsIbs() {
        return this.item.getParamTribCbsIbsClass();
    }

    @Override
    public void setAliquotaCBSReg(Double aliquota) {
        this.itemCbs.setAliquotaCBSReg(aliquota);
    }

    @Override
    public void setAliquotaEfetivaCBSReg(Double aliquotaEfetiva) {
        this.itemCbs.setAliquotaEfetivaCBSReg(aliquotaEfetiva);
    }

    @Override
    public void setValorCBSReg(Double valor) {
        this.itemCbs.setValorCBSReg(valor);
    }

    @Override
    public Double getAliquotaCBSReg() {
        return this.itemCbs.getAliquotaCBSReg();
    }

    @Override
    public void setValorDiferimento(Double valorDiferimento) {
        this.itemCbs.setValorDiferimentoCBS(valorDiferimento);
    }

    @Override
    public void setAliquotaDiferimento(Double percDiferimento) {
        this.itemCbs.setAliquotaDiferimentoCBS(percDiferimento);
    }

    @Override
    public void setPercRedAliquota(Double percRedAliquota) {
        this.itemCbs.setPercRedAliquotaCBS(percRedAliquota);
    }

    @Override
    public void setPercRedBC(Double percRedBC) {
        this.itemCbs.setPercRedBC(percRedBC);
    }

    @Override
    public Double getAliquotaDiferimentoCbs() {
        return this.itemCbs.getAliquotaDiferimentoCBS();
    }
}

