/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.touchnfce.helpers.impostos.cbs.calculo;

import com.touchcomp.basementor.constants.enums.modelocbsibs.EnumConstModCbsIbsIndValorBC;
import com.touchcomp.basementorrules.exceptions.ExceptionImpostoCbsIbs;
import com.touchcomp.basementorrules.impostos.cbsibs.CompImpostoCbsIbs;
import com.touchcomp.basementorrules.impostos.cbsibs.constants.EnumConstNFeIncidenciaCbsIbs;
import com.touchcomp.basementorrules.impostos.cbsibs.model.CbsIbsCalculado;
import com.touchcomp.basementorrules.impostos.cbsibs.model.CbsIbsParams;
import com.touchcomp.basementortools.tools.methods.ToolMethods;
import com.touchcomp.touchnfce.helpers.impostos.cbs.calculo.NFCeItemCBSCalcAdapter;
import com.touchcomp.touchnfce.helpers.impostos.cbs.calculo.adapter.CBSInterfaceCalculo;
import com.touchcomp.touchnfce.model.ClassificacaoTributariaCbsIbs;
import com.touchcomp.touchnfce.model.NFCeItem;
import com.touchcomp.touchnfce.model.NFCeItemCbs;

public class SCompCBScalculo {
    CompImpostoCbsIbs compCalculo = CompImpostoCbsIbs.get();

    public void calcular(NFCeItem item) throws ExceptionImpostoCbsIbs {
        if (item.getCbs() == null) {
            item.setCbs(new NFCeItemCbs());
        }
        this.calcularInternal(new NFCeItemCBSCalcAdapter(item));
    }

    private void calcularInternal(CBSInterfaceCalculo item) throws ExceptionImpostoCbsIbs {
        if (item.getClassificacaoTributariaCbsIbs() == null) {
            return;
        }
        CbsIbsParams params = this.buildParams(item, item.getClassificacaoTributariaCbsIbs(), item.getAliquotaCBS(), item.getPercRedAliquotaCBS());
        CbsIbsCalculado calc = this.compCalculo.calcular(params.build());
        item.setAliquotaCBS(calc.getAliquota());
        item.setBaseCalculoCBS(calc.getBaseCalculo());
        item.setAliquotaEfetivaCBS(calc.getAliquotaEfetiva());
        item.setValorCBS(calc.getValor());
        item.setValorDiferimento(calc.getValorDiferimento());
        item.setAliquotaDiferimento(calc.getAliquotaDiferimento());
        item.setPercRedAliquota(calc.getPercRedAliquota());
        item.setPercRedBC(calc.getPercRedBC());
        if (ToolMethods.isAffirmative((Number)item.getClassificacaoTributariaCbsIbs().getIndGrupoTribReg()) && item.getClassificacaoTributariaCbsIbsReg() != null) {
            params = this.buildParams(item, item.getClassificacaoTributariaCbsIbsReg(), item.getAliquotaCBSReg(), item.getClassificacaoTributariaCbsIbsReg().getPercRedAliquotaCBS());
            calc = this.compCalculo.calcular(params.build());
            item.setAliquotaCBSReg(calc.getAliquota());
            item.setAliquotaEfetivaCBSReg(calc.getAliquotaEfetiva());
            item.setValorCBSReg(calc.getValor());
        }
    }

    private CbsIbsParams buildParams(CBSInterfaceCalculo item, ClassificacaoTributariaCbsIbs classificacao, Double aliquotaCbs, Double percRedAliquotaCbs) {
        CbsIbsParams params = new CbsIbsParams();
        params.setAliquota(aliquotaCbs);
        params.setPercRedAliquota(item.getPercRedAliquotaCBS());
        params.setPercDiferimento(item.getAliquotaDiferimentoCbs());
        params.setIncluirFreteBC(item.getIncluirFreteBC());
        params.setIncluirSeguroBC(item.getIncluirSeguroBC());
        params.setIncluirValorDescontoBC(item.getIncluirDescontoBC());
        params.setIncluirValorDespAcessBC(item.getIncluirDespAcessBC());
        params.setIncluirValorCofinsBC(item.getIncluirCofinsBC());
        params.setIncluirValorIcmsBC(item.getIncluirIcmsBC());
        params.setIncluirValorIsBC(item.getIncluirImpostoSeletivoBC());
        params.setIncluirValorIssBC(item.getIncluirIssBC());
        params.setIncluirValorPisBC(item.getIncluirPisBC());
        params.setModoArredondamento(item.getModoArredondamento());
        params.setPercRedBC(item.getPercRedBC());
        params.setQuantidade(item.getQuantidade());
        params.setTipoCalculo(item.getTipoCalculo());
        params.setValorDesconto(item.getValorDesconto());
        params.setValorDespAcess(item.getValorDespAcess());
        params.setValorFrete(item.getValorFrete());
        params.setValorSeguro(item.getValorSeguro());
        params.setVrProdServ(item.getValorProdutosServicos());
        params.setIncidenciaCbsIbs(EnumConstNFeIncidenciaCbsIbs.valueOfCodigo((String)classificacao.getIncidenciaCbsIbs().getCodigo()));
        params.setCalcularCbsIbs(classificacao.getCalcularCbsIbs());
        params.setValorCofins(item.getValorCofins());
        params.setValorIcms(item.getValorIcms());
        params.setValorPis(item.getValorPis());
        params.setValorIss(item.getValorIss());
        params.setValorImpostoSeletivo(item.getImpostoSeletivo());
        params.setValorIpi(item.getValorIpi());
        params.setValorII(item.getValorImpostoImportacao());
        if (ToolMethods.isNotNull((Object)item.getModeloFiscalCbsIbs()).booleanValue()) {
            if (ToolMethods.isEquals((Object)item.getModeloFiscalCbsIbs().getIncluiIcmsSTBC(), (Object)EnumConstModCbsIbsIndValorBC.SOMA.getCodigo())) {
                params.setValorOutrosImpostosSoma(item.getValorIcmsST());
            } else if (ToolMethods.isEquals((Object)item.getModeloFiscalCbsIbs().getIncluiIcmsSTBC(), (Object)EnumConstModCbsIbsIndValorBC.SUBTRAI.getCodigo())) {
                params.setValorOutrosImpostosSubtrai(item.getValorIcmsST());
            }
        }
        return params;
    }
}

