/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.touchnfce.helpers.impostos.cbs.params;

import com.touchcomp.basementor.constants.enums.impostos.EnumConstantsTipoImp;
import com.touchcomp.basementor.constants.enums.impostos.cbsibs.EnumConstantsTipoAliqCBSIBS;
import com.touchcomp.basementorexceptions.exceptions.impl.invaliddata.ExceptionInvalidData;
import com.touchcomp.basementortools.tools.methods.ToolMethods;
import com.touchcomp.touchnfce.helpers.impostos.AuxSetParamsCbsIbs;
import com.touchcomp.touchnfce.helpers.impostos.AuxSetParamsCbsIbsOld;
import com.touchcomp.touchnfce.helpers.impostos.cbs.params.CBSInterfaceSetParams;
import com.touchcomp.touchnfce.helpers.impostos.cbs.params.adapter.NFCeItemCBSAdapter;
import com.touchcomp.touchnfce.model.ClassificacaoTributariaCbsIbs;
import com.touchcomp.touchnfce.model.Empresa;
import com.touchcomp.touchnfce.model.ModeloDocFiscal;
import com.touchcomp.touchnfce.model.ModeloFiscalCbsIbs;
import com.touchcomp.touchnfce.model.NFCeItem;
import com.touchcomp.touchnfce.model.NFCeItemCbs;
import java.util.Date;
import org.springframework.stereotype.Service;

@Service
public class SCompCBSParams {
    public void setParams(NFCeItem item, Empresa empresa, Date dataEmissao, ModeloDocFiscal modeloDocFiscal) throws ExceptionInvalidData {
        if (item.getCbs() == null) {
            item.setCbs(new NFCeItemCbs());
        }
        this.setParamsInternal(new NFCeItemCBSAdapter(item, empresa, dataEmissao, modeloDocFiscal));
    }

    void setParamsInternal(CBSInterfaceSetParams item) throws ExceptionInvalidData {
        if (item.getModeloFiscalCBSIBS() != null) {
            this.setParamsInternalOld(item);
        } else {
            this.setParamsInternalNew(item);
        }
    }

    void setParamsInternalNew(CBSInterfaceSetParams item) throws ExceptionInvalidData {
        if (item.getParamTribCBSIBS() == null) {
            return;
        }
        if (item.getEmpresa() == null) {
            return;
        }
        Date dataEmissao = item.getDataEmissao();
        if (item.getDataEmissao() == null) {
            dataEmissao = new Date();
        }
        AuxSetParamsCbsIbs auxSet = new AuxSetParamsCbsIbs();
        ClassificacaoTributariaCbsIbs incidenciaTributariaClass = item.getParamTribCBSIBS().getClassificacaoTrib();
        item.setClassificacaoCBS(incidenciaTributariaClass);
        item.setIncidenciaCBS(incidenciaTributariaClass.getIncidenciaCbsIbs());
        ModeloFiscalCbsIbs modelo = item.getParamTribCBSIBS().getParamTribCbsIbs().getModeloFiscalCbsIbs();
        Double percRedAliqCBS = incidenciaTributariaClass.getPercRedAliquotaCBS();
        if (ToolMethods.isEqualsNumber((Number)modelo.getTipoAliquota(), (Number)EnumConstantsTipoAliqCBSIBS.INFORMADA.getValue())) {
            percRedAliqCBS = modelo.getPercRedAliquotaCBS();
        }
        item.setAliquotaCBS(auxSet.getAliquota(dataEmissao, null, EnumConstantsTipoAliqCBSIBS.get((Object)modelo.getTipoAliquota()), EnumConstantsTipoImp.CBS, modelo.getAliquotaCBS()));
        item.setAliquotaPresumidaCBS(modelo.getAliquotaCBS());
        item.setPercRedAliquotaCBS(percRedAliqCBS);
        item.setPercRedBC(auxSet.getRedBC(incidenciaTributariaClass, modelo));
        item.setAliquotaDiferimento(modelo.getPercDiferimentoCBS());
        if (ToolMethods.isAffirmative((Number)incidenciaTributariaClass.getIndGrupoTribReg())) {
            item.setClassificacaoCBSReg(item.getParamTribCBSIBS().getParamTribCbsIbs().getModeloFiscalCbsIbs().getIncidenciaTributariaClassReg());
            item.setIncidenciaCBSReg(item.getParamTribCBSIBS().getParamTribCbsIbs().getModeloFiscalCbsIbs().getIncidenciaTributariaReg());
            item.setAliquotaCBSReg(auxSet.getAliquota(dataEmissao, null, EnumConstantsTipoAliqCBSIBS.CONFORME_PARAMETRIZACAO, EnumConstantsTipoImp.CBS, 0.0));
        } else {
            item.setClassificacaoCBSReg(null);
            item.setIncidenciaCBSReg(null);
            item.setAliquotaCBSReg(0.0);
        }
    }

    void setParamsInternalOld(CBSInterfaceSetParams item) throws ExceptionInvalidData {
        if (item.getModeloFiscalCBSIBS() == null) {
            return;
        }
        ModeloFiscalCbsIbs modelo = item.getModeloFiscalCBSIBS();
        if (modelo == null) {
            return;
        }
        if (item.getEmpresa() == null) {
            return;
        }
        Date dataEmissao = item.getDataEmissao();
        if (item.getDataEmissao() == null) {
            dataEmissao = new Date();
        }
        AuxSetParamsCbsIbsOld auxSet = new AuxSetParamsCbsIbsOld();
        item.setIncidenciaCBS(modelo.getIncidenciaTributaria());
        ClassificacaoTributariaCbsIbs incidenciaTributariaClass = modelo.getIncidenciaTributariaClass();
        if (incidenciaTributariaClass == null) {
            incidenciaTributariaClass = auxSet.getCodClassTributaria(dataEmissao, item.getEmpresa(), item.getNcm(), modelo, item.getModeloDocFiscal(), item.getCfop());
            item.setClassificacaoCBS(incidenciaTributariaClass);
        }
        Double percRedAliqCBS = incidenciaTributariaClass.getPercRedAliquotaCBS();
        if (ToolMethods.isEqualsNumber((Number)modelo.getTipoAliquota(), (Number)EnumConstantsTipoAliqCBSIBS.INFORMADA.getValue())) {
            percRedAliqCBS = modelo.getPercRedAliquotaCBS();
        }
        item.setClassificacaoCBS(modelo.getIncidenciaTributariaClass());
        item.setAliquotaCBS(auxSet.getAliquota(dataEmissao, null, modelo, EnumConstantsTipoImp.CBS, modelo.getAliquotaCBS()));
        item.setAliquotaPresumidaCBS(modelo.getAliquotaCBS());
        item.setAliquotaDiferimento(modelo.getPercDiferimentoCBS());
        item.setPercRedAliquotaCBS(percRedAliqCBS);
        item.setPercRedBC(auxSet.getRedBC(incidenciaTributariaClass, modelo));
        item.setClassificacaoCBS(incidenciaTributariaClass);
    }
}

