/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.touchnfce.helpers.impostos.cbs.params.adapter;

import com.touchcomp.basementor.constants.enums.modelodocfiscal.EnumConstModDocFiscal;
import com.touchcomp.touchnfce.helpers.impostos.cbs.params.CBSInterfaceSetParams;
import com.touchcomp.touchnfce.model.Cfop;
import com.touchcomp.touchnfce.model.ClassificacaoTributariaCbsIbs;
import com.touchcomp.touchnfce.model.Empresa;
import com.touchcomp.touchnfce.model.IncidenciaCbsIbs;
import com.touchcomp.touchnfce.model.ModeloDocFiscal;
import com.touchcomp.touchnfce.model.ModeloFiscalCbsIbs;
import com.touchcomp.touchnfce.model.NFCeItem;
import com.touchcomp.touchnfce.model.Ncm;
import com.touchcomp.touchnfce.model.ParamTribCbsIbsClass;
import java.util.Date;

public class NFCeItemCBSAdapter
implements CBSInterfaceSetParams {
    final NFCeItem item;
    final Empresa empresa;
    final Date dataEmissao;
    final ModeloDocFiscal modeloDocFiscal;

    public NFCeItemCBSAdapter(NFCeItem item, Empresa empresa, Date dataEmissao, ModeloDocFiscal modeloDocFiscal) {
        this.item = item;
        this.empresa = empresa;
        this.dataEmissao = dataEmissao;
        this.modeloDocFiscal = modeloDocFiscal;
    }

    @Override
    public void setIncidenciaCBS(IncidenciaCbsIbs incidencia) {
        this.item.getCbs().setIncidenciaTributaria(incidencia);
    }

    @Override
    public void setClassificacaoCBS(ClassificacaoTributariaCbsIbs classificacao) {
        this.item.getCbs().setIncidenciaTributariaClass(classificacao);
    }

    @Override
    public void setAliquotaCBS(Double aliquota) {
        this.item.getCbs().setAliquotaCBS(aliquota);
    }

    @Override
    public void setAliquotaPresumidaCBS(Double aliquotaPresumida) {
        this.item.getCbs().setAliquotaCredPresumidoCBS(aliquotaPresumida);
    }

    @Override
    public void setPercRedAliquotaCBS(Double percRedAliquotaCBS) {
        this.item.getCbs().setPercRedAliquotaCBS(percRedAliquotaCBS);
    }

    @Override
    public ModeloFiscalCbsIbs getModeloFiscalCBSIBS() {
        if (this.item.getModeloFiscal() != null) {
            return this.item.getModeloFiscal().getModeloFiscalCbsIbs();
        }
        return null;
    }

    @Override
    public Empresa getEmpresa() {
        return this.empresa;
    }

    @Override
    public Date getDataEmissao() {
        return this.dataEmissao;
    }

    @Override
    public Ncm getNcm() {
        return this.item.getProduto() != null ? this.item.getProduto().getNcm() : null;
    }

    @Override
    public EnumConstModDocFiscal getModeloDocFiscal() {
        return EnumConstModDocFiscal.get((Object)this.modeloDocFiscal.getCodigo());
    }

    @Override
    public void setPercRedBC(Double percRedBC) {
        this.item.getCbs().setPercRedBC(percRedBC);
    }

    @Override
    public Cfop getCfop() {
        return this.item.getCfop();
    }

    @Override
    public ClassificacaoTributariaCbsIbs getClassificacaoTributariaCbsIbs() {
        return this.item.getParamTribCbsIbsClass() != null ? this.item.getParamTribCbsIbsClass().getClassificacaoTrib() : null;
    }

    @Override
    public ParamTribCbsIbsClass getParamTribCBSIBS() {
        return this.item.getParamTribCbsIbsClass();
    }

    @Override
    public void setClassificacaoCBSReg(ClassificacaoTributariaCbsIbs incidenciaTributariaClassReg) {
        this.item.getCbs().setIncidenciaTributariaClassReg(incidenciaTributariaClassReg);
    }

    @Override
    public void setIncidenciaCBSReg(IncidenciaCbsIbs incidenciaTributariaReg) {
        this.item.getCbs().setIncidenciaTributariaReg(incidenciaTributariaReg);
    }

    @Override
    public void setAliquotaCBSReg(Double aliquota) {
        this.item.getCbs().setAliquotaCBSReg(aliquota);
    }

    @Override
    public void setAliquotaDiferimento(Double percDiferimentoCBS) {
        this.item.getCbs().setAliquotaDiferimentoCBS(percDiferimentoCBS);
    }
}

