/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.touchnfce.helpers.impostos.ibs.calculo;

import com.touchcomp.basementor.constants.enums.modelocbsibs.EnumConstModCbsIbsIndValorBC;
import com.touchcomp.basementorrules.exceptions.ExceptionImpostoCbsIbs;
import com.touchcomp.basementorrules.impostos.cbsibs.CompImpostoCbsIbs;
import com.touchcomp.basementorrules.impostos.cbsibs.constants.EnumConstNFeIncidenciaCbsIbs;
import com.touchcomp.basementorrules.impostos.cbsibs.model.CbsIbsCalculado;
import com.touchcomp.basementorrules.impostos.cbsibs.model.CbsIbsParams;
import com.touchcomp.basementortools.tools.methods.ToolMethods;
import com.touchcomp.touchnfce.helpers.impostos.ibs.calculo.IBSInterfaceCalculo;
import com.touchcomp.touchnfce.helpers.impostos.ibs.calculo.adapters.NFCeItemIBSCalcAdapter;
import com.touchcomp.touchnfce.model.ClassificacaoTributariaCbsIbs;
import com.touchcomp.touchnfce.model.NFCeItem;
import com.touchcomp.touchnfce.model.NFCeItemIbs;

public class SCompIBScalculo {
    CompImpostoCbsIbs compCalculo = CompImpostoCbsIbs.get();

    public void calcular(NFCeItem item) throws ExceptionImpostoCbsIbs {
        if (item.getIbs() == null) {
            item.setIbs(new NFCeItemIbs());
        }
        this.calcularValores(new NFCeItemIBSCalcAdapter(item));
    }

    protected void calcularValores(IBSInterfaceCalculo item) throws ExceptionImpostoCbsIbs {
        CbsIbsParams params = new CbsIbsParams();
        if (item.getClassificacaoTributariaCbsIbs() == null) {
            return;
        }
        if (item.getModeloFiscalCbsIbs() == null) {
            return;
        }
        this.buildCommonParamsIbsMun(item, params);
        CbsIbsCalculado calc = this.compCalculo.calcular(params.build());
        item.setAliquotaIBSMun(calc.getAliquota());
        item.setAliquotaEfetivaIBSMun(calc.getAliquotaEfetiva());
        item.setValorBaseCalcIBS(calc.getBaseCalculo());
        item.setValorIBSMun(calc.getValor());
        item.setValorDiferimentoIBSMun(calc.getValorDiferimento());
        item.setAliquotaDiferimentoIBSMun(calc.getAliquotaDiferimento());
        item.setPercRedAliquotaIBSMun(calc.getPercRedAliquota());
        item.setPercRedBCIBSMun(calc.getPercRedBC());
        if (ToolMethods.isAffirmative((Number)item.getClassificacaoTributariaCbsIbs().getIndGrupoTribReg()) && item.getClassificacaoTributariaCbsIbsReg() != null) {
            params = new CbsIbsParams();
            this.buildCommonParamsIbsMunReg(item, params);
            calc = this.compCalculo.calcular(params.build());
            item.setAliquotaEfetivaIBSMunReg(calc.getAliquotaEfetiva());
            item.setValorIBSMunReg(calc.getValor());
        }
        this.buildCommonParamsIbsUF(item, params);
        calc = this.compCalculo.calcular(params.build());
        item.setAliquotaIBSUF(calc.getAliquota());
        item.setAliquotaEfetivaIBSUF(calc.getAliquotaEfetiva());
        item.setValorBaseCalcIBS(calc.getBaseCalculo());
        item.setValorIBSUF(calc.getValor());
        item.setValorDiferimentoIBSUF(calc.getValorDiferimento());
        item.setAliquotaDiferimentoIBSUF(calc.getAliquotaDiferimento());
        item.setPercRedAliquotaIBSUF(calc.getPercRedAliquota());
        item.setPercRedBCIBSUF(calc.getPercRedBC());
        if (ToolMethods.isAffirmative((Number)item.getClassificacaoTributariaCbsIbs().getIndGrupoTribReg()) && item.getClassificacaoTributariaCbsIbsReg() != null) {
            params = new CbsIbsParams();
            this.buildCommonParamsIbsUFReg(item, params);
            calc = this.compCalculo.calcular(params.build());
            item.setAliquotaEfetivaIBSUFReg(calc.getAliquotaEfetiva());
            item.setValorIBSUFReg(calc.getValor());
        }
    }

    void buildCommonParams(IBSInterfaceCalculo item, CbsIbsParams params, ClassificacaoTributariaCbsIbs classificacao) {
        params.setIncluirFreteBC(item.getIncluirFreteBC());
        params.setIncluirSeguroBC(item.getIncluirSeguroBC());
        params.setIncluirValorDescontoBC(item.getIncluirDescontoBC());
        params.setIncluirValorDespAcessBC(item.getIncluirDespAcessBC());
        params.setIncluirValorCofinsBC(item.getIncluirCofinsBC());
        params.setIncluirValorIcmsBC(item.getIncluirIcmsBC());
        params.setIncluirValorIsBC(item.getIncluirImpostoSeletivoBC());
        params.setIncluirValorIssBC(item.getIncluirIssBC());
        params.setIncluirValorPisBC(item.getIncluirPisBC());
        params.setIncluirValorIpiBC(EnumConstModCbsIbsIndValorBC.get((Object)item.getModeloFiscalCbsIbs().getIncluiIpiBC()));
        params.setIncluirValorIIBC(EnumConstModCbsIbsIndValorBC.get((Object)item.getModeloFiscalCbsIbs().getIncluiIIBC()));
        params.setModoArredondamento(item.getModoArredondamento());
        params.setTipoCalculo(item.getTipoCalculo());
        params.setPercRedBC(item.getPercRedBC());
        params.setQuantidade(item.getQuantidade());
        params.setTipoCalculo(item.getTipoCalculo());
        params.setValorDesconto(item.getValorDesconto());
        params.setValorDespAcess(item.getValorDespAcess());
        params.setValorFrete(item.getValorFrete());
        params.setValorSeguro(item.getValorSeguro());
        params.setVrProdServ(item.getValorProdutosServicos());
        params.setValorIss(item.getValorIss());
        params.setValorIcms(item.getValorIcms());
        params.setValorImpostoSeletivo(item.getImpostoSeletivo());
        params.setValorPis(item.getValorPis());
        params.setValorCofins(item.getValorCofins());
        params.setValorIpi(item.getValorIpi());
        params.setValorII(item.getValorImpostoImportacao());
        if (ToolMethods.isEquals((Object)item.getModeloFiscalCbsIbs().getIncluiIcmsSTBC(), (Object)EnumConstModCbsIbsIndValorBC.SOMA.getCodigo())) {
            params.setValorOutrosImpostosSoma(item.getValorIcmsST());
        } else if (ToolMethods.isEquals((Object)item.getModeloFiscalCbsIbs().getIncluiIcmsSTBC(), (Object)EnumConstModCbsIbsIndValorBC.SUBTRAI.getCodigo())) {
            params.setValorOutrosImpostosSubtrai(item.getValorIcmsST());
        }
        params.setIncidenciaCbsIbs(EnumConstNFeIncidenciaCbsIbs.valueOfCodigo((String)classificacao.getIncidenciaCbsIbs().getCodigo()));
        params.setCalcularCbsIbs(classificacao.getCalcularCbsIbs());
    }

    void buildCommonParamsIbsUF(IBSInterfaceCalculo item, CbsIbsParams params) {
        this.buildCommonParams(item, params, item.getClassificacaoTributariaCbsIbs());
        params.setAliquota(item.getAliquotaIBSUF());
        params.setPercDiferimento(item.getAliquotaDiferimentoIBSUF());
        params.setPercRedAliquota(item.getPercRedAliquotaIBSUF());
    }

    void buildCommonParamsIbsMun(IBSInterfaceCalculo item, CbsIbsParams params) {
        this.buildCommonParams(item, params, item.getClassificacaoTributariaCbsIbs());
        params.setAliquota(item.getAliquotaIBSMun());
        params.setPercDiferimento(item.getAliquotaDiferimentoIBSMun());
        params.setPercRedAliquota(item.getPercRedAliquotaIBSMun());
    }

    void buildCommonParamsIbsUFReg(IBSInterfaceCalculo item, CbsIbsParams params) {
        this.buildCommonParams(item, params, item.getClassificacaoTributariaCbsIbsReg());
        params.setAliquota(item.getAliquotaIBSUFReg());
        params.setPercRedAliquota(item.getClassificacaoTributariaCbsIbsReg().getPercRedAliquotaIBSUF());
    }

    void buildCommonParamsIbsMunReg(IBSInterfaceCalculo item, CbsIbsParams params) {
        this.buildCommonParams(item, params, item.getClassificacaoTributariaCbsIbsReg());
        params.setAliquota(item.getAliquotaIBSMunReg());
        params.setPercRedAliquota(item.getClassificacaoTributariaCbsIbsReg().getPercRedAliquotaIBSMun());
    }
}

