/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.touchnfce.helpers.impostos.ibs.calculo.adapters;

import com.touchcomp.basementor.constants.enums.modelocbsibs.EnumConstModCbsIbsIndValorBC;
import com.touchcomp.basementor.constants.enums.number.EnumConstTipoArredondamento;
import com.touchcomp.basementorrules.constants.EnumConstTipoCalcImp;
import com.touchcomp.touchnfce.helpers.impostos.ibs.calculo.IBSInterfaceCalculo;
import com.touchcomp.touchnfce.model.ClassificacaoTributariaCbsIbs;
import com.touchcomp.touchnfce.model.ModeloFiscalCbsIbs;
import com.touchcomp.touchnfce.model.NFCeItem;
import com.touchcomp.touchnfce.model.NFCeItemIbs;
import com.touchcomp.touchnfce.model.ParamTribCbsIbsClass;

public class NFCeItemIBSCalcAdapter
implements IBSInterfaceCalculo {
    final NFCeItem item;
    final NFCeItemIbs itemIbs;

    public NFCeItemIBSCalcAdapter(NFCeItem item) {
        this.item = item;
        this.itemIbs = item.getIbs();
    }

    @Override
    public Double getPercRedBC() {
        return 0.0;
    }

    @Override
    public Double getQuantidade() {
        return this.item.getQuantidadeComercial();
    }

    @Override
    public Double getValorDesconto() {
        return this.item.getValorDesconto();
    }

    @Override
    public Double getValorDespAcess() {
        return this.item.getValorDespesasAcessorias();
    }

    @Override
    public Double getValorFrete() {
        return this.item.getValorFrete();
    }

    @Override
    public Double getValorSeguro() {
        return this.item.getValorSeguro();
    }

    @Override
    public EnumConstTipoCalcImp getTipoCalculo() {
        return EnumConstTipoCalcImp.CALCULAR_NORMAL;
    }

    @Override
    public EnumConstTipoArredondamento getModoArredondamento() {
        return EnumConstTipoArredondamento.ROUND_HALF_UP;
    }

    @Override
    public void setAliquotaIBSMun(double aliquota) {
        this.itemIbs.setAliquotaIBSMun(aliquota);
    }

    @Override
    public void setAliquotaIBSUF(double aliquota) {
        this.itemIbs.setAliquotaIBSUF(aliquota);
    }

    @Override
    public void setValorBaseCalcIBS(double baseCalculo) {
        this.itemIbs.setValorBaseCalcIBS(baseCalculo);
    }

    @Override
    public void setValorIBSMun(double valor) {
        this.itemIbs.setValorIBSMun(valor);
    }

    @Override
    public void setValorIBSUF(double valor) {
        this.itemIbs.setValorIBSUF(valor);
    }

    @Override
    public Double getAliquotaIBSMun() {
        return this.itemIbs.getAliquotaIBSMun();
    }

    @Override
    public Double getAliquotaIBSUF() {
        return this.itemIbs.getAliquotaIBSUF();
    }

    @Override
    public Double getPercRedAliquotaIBSMun() {
        return this.itemIbs.getPercRedAliquotaIBSMun();
    }

    @Override
    public Double getPercRedAliquotaIBSUF() {
        return this.itemIbs.getPercRedAliquotaIBSUF();
    }

    @Override
    public Double getValorProdutosServicos() {
        return this.item.getValorTotalBruto();
    }

    @Override
    public ClassificacaoTributariaCbsIbs getClassificacaoTributariaCbsIbs() {
        return this.item.getIbs() != null ? this.item.getIbs().getIncidenciaTributariaClass() : null;
    }

    @Override
    public Double getValorIss() {
        return 0.0;
    }

    @Override
    public Double getValorIcms() {
        if (this.item.getIcms() == null) {
            return 0.0;
        }
        return this.item.getIcms().getValorIcms();
    }

    @Override
    public Double getImpostoSeletivo() {
        return 0.0;
    }

    @Override
    public Double getValorPis() {
        if (this.item.getPis() == null) {
            return 0.0;
        }
        return this.item.getPis().getValor();
    }

    @Override
    public Double getValorCofins() {
        if (this.item.getCofins() == null) {
            return 0.0;
        }
        return this.item.getCofins().getValor();
    }

    @Override
    public Double getValorIpi() {
        if (this.item.getIpi() == null) {
            return 0.0;
        }
        return this.item.getIpi().getValorIpiIndustria() + this.item.getIpi().getValorIpiComercio();
    }

    @Override
    public Double getValorImpostoImportacao() {
        return 0.0;
    }

    @Override
    public void setAliquotaEfetivaIBSMun(double aliquota) {
        this.itemIbs.setAliquotaEfetivaIBSMun(aliquota);
    }

    @Override
    public void setAliquotaEfetivaIBSUF(double aliquota) {
        this.itemIbs.setAliquotaEfetivaIBSUF(aliquota);
    }

    @Override
    public ParamTribCbsIbsClass getParamTribCbsIbs() {
        return this.item.getParamTribCbsIbsClass();
    }

    @Override
    public ClassificacaoTributariaCbsIbs getClassificacaoTributariaCbsIbsReg() {
        return this.itemIbs.getIncidenciaTributariaClass();
    }

    @Override
    public Double getAliquotaIBSUFReg() {
        return this.itemIbs.getAliquotaIBSUFReg();
    }

    @Override
    public Double getAliquotaIBSMunReg() {
        return this.itemIbs.getAliquotaIBSMunReg();
    }

    @Override
    public void setAliquotaEfetivaIBSUFReg(Double aliquotaEfetiva) {
        this.itemIbs.setAliquotaEfetivaIBSUFReg(aliquotaEfetiva);
    }

    @Override
    public void setValorIBSUFReg(Double valor) {
        this.itemIbs.setValorIBSUFReg(valor);
    }

    @Override
    public void setAliquotaEfetivaIBSMunReg(Double aliquotaEfetiva) {
        this.itemIbs.setAliquotaEfetivaIBSMunReg(aliquotaEfetiva);
    }

    @Override
    public void setValorIBSMunReg(Double valor) {
        this.itemIbs.setValorIBSMunReg(valor);
    }

    @Override
    public ModeloFiscalCbsIbs getModeloFiscalCbsIbs() {
        if (this.item.getModeloFiscal() != null && this.item.getModeloFiscal().getModeloFiscalCbsIbs() != null) {
            return this.item.getModeloFiscal().getModeloFiscalCbsIbs();
        }
        if (this.item.getParamTribCbsIbsClass() != null) {
            return this.item.getParamTribCbsIbsClass().getParamTribCbsIbs().getModeloFiscalCbsIbs();
        }
        return null;
    }

    @Override
    public Double getValorIcmsST() {
        return 0.0;
    }

    @Override
    public Double getAliquotaDiferimentoIBSUF() {
        return this.itemIbs.getAliquotaDiferimentoIBSUF();
    }

    @Override
    public Double getAliquotaDiferimentoIBSMun() {
        return this.itemIbs.getAliquotaDiferimentoIBSMun();
    }

    @Override
    public void setPercRedBCIBSMun(Double percRedBC) {
        this.itemIbs.setPercRedBC(percRedBC);
    }

    @Override
    public void setPercRedAliquotaIBSMun(Double percRedAliquota) {
        this.itemIbs.setPercRedAliquotaIBSMun(percRedAliquota);
    }

    @Override
    public void setAliquotaDiferimentoIBSMun(Double percDiferimento) {
        this.itemIbs.setAliquotaDiferimentoIBSMun(percDiferimento);
    }

    @Override
    public void setValorDiferimentoIBSMun(Double valorDiferimento) {
        this.itemIbs.setValorDiferimentoIBSMun(valorDiferimento);
    }

    @Override
    public void setValorDiferimentoIBSUF(Double valorDiferimento) {
        this.itemIbs.setValorDiferimentoIBSUF(valorDiferimento);
    }

    @Override
    public void setAliquotaDiferimentoIBSUF(Double percDiferimento) {
        this.itemIbs.setAliquotaDiferimentoIBSUF(percDiferimento);
    }

    @Override
    public void setPercRedAliquotaIBSUF(Double percRedAliquota) {
        this.itemIbs.setPercRedAliquotaIBSUF(percRedAliquota);
    }

    @Override
    public void setPercRedBCIBSUF(Double percRedBC) {
        this.itemIbs.setPercRedBC(percRedBC);
    }

    @Override
    public EnumConstModCbsIbsIndValorBC getIncluirFreteBC() {
        if (this.item.getParamTribCbsIbsClass() != null && this.item.getParamTribCbsIbsClass().getParamTribCbsIbs().getModeloFiscalCbsIbs() != null) {
            return EnumConstModCbsIbsIndValorBC.get((Object)this.item.getParamTribCbsIbsClass().getParamTribCbsIbs().getModeloFiscalCbsIbs().getIncluiFreteBC());
        }
        return EnumConstModCbsIbsIndValorBC.SOMA;
    }

    @Override
    public EnumConstModCbsIbsIndValorBC getIncluirSeguroBC() {
        if (this.item.getParamTribCbsIbsClass() != null && this.item.getParamTribCbsIbsClass().getParamTribCbsIbs().getModeloFiscalCbsIbs() != null) {
            return EnumConstModCbsIbsIndValorBC.get((Object)this.item.getParamTribCbsIbsClass().getParamTribCbsIbs().getModeloFiscalCbsIbs().getIncluiSeguroBC());
        }
        return EnumConstModCbsIbsIndValorBC.SOMA;
    }

    @Override
    public EnumConstModCbsIbsIndValorBC getIncluirDescontoBC() {
        if (this.item.getParamTribCbsIbsClass() != null && this.item.getParamTribCbsIbsClass().getParamTribCbsIbs().getModeloFiscalCbsIbs() != null) {
            return EnumConstModCbsIbsIndValorBC.get((Object)this.item.getParamTribCbsIbsClass().getParamTribCbsIbs().getModeloFiscalCbsIbs().getIncluiDescontoBC());
        }
        return EnumConstModCbsIbsIndValorBC.SUBTRAI;
    }

    @Override
    public EnumConstModCbsIbsIndValorBC getIncluirDespAcessBC() {
        if (this.item.getParamTribCbsIbsClass() != null && this.item.getParamTribCbsIbsClass().getParamTribCbsIbs().getModeloFiscalCbsIbs() != null) {
            return EnumConstModCbsIbsIndValorBC.get((Object)this.item.getParamTribCbsIbsClass().getParamTribCbsIbs().getModeloFiscalCbsIbs().getIncluiDespAcessBC());
        }
        return EnumConstModCbsIbsIndValorBC.SOMA;
    }

    @Override
    public EnumConstModCbsIbsIndValorBC getIncluirCofinsBC() {
        if (this.item.getParamTribCbsIbsClass() != null && this.item.getParamTribCbsIbsClass().getParamTribCbsIbs().getModeloFiscalCbsIbs() != null) {
            return EnumConstModCbsIbsIndValorBC.get((Object)this.item.getParamTribCbsIbsClass().getParamTribCbsIbs().getModeloFiscalCbsIbs().getIncluiCofinsBC());
        }
        return EnumConstModCbsIbsIndValorBC.SUBTRAI;
    }

    @Override
    public EnumConstModCbsIbsIndValorBC getIncluirPisBC() {
        if (this.item.getParamTribCbsIbsClass() != null && this.item.getParamTribCbsIbsClass().getParamTribCbsIbs().getModeloFiscalCbsIbs() != null) {
            return EnumConstModCbsIbsIndValorBC.get((Object)this.item.getParamTribCbsIbsClass().getParamTribCbsIbs().getModeloFiscalCbsIbs().getIncluiPisBC());
        }
        return EnumConstModCbsIbsIndValorBC.SUBTRAI;
    }

    @Override
    public EnumConstModCbsIbsIndValorBC getIncluirIssBC() {
        if (this.item.getParamTribCbsIbsClass() != null && this.item.getParamTribCbsIbsClass().getParamTribCbsIbs().getModeloFiscalCbsIbs() != null) {
            return EnumConstModCbsIbsIndValorBC.get((Object)this.item.getParamTribCbsIbsClass().getParamTribCbsIbs().getModeloFiscalCbsIbs().getIncluiIssBC());
        }
        return EnumConstModCbsIbsIndValorBC.SUBTRAI;
    }

    @Override
    public EnumConstModCbsIbsIndValorBC getIncluirIcmsBC() {
        if (this.item.getParamTribCbsIbsClass() != null && this.item.getParamTribCbsIbsClass().getParamTribCbsIbs().getModeloFiscalCbsIbs() != null) {
            return EnumConstModCbsIbsIndValorBC.get((Object)this.item.getParamTribCbsIbsClass().getParamTribCbsIbs().getModeloFiscalCbsIbs().getIncluiIcmsBC());
        }
        return EnumConstModCbsIbsIndValorBC.SUBTRAI;
    }

    @Override
    public EnumConstModCbsIbsIndValorBC getIncluirImpostoSeletivoBC() {
        if (this.item.getParamTribCbsIbsClass() != null && this.item.getParamTribCbsIbsClass().getParamTribCbsIbs().getModeloFiscalCbsIbs() != null) {
            return EnumConstModCbsIbsIndValorBC.get((Object)this.item.getParamTribCbsIbsClass().getParamTribCbsIbs().getModeloFiscalCbsIbs().getIncluiImpostoSeletivoBC());
        }
        return EnumConstModCbsIbsIndValorBC.SUBTRAI;
    }
}

