/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.touchnfce.model;

import com.touchcomp.basementor.constants.enums.nfce.EnumConstNFCeTipoMovimentoCaixa;
import com.touchcomp.basementortools.tools.date.ToolDate;
import com.touchcomp.basementortools.tools.formatter.ToolFormatter;
import com.touchcomp.basementortools.tools.vo.ToolBaseMethodsVO;
import com.touchcomp.touchnfce.model.NFCeControleCaixa;
import java.io.Serializable;
import java.sql.Timestamp;
import java.util.Date;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.ForeignKey;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import javax.persistence.UniqueConstraint;
import javax.persistence.Version;
import lombok.Generated;

@Entity
@Table(name="nfce_movimento_caixa", uniqueConstraints={@UniqueConstraint(name="UK_nfce_mov_cai_SERIAL_F_SINC", columnNames={"serial_for_sinc"})})
public class NFCeMovimentoCaixa
implements Serializable {
    @Id
    @Column(name="ID_nfce_movimento_caixa")
    @GeneratedValue(generator="sequence", strategy=GenerationType.AUTO)
    @SequenceGenerator(sequenceName="GEN_NFCE_MOV_CAIXA", name="sequence")
    private Long identificador;
    @Temporal(value=TemporalType.TIMESTAMP)
    @Column(name="DATA_MOVIMENTO", nullable=false)
    private Date dataMovimento = new Date();
    @Column(name="TIPO_MOVIMENTO", nullable=false)
    private Integer tipoMovimento = EnumConstNFCeTipoMovimentoCaixa.ENTRADA_SUPRIMENTO.getValue();
    @Column(name="VALOR", nullable=false, precision=15, scale=2)
    private Double valor = 0.0;
    @ManyToOne
    @JoinColumn(name="ID_CONTROLE_CAIXA", nullable=false, foreignKey=@ForeignKey(name="FK_MOV_CX_NFCE_CONT_CX"))
    private NFCeControleCaixa controleCaixa;
    @Column(name="serial_for_sinc", nullable=false, length=100)
    private String serialForSinc;
    @Version
    @Column(name="data_atualizacao")
    private Timestamp dataAtualizacao;
    @Column(name="identificador_erp")
    private Long identificadorERP;
    @Column(name="status_sinc_erp")
    private Short statusSincERP = 0;
    @Column(name="OBSERVACAO", length=500)
    private String observacao;

    public boolean equals(Object other) {
        return ToolBaseMethodsVO.equalsVO((Object)this, (Object)other);
    }

    public String toString() {
        return ToolBaseMethodsVO.toString((String)"{0} ({1}):{2} ", (Object[])new Object[]{this.getControleCaixa() != null ? this.getControleCaixa().getUsuario() : null, ToolDate.dateToStr((Date)this.getDataMovimento()), ToolFormatter.formataNumero((Number)this.getValor(), (int)2)});
    }

    public int hashCode() {
        return ToolBaseMethodsVO.hashCode((Number)this.getIdentificador());
    }

    @Generated
    public Long getIdentificador() {
        return this.identificador;
    }

    @Generated
    public Date getDataMovimento() {
        return this.dataMovimento;
    }

    @Generated
    public Integer getTipoMovimento() {
        return this.tipoMovimento;
    }

    @Generated
    public Double getValor() {
        return this.valor;
    }

    @Generated
    public NFCeControleCaixa getControleCaixa() {
        return this.controleCaixa;
    }

    @Generated
    public String getSerialForSinc() {
        return this.serialForSinc;
    }

    @Generated
    public Timestamp getDataAtualizacao() {
        return this.dataAtualizacao;
    }

    @Generated
    public Long getIdentificadorERP() {
        return this.identificadorERP;
    }

    @Generated
    public Short getStatusSincERP() {
        return this.statusSincERP;
    }

    @Generated
    public String getObservacao() {
        return this.observacao;
    }

    @Generated
    public void setIdentificador(Long identificador) {
        this.identificador = identificador;
    }

    @Generated
    public void setDataMovimento(Date dataMovimento) {
        this.dataMovimento = dataMovimento;
    }

    @Generated
    public void setTipoMovimento(Integer tipoMovimento) {
        this.tipoMovimento = tipoMovimento;
    }

    @Generated
    public void setValor(Double valor) {
        this.valor = valor;
    }

    @Generated
    public void setControleCaixa(NFCeControleCaixa controleCaixa) {
        this.controleCaixa = controleCaixa;
    }

    @Generated
    public void setSerialForSinc(String serialForSinc) {
        this.serialForSinc = serialForSinc;
    }

    @Generated
    public void setDataAtualizacao(Timestamp dataAtualizacao) {
        this.dataAtualizacao = dataAtualizacao;
    }

    @Generated
    public void setIdentificadorERP(Long identificadorERP) {
        this.identificadorERP = identificadorERP;
    }

    @Generated
    public void setStatusSincERP(Short statusSincERP) {
        this.statusSincERP = statusSincERP;
    }

    @Generated
    public void setObservacao(String observacao) {
        this.observacao = observacao;
    }
}

