/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.touchnfce.model;

import com.touchcomp.basementortools.tools.vo.ToolBaseMethodsVO;
import com.touchcomp.touchnfce.model.BandeiraCartaoNFe;
import com.touchcomp.touchnfce.model.BandeiraTEF;
import com.touchcomp.touchnfce.model.CondicoesPagamento;
import com.touchcomp.touchnfce.model.MeioPagamento;
import com.touchcomp.touchnfce.model.NFCe;
import com.touchcomp.touchnfce.model.NFCeChequeTerceiros;
import com.touchcomp.touchnfce.model.NFCePagamentoCDC;
import com.touchcomp.touchnfce.model.NFCeTitulo;
import com.touchcomp.touchnfce.model.Pessoa;
import com.touchcomp.touchnfce.model.TipoPagamentoNFe;
import java.io.Serializable;
import java.util.LinkedList;
import java.util.List;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.ForeignKey;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import lombok.Generated;

@Entity
@Table(name="NFCE_PAGAMENTO")
public class NFCePagamento
implements Serializable {
    @Id
    @Column(name="ID_NFCE_PAGAMENTO", nullable=false)
    @GeneratedValue(generator="sequence", strategy=GenerationType.AUTO)
    @SequenceGenerator(name="sequence", sequenceName="GEN_NFCE_PAGAMENTO")
    private Long identificador;
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_CONDICOES_PAGAMENTO", foreignKey=@ForeignKey(name="FK_NFCE_PAG_COND_PAG"))
    private CondicoesPagamento condicoesPagamento;
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_MEIO_PAGAMENTO", foreignKey=@ForeignKey(name="FK_NFCE_PAG_MEIO_PAG"))
    private MeioPagamento meioPagamento;
    @Column(name="valor", precision=15, scale=2)
    private Double valor = 0.0;
    @Column(name="valor_troco", precision=15, scale=2)
    private Double valorTroco = 0.0;
    @Column(name="valor_liquido", precision=15, scale=2)
    private Double valorLiquido = 0.0;
    @Column(name="nr_autorizacao", length=100)
    private String nrAutorizacao;
    @Column(name="status")
    private Short status = 1;
    @OneToMany(mappedBy="nfcePagamento", cascade={CascadeType.ALL}, orphanRemoval=true)
    private List<NFCeTitulo> titulos;
    @OneToMany(mappedBy="nfcePagamento", cascade={CascadeType.ALL}, orphanRemoval=true)
    private List<NFCeChequeTerceiros> chequeTerceiros = new LinkedList<NFCeChequeTerceiros>();
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_TIPO_PAGAMENTO_NFE", foreignKey=@ForeignKey(name="FK_NFCE_PAG_TIPO_PAG"))
    private TipoPagamentoNFe tipoPagamentoNFe;
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_BANDEIRA_CARTAO", foreignKey=@ForeignKey(name="FK_NFCE_PAG_BANC_CARTAO"))
    private BandeiraCartaoNFe bandeiraCartaoNFe;
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_CREDENCIADORA_DEB_CRED", foreignKey=@ForeignKey(name="FK_NFCE_PAG_CRED_DEB_CRED"))
    private Pessoa credenciadoraCreditoDebito;
    @Column(name="tipo_integracao", nullable=false)
    private Short tipoIntegracao = 0;
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_NFCE", foreignKey=@ForeignKey(name="FK_NFCE_PAG_NFCE"))
    private NFCe nfce;
    @Column(name="numero_parcelas", nullable=false)
    private Short numeroParcelas = 0;
    @ManyToOne(cascade={CascadeType.ALL})
    @JoinColumn(name="ID_NFCE_PAGAMENTO_CDC", foreignKey=@ForeignKey(name="FK_NFCE_PAG_CDC"), unique=true)
    private NFCePagamentoCDC nfcePagamentoCDC;
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_BANDEIRA_TEF", foreignKey=@ForeignKey(name="FK_NFCE_PAG_BANDEIRA_TEF"))
    private BandeiraTEF bandeiraTEF;
    @Column(name="permitir_tef")
    private Short permitirTEF = 0;
    @Column(name="serial_for_sinc", length=100)
    private String serialForSinc;
    @Column(name="cod_bandeira_tef", length=10)
    private String codigoBandeiraTEF;
    @Column(name="serial_for_sinc_cupom_desc", length=100)
    private String serialForSincCupomDesconto;

    public NFCePagamento() {
        this.titulos = new LinkedList<NFCeTitulo>();
    }

    public boolean equals(Object other) {
        return ToolBaseMethodsVO.equalsVO((Object)this, (Object)other);
    }

    public String toString() {
        return ToolBaseMethodsVO.toString((String)"{0}", (Object[])new Object[]{this.getIdentificador()});
    }

    public int hashCode() {
        return ToolBaseMethodsVO.hashCode((Number)this.getIdentificador());
    }

    @Generated
    public Long getIdentificador() {
        return this.identificador;
    }

    @Generated
    public CondicoesPagamento getCondicoesPagamento() {
        return this.condicoesPagamento;
    }

    @Generated
    public MeioPagamento getMeioPagamento() {
        return this.meioPagamento;
    }

    @Generated
    public Double getValor() {
        return this.valor;
    }

    @Generated
    public Double getValorTroco() {
        return this.valorTroco;
    }

    @Generated
    public Double getValorLiquido() {
        return this.valorLiquido;
    }

    @Generated
    public String getNrAutorizacao() {
        return this.nrAutorizacao;
    }

    @Generated
    public Short getStatus() {
        return this.status;
    }

    @Generated
    public List<NFCeTitulo> getTitulos() {
        return this.titulos;
    }

    @Generated
    public List<NFCeChequeTerceiros> getChequeTerceiros() {
        return this.chequeTerceiros;
    }

    @Generated
    public TipoPagamentoNFe getTipoPagamentoNFe() {
        return this.tipoPagamentoNFe;
    }

    @Generated
    public BandeiraCartaoNFe getBandeiraCartaoNFe() {
        return this.bandeiraCartaoNFe;
    }

    @Generated
    public Pessoa getCredenciadoraCreditoDebito() {
        return this.credenciadoraCreditoDebito;
    }

    @Generated
    public Short getTipoIntegracao() {
        return this.tipoIntegracao;
    }

    @Generated
    public NFCe getNfce() {
        return this.nfce;
    }

    @Generated
    public Short getNumeroParcelas() {
        return this.numeroParcelas;
    }

    @Generated
    public NFCePagamentoCDC getNfcePagamentoCDC() {
        return this.nfcePagamentoCDC;
    }

    @Generated
    public BandeiraTEF getBandeiraTEF() {
        return this.bandeiraTEF;
    }

    @Generated
    public Short getPermitirTEF() {
        return this.permitirTEF;
    }

    @Generated
    public String getSerialForSinc() {
        return this.serialForSinc;
    }

    @Generated
    public String getCodigoBandeiraTEF() {
        return this.codigoBandeiraTEF;
    }

    @Generated
    public String getSerialForSincCupomDesconto() {
        return this.serialForSincCupomDesconto;
    }

    @Generated
    public void setIdentificador(Long identificador) {
        this.identificador = identificador;
    }

    @Generated
    public void setCondicoesPagamento(CondicoesPagamento condicoesPagamento) {
        this.condicoesPagamento = condicoesPagamento;
    }

    @Generated
    public void setMeioPagamento(MeioPagamento meioPagamento) {
        this.meioPagamento = meioPagamento;
    }

    @Generated
    public void setValor(Double valor) {
        this.valor = valor;
    }

    @Generated
    public void setValorTroco(Double valorTroco) {
        this.valorTroco = valorTroco;
    }

    @Generated
    public void setValorLiquido(Double valorLiquido) {
        this.valorLiquido = valorLiquido;
    }

    @Generated
    public void setNrAutorizacao(String nrAutorizacao) {
        this.nrAutorizacao = nrAutorizacao;
    }

    @Generated
    public void setStatus(Short status) {
        this.status = status;
    }

    @Generated
    public void setTitulos(List<NFCeTitulo> titulos) {
        this.titulos = titulos;
    }

    @Generated
    public void setChequeTerceiros(List<NFCeChequeTerceiros> chequeTerceiros) {
        this.chequeTerceiros = chequeTerceiros;
    }

    @Generated
    public void setTipoPagamentoNFe(TipoPagamentoNFe tipoPagamentoNFe) {
        this.tipoPagamentoNFe = tipoPagamentoNFe;
    }

    @Generated
    public void setBandeiraCartaoNFe(BandeiraCartaoNFe bandeiraCartaoNFe) {
        this.bandeiraCartaoNFe = bandeiraCartaoNFe;
    }

    @Generated
    public void setCredenciadoraCreditoDebito(Pessoa credenciadoraCreditoDebito) {
        this.credenciadoraCreditoDebito = credenciadoraCreditoDebito;
    }

    @Generated
    public void setTipoIntegracao(Short tipoIntegracao) {
        this.tipoIntegracao = tipoIntegracao;
    }

    @Generated
    public void setNfce(NFCe nfce) {
        this.nfce = nfce;
    }

    @Generated
    public void setNumeroParcelas(Short numeroParcelas) {
        this.numeroParcelas = numeroParcelas;
    }

    @Generated
    public void setNfcePagamentoCDC(NFCePagamentoCDC nfcePagamentoCDC) {
        this.nfcePagamentoCDC = nfcePagamentoCDC;
    }

    @Generated
    public void setBandeiraTEF(BandeiraTEF bandeiraTEF) {
        this.bandeiraTEF = bandeiraTEF;
    }

    @Generated
    public void setPermitirTEF(Short permitirTEF) {
        this.permitirTEF = permitirTEF;
    }

    @Generated
    public void setSerialForSinc(String serialForSinc) {
        this.serialForSinc = serialForSinc;
    }

    @Generated
    public void setCodigoBandeiraTEF(String codigoBandeiraTEF) {
        this.codigoBandeiraTEF = codigoBandeiraTEF;
    }

    @Generated
    public void setSerialForSincCupomDesconto(String serialForSincCupomDesconto) {
        this.serialForSincCupomDesconto = serialForSincCupomDesconto;
    }
}

