/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.touchnfce.nfe;

import com.touchcomp.basementor.constants.enums.EnumConstantsMentorSimNao;
import com.touchcomp.basementor.constants.enums.EnumConstantsModeloDocFiscal;
import com.touchcomp.basementor.constants.enums.configuracaocertificado.ConstAmbiente;
import com.touchcomp.basementor.constants.enums.impostos.icms.EnumConstContrEstadoIcms;
import com.touchcomp.basementor.constants.enums.impostos.icms.EnumConstNFeIncidenciaIcms;
import com.touchcomp.basementor.constants.enums.impostos.ipi.EnumConstNFeIncidenciaIpi;
import com.touchcomp.basementor.constants.enums.impostos.piscofins.EnumConstNFeIncidenciaCofins;
import com.touchcomp.basementor.constants.enums.impostos.piscofins.EnumConstNFeIncidenciaPis;
import com.touchcomp.basementor.constants.enums.modelodocfiscal.EnumConstModDocFiscal;
import com.touchcomp.basementor.constants.enums.nfe.ConstantsNFeResponsavelTecnico;
import com.touchcomp.basementor.constants.enums.nfe.EnumConstNFeTipoPagNFe;
import com.touchcomp.basementor.constants.enums.nfe.sefaz.ConstNFTipoProcessamento;
import com.touchcomp.basementor.constants.enums.nfe.sefaz.ConstNFeFinalidade;
import com.touchcomp.basementor.constants.enums.nfe.sefaz.ConstNFeIdentificacaoLocalDestOperacao;
import com.touchcomp.basementor.constants.enums.nfe.sefaz.ConstNFeIndicadorFormaPag;
import com.touchcomp.basementor.constants.enums.nfe.sefaz.ConstNFeIndicadorIEDest;
import com.touchcomp.basementor.constants.enums.nfe.sefaz.ConstNFeIndicadorPresenca;
import com.touchcomp.basementor.constants.enums.nfe.sefaz.ConstNFeIntermediadorComerical;
import com.touchcomp.basementor.constants.enums.nfe.sefaz.ConstNFeMeioPagamento;
import com.touchcomp.basementor.constants.enums.nfe.sefaz.ConstNFeModalidadeFrete;
import com.touchcomp.basementor.constants.enums.nfe.sefaz.ConstNFeOperacaoConsumidorFinal;
import com.touchcomp.basementor.constants.enums.nfe.sefaz.ConstNFeOperadoraCartao;
import com.touchcomp.basementor.constants.enums.nfe.sefaz.ConstNFeOrigemProcedencia;
import com.touchcomp.basementor.constants.enums.nfe.sefaz.ConstNFeProdutoCompoeValorNota;
import com.touchcomp.basementor.constants.enums.nfe.sefaz.ConstNFeTipoEmissao;
import com.touchcomp.basementor.constants.enums.nfe.sefaz.ConstNFeTipoEntSai;
import com.touchcomp.basementor.constants.enums.nfe.sefaz.ConstNFeTipoImpressao;
import com.touchcomp.basementor.constants.enums.nfe.sefaz.ConstNFeTipoIntegracaoPagamento;
import com.touchcomp.basementorclientwebservices.nfe.model.env.lotefat.NFeLoteFaturamento;
import com.touchcomp.basementorclientwebservices.nfe.model.env.nfe.NFeNotaFiscalPropria;
import com.touchcomp.basementorclientwebservices.nfe.model.env.nfe.NFeNotaFiscalPropriaItem;
import com.touchcomp.basementorexceptions.exceptions.impl.invaliddata.ExceptionInvalidData;
import com.touchcomp.basementorexceptions.exceptions.impl.reflection.ExceptionReflection;
import com.touchcomp.basementortools.tools.date.ToolDate;
import com.touchcomp.basementortools.tools.formatter.ToolFormatter;
import com.touchcomp.basementortools.tools.methods.ToolMethods;
import com.touchcomp.basementortools.tools.string.ToolString;
import com.touchcomp.basementortools.tools.textdynamic.ToolTextDynamic;
import com.touchcomp.touchnfce.Main;
import com.touchcomp.touchnfce.controller.venda.auxmodelofiscal.AuxModeloFiscal;
import com.touchcomp.touchnfce.model.Cfop;
import com.touchcomp.touchnfce.model.Complemento;
import com.touchcomp.touchnfce.model.DadosRecAgrNFCe;
import com.touchcomp.touchnfce.model.EmailPessoa;
import com.touchcomp.touchnfce.model.Empresa;
import com.touchcomp.touchnfce.model.Endereco;
import com.touchcomp.touchnfce.model.NFCe;
import com.touchcomp.touchnfce.model.NFCeEnderecoEntrega;
import com.touchcomp.touchnfce.model.NFCeItem;
import com.touchcomp.touchnfce.model.NFCeItemICMS;
import com.touchcomp.touchnfce.model.NFCeLoteNotas;
import com.touchcomp.touchnfce.model.NFCeOpcoes;
import com.touchcomp.touchnfce.model.NFCePagamento;
import com.touchcomp.touchnfce.model.NFCePessoa;
import com.touchcomp.touchnfce.model.NFCeTitulo;
import com.touchcomp.touchnfce.model.NFCeTotalizadores;
import com.touchcomp.touchnfce.model.NFCeVolume;
import com.touchcomp.touchnfce.model.ObjectObsDinamica;
import com.touchcomp.touchnfce.model.TipoEmissaoNFe;
import com.touchcomp.touchnfce.model.Transportador;
import com.touchcomp.touchnfce.model.UnidadeFatCliente;
import com.touchcomp.touchnfce.model.UnidadeFederativa;
import com.touchcomp.touchnfce.service.impl.ServiceObjectObsDinamica;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;

public class AuxEnviaNota {
    private NFCeOpcoes opcoesNFCe;

    public AuxEnviaNota(NFCeOpcoes opcoesNFCe) {
        this.opcoesNFCe = opcoesNFCe;
    }

    public NFeLoteFaturamento criarNotaEnvio(NFCeLoteNotas loteNotas) {
        NFeLoteFaturamento lote = new NFeLoteFaturamento();
        lote.setIdentificador(loteNotas.getIdentificador());
        lote.setTipoProcessamento(ConstNFTipoProcessamento.PROCESSAMENTO_SINCRONO);
        lote.setVersao(loteNotas.getVersaoNFe().getCodigo());
        for (NFCe nf : loteNotas.getNotas()) {
            lote.getNotas().add(this.criarNota(nf));
        }
        return lote;
    }

    private NFeNotaFiscalPropria criarNota(NFCe nfce) {
        NFeNotaFiscalPropria nf = new NFeNotaFiscalPropria();
        nf.setEmitente(this.getEmitente(nfce.getEmpresa()));
        if (nfce.getEnderecoEntrega() != null) {
            nf.setEnderecoEntrega(this.getEnderecoEntrega(nfce.getEnderecoEntrega()));
        }
        nf.setVersaoNFe(nfce.getVersaoNfe().getCodigo());
        nf.setIdentificador(nfce.getIdentificador());
        nf.setIdentificacao(this.getIdentificacao(nfce));
        nf.setInfoDestinatario(this.getDestinatario(nfce, nfce.getUnidadeFatCliente()));
        nf.setInfoPagamento(this.getInfoPagamento(nfce));
        nf.setInfoCobranca(this.getInfoCobranca(nfce));
        nf.setInfoTransporte(this.getInfoTransporte(nfce));
        nf.setTotal(this.getTotal(nfce.getTotalizadores()));
        nf.setItens(this.getItens(this.ordenaListItens(nfce.getItens())));
        nf.setChaveNFe(nfce.getChaveNFCe());
        nf.setRespTecnico(this.getRespTecnico(nfce));
        nf.setAgropecuario(this.getAgropecuario(nfce));
        nf.setInformacoesAdicionais(this.getInfoAdicionais(nfce));
        nf.setIntermediadorComercial(this.getIntermediador(nfce));
        return nf;
    }

    private NFeNotaFiscalPropria.NFIntermediadorComercial getIntermediador(NFCe nfce) {
        if (nfce.getIntermediadorComercial() == null) {
            return null;
        }
        NFeNotaFiscalPropria.NFIntermediadorComercial aux = new NFeNotaFiscalPropria.NFIntermediadorComercial();
        aux.setCnpj(nfce.getIntermediadorComercial().getPessoa().getComplemento().getCnpj());
        aux.setIdentificadorIntermediador(nfce.getIntermediadorComercial().getIdentificacaoIntermediador());
        return aux;
    }

    private NFeNotaFiscalPropria.NFeNotaInfoRespTecnico getRespTecnico(NFCe nfce) {
        NFeNotaFiscalPropria.NFeNotaInfoRespTecnico respTecnico = new NFeNotaFiscalPropria.NFeNotaInfoRespTecnico();
        respTecnico.setCnpj(ConstantsNFeResponsavelTecnico.CNPJ);
        respTecnico.setContatoNome(ConstantsNFeResponsavelTecnico.CONTATO);
        respTecnico.setEmail(ConstantsNFeResponsavelTecnico.EMAIL);
        respTecnico.setTelefone(ConstantsNFeResponsavelTecnico.TELEFONE);
        return respTecnico;
    }

    private NFeNotaFiscalPropria.NFeNotaAgropecuario getAgropecuario(NFCe nfce) {
        if (ToolMethods.isEquals((Object)nfce.getModeloDocFiscal().getCodigo(), (Object)EnumConstantsModeloDocFiscal.NFE_55.getCodigo()) && ToolMethods.isWithData(nfce.getReceitasAgronomicas())) {
            NFeNotaFiscalPropria.NFeNotaAgropecuario agro = new NFeNotaFiscalPropria.NFeNotaAgropecuario();
            for (DadosRecAgrNFCe r : nfce.getReceitasAgronomicas()) {
                if (r.getNrReceitaAgro() == null || r.getNrReceitaAgro() <= 0L || !ToolMethods.isStrWithData((String)r.getCpfTecnicoReceita())) continue;
                NFeNotaFiscalPropria.NFeNotaAgropecuario.NFeNotaAgropecuarioDefensivo def = new NFeNotaFiscalPropria.NFeNotaAgropecuario.NFeNotaAgropecuarioDefensivo();
                def.setNrReceituario(r.getNrReceitaAgro().toString());
                def.setCpfRespTec(r.getCpfTecnicoReceita());
                agro.getDefensivo().add(def);
            }
            if (ToolMethods.isWithData((Collection)agro.getDefensivo())) {
                return agro;
            }
        }
        return null;
    }

    private NFeNotaFiscalPropria.NFeNotaInfoPagamento getInfoPagamento(NFCe nfce) {
        NFeNotaFiscalPropria.NFeNotaInfoPagamento infoPag = new NFeNotaFiscalPropria.NFeNotaInfoPagamento();
        Double valorTroco = 0.0;
        LinkedList<NFeNotaFiscalPropria.NFeNotaInfoPagamento.NFeNotaInfoFormaPagamento> ret = new LinkedList<NFeNotaFiscalPropria.NFeNotaInfoPagamento.NFeNotaInfoFormaPagamento>();
        Boolean trocoZerado = false;
        for (NFCePagamento pag : nfce.getPagamentos()) {
            if (pag.getStatus() != 1) continue;
            NFeNotaFiscalPropria.NFeNotaInfoPagamento.NFeNotaInfoFormaPagamento p = new NFeNotaFiscalPropria.NFeNotaInfoPagamento.NFeNotaInfoFormaPagamento();
            valorTroco = valorTroco + pag.getValorTroco();
            NFeNotaFiscalPropria.NFeNotaInfoPagamento.NFeNotaInfoFormaPagamento inf = new NFeNotaFiscalPropria.NFeNotaInfoPagamento.NFeNotaInfoFormaPagamento();
            if (pag.getCondicoesPagamento() != null && pag.getCondicoesPagamento().getTpCondicao() != null) {
                inf.setIndicadorFormaPagamento(ConstNFeIndicadorFormaPag.valueOfCodigo((String)pag.getCondicoesPagamento().getTpCondicao().toString()));
            } else {
                inf.setIndicadorFormaPagamento(ConstNFeIndicadorFormaPag.A_VISTA);
            }
            inf.setMeioPagamento(ConstNFeMeioPagamento.valueOfCodigo((String)pag.getTipoPagamentoNFe().getCodigo()));
            inf.setValorPagamento(pag.getValor());
            if (ToolMethods.isEquals((Object)pag.getTipoPagamentoNFe().getCodigo(), (Object)EnumConstNFeTipoPagNFe.SEM_PAGAMENTO.getCodigo())) {
                inf.setValorPagamento(Double.valueOf(0.0));
                trocoZerado = true;
            }
            if (pag.getTipoPagamentoNFe().getCartaoDebCred().equals((short)1)) {
                inf.setCartao(new NFeNotaFiscalPropria.NFeNotaInfoPagamento.NFeNotaInfoFormaPagamento.NFeNotaInfoCartao());
                if (pag.getBandeiraCartaoNFe() != null) {
                    inf.getCartao().setOperadoraCartao(ConstNFeOperadoraCartao.valueOfCodigo((String)pag.getBandeiraCartaoNFe().getCodigo()));
                }
                if (pag.getTipoIntegracao() != null) {
                    inf.getCartao().setTipoIntegracao(ConstNFeTipoIntegracaoPagamento.valueOfCodigo((String)pag.getTipoIntegracao().toString()));
                }
                if (pag.getNrAutorizacao() != null && !pag.getNrAutorizacao().isEmpty()) {
                    inf.getCartao().setNumeroAutorizacaoOperacaoCartao(pag.getNrAutorizacao());
                }
                if (pag.getCredenciadoraCreditoDebito() != null) {
                    inf.getCartao().setCnpj(pag.getCredenciadoraCreditoDebito().getComplemento().getCnpj());
                }
            }
            ret.add(inf);
        }
        infoPag.setDetalhamentoFormasPagamento(ret);
        if (!trocoZerado.booleanValue()) {
            infoPag.setValorTroco(valorTroco);
        }
        return infoPag;
    }

    private NFeNotaFiscalPropria.NFeNotaInfoTransporte getInfoTransporte(NFCe nfce) {
        NFeNotaFiscalPropria.NFeNotaInfoTransporte ret = new NFeNotaFiscalPropria.NFeNotaInfoTransporte();
        ret.setModalidadeFrete(ConstNFeModalidadeFrete.valueOfCodigo((String)nfce.getDadosTransporte().getTipoFrete().getFretePorConta().toString()));
        if (!ToolMethods.isEquals((Object)nfce.getDadosTransporte().getTipoFrete().getFretePorConta(), (Object)9)) {
            if (nfce.getDadosTransporte() != null && nfce.getDadosTransporte().getTransportador() != null) {
                Transportador transportador = nfce.getDadosTransporte().getTransportador();
                ret.setTransportador(new NFeNotaFiscalPropria.NFeNotaInfoTransporte.NFeInfoTransportador());
                ret.getTransportador().setCnpjCpf(transportador.getPessoa().getComplemento().getCnpj());
                StringBuilder sb = new StringBuilder();
                sb.append(transportador.getPessoa().getEndereco().getLogradouro());
                if (transportador.getPessoa().getEndereco().getNumero() != null) {
                    sb.append(",").append(transportador.getPessoa().getEndereco().getNumero());
                }
                if (transportador.getPessoa().getEndereco().getBairro() != null) {
                    sb.append(",").append(transportador.getPessoa().getEndereco().getBairro());
                }
                if (sb.length() > 60) {
                    sb = new StringBuilder(sb.substring(0, 60));
                }
                ret.getTransportador().setEnderecoComplemento(sb.toString());
                ret.getTransportador().setInscricaoEstadual(transportador.getPessoa().getComplemento().getInscEst());
                ret.getTransportador().setNomeMunicipio(transportador.getPessoa().getEndereco().getCidade().getDescricao());
                ret.getTransportador().setRazaoSocial(transportador.getPessoa().getNome());
                ret.getTransportador().setUf(transportador.getPessoa().getEndereco().getCidade().getUf().getSigla());
            }
            if (nfce.getDadosTransporte() != null && ToolMethods.isStrWithData((String)nfce.getDadosTransporte().getPlacaVeiculo())) {
                NFeNotaFiscalPropria.NFeNotaInfoTransporte.NFeNotaInfoVeiculo veiculo = new NFeNotaFiscalPropria.NFeNotaInfoTransporte.NFeNotaInfoVeiculo();
                veiculo.setPlacaVeiculo(nfce.getDadosTransporte().getPlacaVeiculo());
                veiculo.setRegistroNacionalTransportadorCarga(nfce.getDadosTransporte().getRegistroANTTVeiculo());
                if (nfce.getDadosTransporte().getUfVeiculo() != null) {
                    veiculo.setUf(nfce.getDadosTransporte().getUfVeiculo().getCodIbge());
                }
                ret.setVeiculo(veiculo);
            }
            if (ToolMethods.isWithData(nfce.getVolumes())) {
                LinkedList<NFeNotaFiscalPropria.NFeNotaInfoTransporte.NFeNotaInfoVolume> aux = new LinkedList<NFeNotaFiscalPropria.NFeNotaInfoTransporte.NFeNotaInfoVolume>();
                for (NFCeVolume vol : nfce.getVolumes()) {
                    NFeNotaFiscalPropria.NFeNotaInfoTransporte.NFeNotaInfoVolume v = new NFeNotaFiscalPropria.NFeNotaInfoTransporte.NFeNotaInfoVolume();
                    v.setMarca(vol.getMarca());
                    v.setPesoBruto(vol.getPesoBruto());
                    v.setPesoLiquido(vol.getPesoLiquido());
                    v.setNumeracaoVolumesTransportados(String.valueOf(vol.getNumeroVolume()));
                    if (vol.getQuantidade() != null) {
                        v.setQuantidadeVolumesTransportados(Long.valueOf(vol.getQuantidade().longValue()));
                    }
                    if (vol.getEmbalagem() != null) {
                        v.setEspecieVolumesTransportados(vol.getEmbalagem().getNome());
                    }
                    aux.add(v);
                }
                ret.setVolumes(aux);
            }
        }
        return ret;
    }

    private List<NFeNotaFiscalPropriaItem> getItens(List<NFCeItem> itens) {
        LinkedList<NFeNotaFiscalPropriaItem> ret = new LinkedList<NFeNotaFiscalPropriaItem>();
        for (NFCeItem it : itens) {
            if (it.getStatus() != 1) continue;
            NFeNotaFiscalPropriaItem i = new NFeNotaFiscalPropriaItem();
            i.setImposto(this.getImpostoItem(it));
            i.setNumeroItem(it.getNumeroItem());
            i.setInformacoesAdicionais(it.getInfAdicionalProd());
            i.setProduto(this.getProdutoItem(it));
            if (ToolMethods.isAffirmative((Number)it.getNfce().getInformarDadosReformaTributaria())) {
                i.setValorTotalItemDoc(it.getValorTotalItemDoc());
            }
            ret.add(i);
        }
        return ret;
    }

    private NFeNotaFiscalPropriaItem.NFeNotaInfoItemImposto getImpostoItem(NFCeItem it) {
        NFeNotaFiscalPropriaItem.NFeNotaInfoItemImposto imp = new NFeNotaFiscalPropriaItem.NFeNotaInfoItemImposto(this.getItemSujeitoIPI(it), EnumConstantsMentorSimNao.SIM, EnumConstantsMentorSimNao.NAO, EnumConstantsMentorSimNao.NAO, EnumConstantsMentorSimNao.SIM, EnumConstantsMentorSimNao.NAO, EnumConstantsMentorSimNao.SIM, EnumConstantsMentorSimNao.NAO, EnumConstantsMentorSimNao.SIM);
        imp.setCofins(this.getCofins(it));
        imp.setIcms(this.getIcms(it));
        imp.setPis(this.getPis(it));
        imp.setIpi(this.getIpi(it));
        imp.setValorTotalTributos(it.getValorTotalTributos());
        if (ToolMethods.isAffirmative((Number)it.getNfce().getInformarDadosReformaTributaria())) {
            imp.setIbs(this.getIbs(it));
            imp.setCbs(this.getCbs(it));
        }
        return imp;
    }

    private NFeNotaFiscalPropriaItem.NFeNotaInfoItemImposto.NFeNotaInfoItemImpostoIBS getIbs(NFCeItem it) {
        NFeNotaFiscalPropriaItem.NFeNotaInfoItemImposto.NFeNotaInfoItemImpostoIBS ibs = new NFeNotaFiscalPropriaItem.NFeNotaInfoItemImposto.NFeNotaInfoItemImpostoIBS();
        if (ToolMethods.isNotNull((Object)it.getIbs()).booleanValue()) {
            ibs.setAliquotaDiferimentoIBSMun(it.getIbs().getAliquotaDiferimentoIBSMun());
            ibs.setAliquotaDiferimentoIBSUF(it.getIbs().getAliquotaDiferimentoIBSUF());
            ibs.setAliquotaEfetivaIBSMun(it.getIbs().getAliquotaEfetivaIBSMun());
            ibs.setAliquotaEfetivaIBSUF(it.getIbs().getAliquotaEfetivaIBSUF());
            ibs.setAliquotaIBSMun(it.getIbs().getAliquotaIBSMun());
            ibs.setAliquotaIBSUF(it.getIbs().getAliquotaIBSUF());
            if (ToolMethods.isNotNull((Object)it.getIbs().getIncidenciaTributaria()).booleanValue()) {
                ibs.setIncidenciaTributaria(it.getIbs().getIncidenciaTributaria().getCodigo());
            }
            if (ToolMethods.isNotNull((Object)it.getIbs().getIncidenciaTributariaClass()).booleanValue()) {
                ibs.setIncidenciaTributariaClass(it.getIbs().getIncidenciaTributariaClass().getCodigo());
            }
            ibs.setPercRedAliquotaIBSMun(it.getIbs().getPercRedAliquotaIBSMun());
            ibs.setPercRedAliquotaIBSUF(it.getIbs().getPercRedAliquotaIBSUF());
            ibs.setPercRedBC(it.getIbs().getPercRedBC());
            ibs.setValorBaseCalcIBS(it.getIbs().getValorBaseCalcIBS());
            ibs.setValorDevolucaoIBSMun(it.getIbs().getValorDevolucaoIBSMun());
            ibs.setValorDevolucaoIBSUF(it.getIbs().getValorDevolucaoIBSUF());
            ibs.setValorDiferimentoIBSMun(it.getIbs().getValorDiferimentoIBSMun());
            ibs.setValorDiferimentoIBSUF(it.getIbs().getValorDiferimentoIBSUF());
            ibs.setValorIBSMun(it.getIbs().getValorIBSMun());
            ibs.setValorIBSUF(it.getIbs().getValorIBSUF());
            ibs.setExigeTributacao(it.getIbs().getIncidenciaTributariaClass().getCalcularCbsIbs());
            ibs.setIndicadorTribRegular(it.getIbs().getIncidenciaTributariaClass().getIndGrupoTribReg());
            ibs.setIndicadorTribCreditoPresumido(it.getIbs().getIncidenciaTributariaClass().getIndGrupoTribCredPresumido());
            ibs.setIndicadorTribEstornoCredito(it.getIbs().getIncidenciaTributariaClass().getIndGrupoTribEstCredito());
        }
        return ibs;
    }

    private NFeNotaFiscalPropriaItem.NFeNotaInfoItemImposto.NFeNotaInfoItemImpostoCBS getCbs(NFCeItem it) {
        NFeNotaFiscalPropriaItem.NFeNotaInfoItemImposto.NFeNotaInfoItemImpostoCBS cbs = new NFeNotaFiscalPropriaItem.NFeNotaInfoItemImposto.NFeNotaInfoItemImpostoCBS();
        if (ToolMethods.isNotNull((Object)it.getCbs()).booleanValue()) {
            cbs.setAliquotaCBS(it.getCbs().getAliquotaCBS());
            cbs.setAliquotaCredPresumidoCBS(it.getCbs().getAliquotaCredPresumidoCBS());
            cbs.setAliquotaEfetivaCBS(it.getCbs().getAliquotaEfetivaCBS());
            cbs.setAliquotaDiferimentoCBS(it.getCbs().getAliquotaDiferimentoCBS());
            cbs.setBaseCalculoCBS(it.getCbs().getBaseCalculoCBS());
            if (ToolMethods.isNotNull((Object)it.getCbs().getIncidenciaTributaria()).booleanValue()) {
                cbs.setIncidenciaTributaria(it.getCbs().getIncidenciaTributaria().getCodigo());
            }
            if (ToolMethods.isNotNull((Object)it.getCbs().getIncidenciaTributariaClass()).booleanValue()) {
                cbs.setIncidenciaTributariaClass(it.getCbs().getIncidenciaTributariaClass().getCodigo());
            }
            cbs.setPercRedAliquotaCBS(it.getCbs().getPercRedAliquotaCBS());
            cbs.setPercRedBC(it.getCbs().getPercRedBC());
            cbs.setValorCBS(it.getCbs().getValorCBS());
            cbs.setValorCredPresCBS(it.getCbs().getValorCredPresCBS());
            cbs.setValorDevCBS(it.getCbs().getValorDevCBS());
            cbs.setValorDiferimentoCBS(it.getCbs().getValorDiferimentoCBS());
            cbs.setExigeTributacao(it.getCbs().getIncidenciaTributariaClass().getCalcularCbsIbs());
            cbs.setIndicadorTribRegular(it.getCbs().getIncidenciaTributariaClass().getIndGrupoTribReg());
            cbs.setIndicadorTribCreditoPresumido(it.getCbs().getIncidenciaTributariaClass().getIndGrupoTribCredPresumido());
            cbs.setIndicadorTribEstornoCredito(it.getCbs().getIncidenciaTributariaClass().getIndGrupoTribEstCredito());
        }
        return cbs;
    }

    private NFeNotaFiscalPropriaItem.NFeNotaInfoItemImposto.NFeNotaInfoItemImpostoICMS getIcms(NFCeItem it) {
        String codCST = it.getIcms().getIncidenciaIcms().getCodigo().substring(1);
        NFeNotaFiscalPropriaItem.NFeNotaInfoItemImposto.NFeNotaInfoItemImpostoICMS icms = new NFeNotaFiscalPropriaItem.NFeNotaInfoItemImposto.NFeNotaInfoItemImpostoICMS(codCST);
        EnumConstNFeIncidenciaIcms inc = EnumConstNFeIncidenciaIcms.valueOfCodigo((String)codCST);
        switch (inc) {
            case TRIBUTACAO_INTEGRALMENTE: {
                icms.setIcms00(this.getTribItegralmente00(it.getIcms()));
                break;
            }
            case COM_REDUCAO_BASE_CALCULO: {
                icms.setIcms20(this.getIcmsRed(it.getIcms()));
                break;
            }
            case ISENTA: {
                icms.setIcms40(this.getTribIsento40_41_50(it.getIcms()));
                break;
            }
            case NAO_TRIBUTADO: {
                icms.setIcms40(this.getTribIsento40_41_50(it.getIcms()));
                break;
            }
            case SUSPENSAO: {
                icms.setIcms40(this.getTribIsento40_41_50(it.getIcms()));
                break;
            }
            case DIFERIMENTO: {
                icms.setIcms51(this.getIcmsDif51(it.getIcms()));
                break;
            }
            case ICMS_COBRADO_ANTERIORMENTE_POR_SUBSTITUICAO_TRIBUTARIA: {
                if (it.getProduto().getClassificacaoProdutoANP() != null && this.isValidCodigoANP(it.getProduto().getClassificacaoProdutoANP().getCodigo()) && ToolMethods.isEquals((Object)it.getNfce().getModeloDocFiscal().getCodigo(), (Object)EnumConstantsModeloDocFiscal.NFE_55.getCodigo())) {
                    icms.setIcmsst(this.getIcmsST(it.getIcms()));
                    break;
                }
                icms.setIcms60(this.getIcmsCobAnt(it.getIcms()));
                break;
            }
            case TRIBUTACAO_MONOFASICA_COMBUSTIVEIS_COBRADO_ANTERIORMENTE: {
                icms.setIcms61(this.getIcmsCombCobAnt(it.getIcms()));
                break;
            }
            case OUTROS: {
                icms.setIcms90(this.getIcms90(it.getIcms()));
                break;
            }
            case SIMPLES_TRIBUTADA_SEM_PERMISSAO_CREDITO: {
                icms.setIcmssn102(this.getIcmsSimples102_103_300_400(it.getIcms()));
                break;
            }
            case SIMPLES_ISENCAO_ICMS_FAIXA_RECEITA_BRUTA: {
                icms.setIcmssn102(this.getIcmsSimples102_103_300_400(it.getIcms()));
                break;
            }
            case SIMPLES_IMUNE: {
                icms.setIcmssn102(this.getIcmsSimples102_103_300_400(it.getIcms()));
                break;
            }
            case SIMPLES_NAO_TRIBUTADA: {
                icms.setIcmssn102(this.getIcmsSimples102_103_300_400(it.getIcms()));
                break;
            }
            case SIMPLES_ICMS_COBRADO_ANTERIORMENTE_POR_SUBSTITUICAO_TRIBUTARIA_SUBSIDIO_OU_POR_ANTECIPACAO: {
                icms.setIcmssn500(this.getIcmsSimplesCobAnt(it.getIcms()));
                break;
            }
            case SIMPLES_OUTROS: {
                icms.setIcmssn900(this.getIcmsSimples900(it.getIcms()));
                break;
            }
            default: {
                throw new RuntimeException("Incidencia NFCeItemICMS nao contemplada/aceita para nfce.");
            }
        }
        return icms;
    }

    private NFeNotaFiscalPropriaItem.NFeNotaInfoItemImposto.NFeNotaInfoItemImpostoICMS.NFeNotaInfoItemImpostoICMSST getIcmsST(NFCeItemICMS icms) {
        NFeNotaFiscalPropriaItem.NFeNotaInfoItemImposto.NFeNotaInfoItemImpostoICMS.NFeNotaInfoItemImpostoICMSST ret = new NFeNotaFiscalPropriaItem.NFeNotaInfoItemImposto.NFeNotaInfoItemImpostoICMS.NFeNotaInfoItemImpostoICMSST();
        ret.setOrigem(ConstNFeOrigemProcedencia.valueOfCodigo((String)icms.getIncidenciaIcms().getCodigo().substring(0, 1)));
        ret.setCodSituacaoTributariaCST(icms.getIncidenciaIcms().getCodigo().substring(1));
        ret.setValorBCICMSSTRetidoUFRemetente(icms.getValorBcCalculoIcmsStRetido());
        ret.setValorBCICMSSTUFDestino(icms.getValorIcmsStRetido());
        ret.setValorICMSSTRetidoUFRemetente(Double.valueOf(0.0));
        ret.setValorICMSSTUFDestino(Double.valueOf(0.0));
        return ret;
    }

    public boolean isValidCodigoANP(String codANP) {
        return codANP.equals("210203001") || codANP.equals("320101001") || codANP.equals("320101002") || codANP.equals("320102002") || codANP.equals("320102001") || codANP.equals("320102003") || codANP.equals("820101032") || codANP.equals("820101027") || codANP.equals("820101004") || codANP.equals("820101005") || codANP.equals("820101022") || codANP.equals("820101031") || codANP.equals("820101030") || codANP.equals("820101018") || codANP.equals("820101020") || codANP.equals("820101021") || codANP.equals("420105001") || codANP.equals("420101005") || codANP.equals("420101004") || codANP.equals("420102005") || codANP.equals("820101003") || codANP.equals("820101012") || codANP.equals("420106002") || codANP.equals("830101001") || codANP.equals("420202001") || codANP.equals("420301001") || codANP.equals("510101002") || codANP.equals("510102002") || codANP.equals("510201001") || codANP.equals("510201003") || codANP.equals("510301003") || codANP.equals("510103001") || codANP.equals("510301001") || codANP.equals("820101026") || codANP.equals("320102005") || codANP.equals("320201001") || codANP.equals("320103001") || codANP.equals("220102001") || codANP.equals("320301001") || codANP.equals("320103002") || codANP.equals("820101019") || codANP.equals("820101014") || codANP.equals("820101006") || codANP.equals("820101016") || codANP.equals("820101015") || codANP.equals("820101025") || codANP.equals("820101017") || codANP.equals("820101013") || codANP.equals("420102004") || codANP.equals("420104001") || codANP.equals("820101033") || codANP.equals("820101034") || codANP.equals("420106001") || codANP.equals("820101011") || codANP.equals("510102001") || codANP.equals("420301002") || codANP.equals("410103001") || codANP.equals("410101001") || codANP.equals("410102001") || codANP.equals("430101004") || codANP.equals("510101001");
    }

    private NFeNotaFiscalPropriaItem.NFeNotaInfoItemImposto.NFeNotaInfoItemImpostoICMS.NFeNotaInfoItemImpostoICMSSN900 getIcmsSimples900(NFCeItemICMS icms) {
        NFeNotaFiscalPropriaItem.NFeNotaInfoItemImposto.NFeNotaInfoItemImpostoICMS.NFeNotaInfoItemImpostoICMSSN900 ret = new NFeNotaFiscalPropriaItem.NFeNotaInfoItemImposto.NFeNotaInfoItemImpostoICMS.NFeNotaInfoItemImpostoICMSSN900();
        ret.setOrigem(ConstNFeOrigemProcedencia.valueOfCodigo((String)icms.getIncidenciaIcms().getCodigo().substring(0, 1)));
        ret.setCodSituacaoTributariaCST(icms.getIncidenciaIcms().getCodigo().substring(1));
        return ret;
    }

    private NFeNotaFiscalPropriaItem.NFeNotaInfoItemImposto.NFeNotaInfoItemImpostoICMS.NFeNotaInfoItemImpostoICMSSN500 getIcmsSimplesCobAnt(NFCeItemICMS icms) {
        NFeNotaFiscalPropriaItem.NFeNotaInfoItemImposto.NFeNotaInfoItemImpostoICMS.NFeNotaInfoItemImpostoICMSSN500 ret = new NFeNotaFiscalPropriaItem.NFeNotaInfoItemImposto.NFeNotaInfoItemImpostoICMS.NFeNotaInfoItemImpostoICMSSN500();
        ret.setOrigem(ConstNFeOrigemProcedencia.valueOfCodigo((String)icms.getIncidenciaIcms().getCodigo().substring(0, 1)));
        ret.setCodSituacaoTributariaCST(icms.getIncidenciaIcms().getCodigo().substring(1));
        ret.setValorBCICMSSTRetido(icms.getValorBcCalculoIcmsStRetido());
        ret.setValorICMSSTRetido(icms.getValorIcmsStRetido());
        ret.setPercentualAliquotaICMSEfetiva(Double.valueOf(0.0));
        ret.setPercentualFundoCombatePobrezaRetidoST(Double.valueOf(0.0));
        ret.setPercentualICMSSTRetido(Double.valueOf(0.0));
        ret.setValorBCEfetiva(Double.valueOf(0.0));
        ret.setValorBCFundoCombatePobrezaRetidoST(Double.valueOf(0.0));
        ret.setValorFundoCombatePobrezaRetidoST(Double.valueOf(0.0));
        ret.setValorICMSEfetivo(Double.valueOf(0.0));
        return ret;
    }

    private NFeNotaFiscalPropriaItem.NFeNotaInfoItemImposto.NFeNotaInfoItemImpostoICMS.NFeNotaInfoItemImpostoICMSSN102 getIcmsSimples102_103_300_400(NFCeItemICMS icms) {
        NFeNotaFiscalPropriaItem.NFeNotaInfoItemImposto.NFeNotaInfoItemImpostoICMS.NFeNotaInfoItemImpostoICMSSN102 ret = new NFeNotaFiscalPropriaItem.NFeNotaInfoItemImposto.NFeNotaInfoItemImpostoICMS.NFeNotaInfoItemImpostoICMSSN102();
        ret.setOrigem(ConstNFeOrigemProcedencia.valueOfCodigo((String)icms.getIncidenciaIcms().getCodigo().substring(0, 1)));
        ret.setCodSituacaoTributariaCST(icms.getIncidenciaIcms().getCodigo().substring(1));
        return ret;
    }

    private NFeNotaFiscalPropriaItem.NFeNotaInfoItemImposto.NFeNotaInfoItemImpostoICMS.NFeNotaInfoItemImpostoICMS60 getIcmsCobAnt(NFCeItemICMS icms) {
        NFeNotaFiscalPropriaItem.NFeNotaInfoItemImposto.NFeNotaInfoItemImpostoICMS.NFeNotaInfoItemImpostoICMS60 ret = new NFeNotaFiscalPropriaItem.NFeNotaInfoItemImposto.NFeNotaInfoItemImpostoICMS.NFeNotaInfoItemImpostoICMS60();
        ret.setOrigem(ConstNFeOrigemProcedencia.valueOfCodigo((String)icms.getIncidenciaIcms().getCodigo().substring(0, 1)));
        ret.setCodSituacaoTributariaCST(icms.getIncidenciaIcms().getCodigo().substring(1));
        ret.setValorBCICMSSTRetido(icms.getValorBcCalculoIcmsStRetido());
        ret.setValorICMSSTRetido(icms.getValorIcmsStRetido());
        ret.setPercentualAliquotaICMSEfetiva(Double.valueOf(0.0));
        ret.setPercentualAliquotaICMSSTConsumidorFinal(Double.valueOf(0.0));
        ret.setPercentualFundoCombatePobrezaRetidoST(Double.valueOf(0.0));
        ret.setPercentualReducaoBCEfetiva(Double.valueOf(0.0));
        ret.setValorBCEfetiva(Double.valueOf(0.0));
        ret.setValorBCFundoCombatePobrezaRetidoST(Double.valueOf(0.0));
        ret.setValorFundoCombatePobrezaRetidoST(Double.valueOf(0.0));
        ret.setValorICMSEfetivo(Double.valueOf(0.0));
        return ret;
    }

    private NFeNotaFiscalPropriaItem.NFeNotaInfoItemImposto.NFeNotaInfoItemImpostoICMS.NFeNotaInfoItemImpostoICMS61 getIcmsCombCobAnt(NFCeItemICMS icms) {
        NFeNotaFiscalPropriaItem.NFeNotaInfoItemImposto.NFeNotaInfoItemImpostoICMS.NFeNotaInfoItemImpostoICMS61 ret = new NFeNotaFiscalPropriaItem.NFeNotaInfoItemImposto.NFeNotaInfoItemImpostoICMS.NFeNotaInfoItemImpostoICMS61();
        ret.setOrigem(ConstNFeOrigemProcedencia.valueOfCodigo((String)icms.getIncidenciaIcms().getCodigo().substring(0, 1)));
        ret.setCodSituacaoTributariaCST(icms.getIncidenciaIcms().getCodigo().substring(1));
        ret.setQtdeTribRetidoAnteriormente(icms.getQtdeBCIcmsMonoRetAnt());
        ret.setAliquotaAdRemRetidoAnteriormente(icms.getAliquotaAdRemIcmsRetAnt());
        ret.setValorICMSRetidoAnteriormente(icms.getValorIcmsMonoRetAnt());
        return ret;
    }

    private NFeNotaFiscalPropriaItem.NFeNotaInfoItemImposto.NFeNotaInfoItemImpostoICMS.NFeNotaInfoItemImpostoICMS51 getIcmsDif51(NFCeItemICMS icms) {
        NFeNotaFiscalPropriaItem.NFeNotaInfoItemImposto.NFeNotaInfoItemImpostoICMS.NFeNotaInfoItemImpostoICMS51 ret = new NFeNotaFiscalPropriaItem.NFeNotaInfoItemImposto.NFeNotaInfoItemImpostoICMS.NFeNotaInfoItemImpostoICMS51();
        ret.setOrigem(ConstNFeOrigemProcedencia.valueOfCodigo((String)icms.getIncidenciaIcms().getCodigo().substring(0, 1)));
        ret.setCodSituacaoTributariaCST(icms.getIncidenciaIcms().getCodigo().substring(1));
        ret.setCodModalidadeBCICMS(icms.getModalidadeIcms().getCodigo());
        ret.setPercentualReducaoBC(icms.getPercRedBCIcms());
        ret.setValorBCICMS(icms.getValorIcmsTributado());
        ret.setPercentualICMS(icms.getAliquotaIcms());
        ret.setValorICMSOperacao(this.getCalculoIcmsOperacao(icms));
        ret.setValorICMS(icms.getValorIcms());
        ret.setPercentualDiferimento(icms.getPercDiferimento());
        ret.setValorICMSDiferimento(icms.getValorIcmsDiferimento());
        ret.setPercentualFundoCombatePobreza(icms.getAliquotaIcmsFundoCombPobreza());
        ret.setValorBCFundoCombatePobreza(icms.getValorBcCalculoIcmsFundoCombPobreza());
        ret.setValorFundoCombatePobreza(icms.getValorIcmsFundoCombPobreza());
        return ret;
    }

    private NFeNotaFiscalPropriaItem.NFeNotaInfoItemImposto.NFeNotaInfoItemImpostoICMS.NFeNotaInfoItemImpostoICMS20 getIcmsRed(NFCeItemICMS icms) {
        NFeNotaFiscalPropriaItem.NFeNotaInfoItemImposto.NFeNotaInfoItemImpostoICMS.NFeNotaInfoItemImpostoICMS20 ret = new NFeNotaFiscalPropriaItem.NFeNotaInfoItemImposto.NFeNotaInfoItemImpostoICMS.NFeNotaInfoItemImpostoICMS20();
        ret.setOrigem(ConstNFeOrigemProcedencia.valueOfCodigo((String)icms.getIncidenciaIcms().getCodigo().substring(0, 1)));
        ret.setCodSituacaoTributariaCST(icms.getIncidenciaIcms().getCodigo().substring(1));
        ret.setCodModalidadeBCICMS(icms.getModalidadeIcms().getCodigo());
        ret.setPercentualReducaoBC(icms.getPercRedBCIcms());
        ret.setValorBCICMS(icms.getValorIcmsTributado());
        ret.setPercentualAliquota(icms.getAliquotaIcms());
        ret.setValorTributo(icms.getValorIcms());
        ret.setPercentualFundoCombatePobreza(icms.getAliquotaIcmsFundoCombPobreza());
        ret.setValorBCFundoCombatePobreza(icms.getValorBcCalculoIcmsFundoCombPobreza());
        ret.setValorFundoCombatePobreza(icms.getValorIcmsFundoCombPobreza());
        ret.setValorICMSDesoneracao(icms.getValorIcmsDesonerado());
        if (icms.getMotivoDesoneracaoIcms() != null) {
            ret.setCodigoDesoneracaoIcms(icms.getMotivoDesoneracaoIcms().getCodigo());
        }
        return ret;
    }

    private NFeNotaFiscalPropriaItem.NFeNotaInfoItemImposto.NFeNotaInfoItemImpostoICMS.NFeNotaInfoItemImpostoICMS40 getTribIsento40_41_50(NFCeItemICMS icms) {
        NFeNotaFiscalPropriaItem.NFeNotaInfoItemImposto.NFeNotaInfoItemImpostoICMS.NFeNotaInfoItemImpostoICMS40 ret = new NFeNotaFiscalPropriaItem.NFeNotaInfoItemImposto.NFeNotaInfoItemImpostoICMS.NFeNotaInfoItemImpostoICMS40();
        ret.setOrigem(ConstNFeOrigemProcedencia.valueOfCodigo((String)icms.getIncidenciaIcms().getCodigo().substring(0, 1)));
        ret.setCodSituacaoTributariaCST(icms.getIncidenciaIcms().getCodigo().substring(1));
        ret.setValorICMSDesoneracao(icms.getValorIcmsDesonerado());
        if (icms.getMotivoDesoneracaoIcms() != null) {
            ret.setCodMotivoDesoneracaoICMS(icms.getMotivoDesoneracaoIcms().getCodigo());
        }
        return ret;
    }

    private NFeNotaFiscalPropriaItem.NFeNotaInfoItemImposto.NFeNotaInfoItemImpostoICMS.NFeNotaInfoItemImpostoICMS00 getTribItegralmente00(NFCeItemICMS icms) {
        NFeNotaFiscalPropriaItem.NFeNotaInfoItemImposto.NFeNotaInfoItemImpostoICMS.NFeNotaInfoItemImpostoICMS00 ret = new NFeNotaFiscalPropriaItem.NFeNotaInfoItemImposto.NFeNotaInfoItemImpostoICMS.NFeNotaInfoItemImpostoICMS00();
        ret.setCodModalidadeBCICMS(icms.getModalidadeIcms().getCodigo());
        ret.setOrigem(ConstNFeOrigemProcedencia.valueOfCodigo((String)icms.getIncidenciaIcms().getCodigo().substring(0, 1)));
        ret.setCodSituacaoTributariaCST(icms.getIncidenciaIcms().getCodigo().substring(1));
        ret.setValorBaseCalculo(icms.getValorIcmsTributado());
        ret.setPercentualAliquota(icms.getAliquotaIcms());
        ret.setValorTributo(icms.getValorIcms());
        ret.setPercentualFundoCombatePobreza(icms.getAliquotaIcmsFundoCombPobreza());
        ret.setValorFundoCombatePobreza(icms.getValorIcmsFundoCombPobreza());
        return ret;
    }

    private NFeNotaFiscalPropriaItem.NFeNotaInfoItemImposto.NFeotaInfoItemImpostoCOFINS getCofins(NFCeItem it) {
        NFeNotaFiscalPropriaItem.NFeNotaInfoItemImposto.NFeotaInfoItemImpostoCOFINS cof = new NFeNotaFiscalPropriaItem.NFeNotaInfoItemImposto.NFeotaInfoItemImpostoCOFINS();
        EnumConstNFeIncidenciaCofins inc = EnumConstNFeIncidenciaCofins.valueOfCodigo((String)it.getCofins().getIncidenciaPisCofins().getCodigo());
        if (this.contains(inc, EnumConstNFeIncidenciaCofins.getTributaveisAliqNFe())) {
            cof.setAliquota(new NFeNotaFiscalPropriaItem.NFeNotaInfoItemImposto.NFeotaInfoItemImpostoCOFINS.NFeNotaInfoItemImpostoCOFINSAliquota());
            cof.getAliquota().setCodSituacaoTributariaCST(inc.getCodigo());
            cof.getAliquota().setPercentualAliquota(it.getCofins().getAliquota());
            cof.getAliquota().setValorBaseCalculo(it.getCofins().getValorBaseCalculo());
            cof.getAliquota().setValorTributo(it.getCofins().getValor());
        } else if (this.contains(inc, EnumConstNFeIncidenciaCofins.getTributaveisQuantidadeNFe())) {
            cof.setQuantidade(new NFeNotaFiscalPropriaItem.NFeNotaInfoItemImposto.NFeotaInfoItemImpostoCOFINS.NFeNotaInfoItemImpostoCOFINSQuantidade());
            cof.getQuantidade().setCodSituacaoTributariaCST(inc.getCodigo());
            cof.getQuantidade().setQuantidadeVendida(it.getCofins().getQuantidadeVendida());
            cof.getQuantidade().setValorAliquota(it.getCofins().getAliquotaQuantidade());
            cof.getQuantidade().setValorTributo(it.getCofins().getValor());
        } else if (this.contains(inc, EnumConstNFeIncidenciaCofins.getNaoTributaveisNFe())) {
            cof.setNaoTributavel(new NFeNotaFiscalPropriaItem.NFeNotaInfoItemImposto.NFeotaInfoItemImpostoCOFINS.NFeNotaInfoItemImpostoCOFINSNaoTributavel());
            cof.getNaoTributavel().setCodSituacaoTributariaCST(inc.getCodigo());
        } else if (this.contains(inc, EnumConstNFeIncidenciaCofins.getOutrasNFe())) {
            cof.setOutrasOperacoes(new NFeNotaFiscalPropriaItem.NFeNotaInfoItemImposto.NFeotaInfoItemImpostoCOFINS.NFeNotaInfoItemImpostoCOFINSOutrasOperacoes());
            cof.getOutrasOperacoes().setCodSituacaoTributariaCST(inc.getCodigo());
            cof.getOutrasOperacoes().setPercentualAliquota(it.getCofins().getAliquota());
            cof.getOutrasOperacoes().setQuantidadeVendida(it.getCofins().getQuantidadeVendida());
            cof.getOutrasOperacoes().setValorAliquota(it.getCofins().getAliquotaQuantidade());
            cof.getOutrasOperacoes().setValorBaseCalculo(it.getCofins().getValorBaseCalculo());
            cof.getOutrasOperacoes().setValorTributo(it.getCofins().getAliquota());
        } else {
            throw new RuntimeException("Incidencida de NFCeItemCofins nao contemplada pela NFe:" + String.valueOf(inc));
        }
        return cof;
    }

    private NFeNotaFiscalPropriaItem.NFeNotaInfoItemImposto.NFeNotaInfoItemImpostoPIS getPis(NFCeItem it) {
        NFeNotaFiscalPropriaItem.NFeNotaInfoItemImposto.NFeNotaInfoItemImpostoPIS pis = new NFeNotaFiscalPropriaItem.NFeNotaInfoItemImposto.NFeNotaInfoItemImpostoPIS();
        EnumConstNFeIncidenciaPis inc = EnumConstNFeIncidenciaPis.valueOfCodigo((String)it.getPis().getIncidenciaPisCofins().getCodigo());
        if (this.contains(inc, EnumConstNFeIncidenciaPis.getTributaveisAliqNFe())) {
            pis.setAliquota(new NFeNotaFiscalPropriaItem.NFeNotaInfoItemImposto.NFeNotaInfoItemImpostoPIS.NFeNotaInfoItemImpostoPISAliquota());
            pis.getAliquota().setCodSituacaoTributariaCST(inc.getCodigo());
            pis.getAliquota().setPercentualAliquota(it.getPis().getAliquota());
            pis.getAliquota().setValorBaseCalculo(it.getPis().getValorBaseCalculo());
            pis.getAliquota().setValorTributo(it.getPis().getValor());
        } else if (this.contains(inc, EnumConstNFeIncidenciaPis.getTributaveisQuantidadeNFe())) {
            pis.setQuantidade(new NFeNotaFiscalPropriaItem.NFeNotaInfoItemImposto.NFeNotaInfoItemImpostoPIS.NFeNotaInfoItemImpostoPISQuantidade());
            pis.getQuantidade().setCodSituacaoTributariaCST(inc.getCodigo());
            pis.getQuantidade().setQuantidadeVendida(it.getPis().getQuantidadeVendida());
            pis.getQuantidade().setValorAliquota(it.getPis().getAliquotaQuantidade());
            pis.getQuantidade().setValorTributo(it.getPis().getValor());
        } else if (this.contains(inc, EnumConstNFeIncidenciaPis.getNaoTributaveisNFe())) {
            pis.setNaoTributado(new NFeNotaFiscalPropriaItem.NFeNotaInfoItemImposto.NFeNotaInfoItemImpostoPIS.NFeNotaInfoItemImpostoPISNaoTributado());
            pis.getNaoTributado().setCodSituacaoTributariaCST(inc.getCodigo());
        } else if (this.contains(inc, EnumConstNFeIncidenciaPis.getOutrasNFe())) {
            pis.setOutrasOperacoes(new NFeNotaFiscalPropriaItem.NFeNotaInfoItemImposto.NFeNotaInfoItemImpostoPIS.NFeNotaInfoItemImpostoPISOutrasOperacoes());
            pis.getOutrasOperacoes().setCodSituacaoTributariaCST(inc.getCodigo());
            pis.getOutrasOperacoes().setPercentualAliquota(it.getPis().getAliquota());
            pis.getOutrasOperacoes().setQuantidadeVendida(it.getPis().getQuantidadeVendida());
            pis.getOutrasOperacoes().setValorAliquota(it.getPis().getAliquotaQuantidade());
            pis.getOutrasOperacoes().setValorBaseCalculo(it.getPis().getValorBaseCalculo());
            pis.getOutrasOperacoes().setValorTributo(it.getPis().getValor());
        } else {
            throw new RuntimeException("Incidencida de NFCeItemPis nao contemplada pela NFe:" + String.valueOf(inc));
        }
        return pis;
    }

    private NFeNotaFiscalPropriaItem.NFeNotaInfoItemImposto.NFeNotaInfoItemImpostoIPI getIpi(NFCeItem it) {
        if (ToolMethods.isEquals((Object)it.getNfce().getModeloDocFiscal().getCodigo(), (Object)EnumConstantsModeloDocFiscal.NFE_55.getCodigo())) {
            EnumConstNFeIncidenciaIpi inc = EnumConstNFeIncidenciaIpi.valueOfCodigo((String)it.getIpi().getIncidenciaIpi().getCodigo());
            NFeNotaFiscalPropriaItem.NFeNotaInfoItemImposto.NFeNotaInfoItemImpostoIPI ipi = new NFeNotaFiscalPropriaItem.NFeNotaInfoItemImposto.NFeNotaInfoItemImpostoIPI(it.getIpi().getIncidenciaIpi().getCodigo());
            ipi.setCodigoCSTIPI(it.getIpi().getIncidenciaIpi().getCodigo());
            ipi.setCodigoEnquadramento(it.getIpi().getClasseEnqIpi().getCodigo());
            if (this.contains(inc, EnumConstNFeIncidenciaIpi.getTributaveisAliqNFe())) {
                ipi.setTributado(new NFeNotaFiscalPropriaItem.NFeNotaInfoItemImposto.NFeNotaInfoItemImpostoIPI.NFeNotaInfoItemImpostoIPITributado());
                ipi.getTributado().setPercentualAliquota(it.getIpi().getAliquota());
                ipi.getTributado().setValorBaseCalculo(it.getIpi().getValorIpiTributado());
                ipi.getTributado().setValorTributo(Double.valueOf(it.getIpi().getValorIpiComercio() + it.getIpi().getValorIpiIndustria()));
                ipi.getTributado().setSituacaoTributariaCST(it.getIpi().getIncidenciaIpi().getCodigo());
            } else if (this.contains(inc, EnumConstNFeIncidenciaIpi.getNaoTributaveisAliqNFe())) {
                ipi.setNaoTributado(new NFeNotaFiscalPropriaItem.NFeNotaInfoItemImposto.NFeNotaInfoItemImpostoIPI.NFeNotaInfoItemImpostoIPINaoTributado());
                ipi.getNaoTributado().setSituacaoTributariaCST(it.getIpi().getIncidenciaIpi().getCodigo());
            }
            return ipi;
        }
        return null;
    }

    private boolean contains(Object input, List<?> data) {
        return data.contains(input);
    }

    private NFeNotaFiscalPropriaItem.NFeNotaInfoItemProduto getProdutoItem(NFCeItem it) {
        NFeNotaFiscalPropriaItem.NFeNotaInfoItemProduto pr = new NFeNotaFiscalPropriaItem.NFeNotaInfoItemProduto();
        pr.setCfop(it.getCfop().getCodigo());
        if (this.opcoesNFCe.getUsarCodAuxiliar() == 1 && ToolMethods.isStrWithData((String)it.getProduto().getCodigoAuxiliar())) {
            pr.setCodigo(it.getProduto().getCodigoAuxiliar());
        } else {
            pr.setCodigo(it.getProduto().getIdentificador().toString());
        }
        if (it.getCodigoBarras() != null && !it.getCodigoBarras().isEmpty()) {
            pr.setCodigoDeBarras(it.getCodigoBarras());
        } else {
            pr.setCodigoDeBarras("SEM GTIN");
        }
        if (it.getCodigoBarrasTributavel() != null && !it.getCodigoBarrasTributavel().isEmpty()) {
            pr.setCodigoDeBarrasTributavel(it.getCodigoBarrasTributavel());
        } else {
            pr.setCodigoDeBarrasTributavel("SEM GTIN");
        }
        if (it.getCompoeTotal() == 1) {
            pr.setCompoeValorNota(ConstNFeProdutoCompoeValorNota.SIM);
        } else {
            pr.setCompoeValorNota(ConstNFeProdutoCompoeValorNota.NAO);
        }
        pr.setDescricao(it.getProduto().getNome());
        pr.setNcm(it.getProduto().getNcm().getCodigo());
        pr.setUnidadeComercial(it.getProduto().getUnidadeMedida().getSigla());
        pr.setUnidadeTributavel(it.getUnidadeMedidaTrib().getSigla());
        if (it.getValorUnitarioComercial() > 0.0) {
            pr.setQuantidadeComercial(ToolFormatter.arrredondarNumero((Double)it.getQuantidadeComercial(), (int)3));
        } else {
            pr.setQuantidadeComercial(ToolFormatter.arrredondarNumero((Double)it.getValorTotalBruto(), (int)3));
        }
        if (it.getValorUnitarioTributario() > 0.0) {
            pr.setQuantidadeTributavel(ToolFormatter.arrredondarNumero((Double)it.getQuantidadeTributaria(), (int)3));
        } else {
            pr.setQuantidadeTributavel(ToolFormatter.arrredondarNumero((Double)it.getValorTotalBruto(), (int)3));
        }
        pr.setValorUnitario(it.getValorUnitarioComercial());
        pr.setValorUnitarioTributavel(it.getValorUnitarioTributario());
        pr.setValorFrete(it.getValorFrete());
        pr.setValorSeguro(it.getValorSeguro());
        pr.setValorDesconto(it.getValorDesconto());
        pr.setValorOutrasDespesasAcessorias(it.getValorDespesasAcessorias());
        pr.setValorTotalBruto(it.getValorTotalBruto());
        pr.setNumeroPedidoCliente(it.getNumeroPedidoCliente());
        pr.setNumeroPedidoItemCliente(it.getNumeroPedidoItemCliente());
        if (it.getProduto().getCest() != null) {
            pr.setCodigoEspecificadorSituacaoTributaria(it.getProduto().getCest().getCodigo());
        }
        if (it.getProduto().getClassificacaoProdutoANP() != null) {
            pr.setCombustivel(this.getCombustivel(it));
        }
        if (ToolMethods.isEquals((Object)it.getNfce().getModeloDocFiscal().getCodigo(), (Object)EnumConstantsModeloDocFiscal.NFE_55.getCodigo())) {
            pr.setMedicamento(this.getMedicamento(it));
        }
        if (pr.getMedicamento() != null) {
            pr.setRastros(this.getRastros(it));
        }
        return pr;
    }

    private NFeNotaFiscalPropria.NFeNotaInfoTotal getTotal(NFCeTotalizadores totalizadores) {
        NFeNotaFiscalPropria.NFeNotaInfoTotal tot = new NFeNotaFiscalPropria.NFeNotaInfoTotal();
        tot.setIcmsTotal(new NFeNotaFiscalPropria.NFeNotaInfoTotal.NFeNotaInfoICMSTotal());
        tot.getIcmsTotal().setBaseCalculoICMS(totalizadores.getBaseCalculoICMS());
        tot.getIcmsTotal().setValorTotalICMS(totalizadores.getValorTotalICMS());
        tot.getIcmsTotal().setValorICMSDesonerado(totalizadores.getValorICMSDesonerado());
        tot.getIcmsTotal().setValorICMSFundoCombatePobreza(totalizadores.getValorICMSFundoCombatePobreza());
        tot.getIcmsTotal().setValorTotalFundoCombatePobreza(totalizadores.getValorTotalFundoCombatePobreza());
        tot.getIcmsTotal().setBaseCalculoICMSST(totalizadores.getBaseCalculoICMSST());
        tot.getIcmsTotal().setValorTotalICMSST(totalizadores.getValorTotalICMSST());
        tot.getIcmsTotal().setValorTotalFundoCombatePobrezaST(totalizadores.getValorTotalFundoCombatePobrezaST());
        tot.getIcmsTotal().setValorTotalFundoCombatePobrezaSTRetido(totalizadores.getValorTotalFundoCombatePobrezaSTRetido());
        tot.getIcmsTotal().setValorTotalDosProdutosServicos(totalizadores.getValorTotalDosProdutosServicos());
        tot.getIcmsTotal().setValorTotalFrete(totalizadores.getValorTotalFrete());
        tot.getIcmsTotal().setValorTotalSeguro(totalizadores.getValorTotalSeguro());
        tot.getIcmsTotal().setValorTotalDesconto(totalizadores.getValorTotalDesconto());
        tot.getIcmsTotal().setValorTotalII(totalizadores.getValorTotalII());
        tot.getIcmsTotal().setValorTotalIPIDevolvido(totalizadores.getValorTotalIPIDevolvido());
        tot.getIcmsTotal().setValorPIS(totalizadores.getValorTotalPIS());
        tot.getIcmsTotal().setValorCOFINS(totalizadores.getValorTotalCOFINS());
        tot.getIcmsTotal().setOutrasDespesasAcessorias(totalizadores.getValorTotalDespAcessorias());
        tot.getIcmsTotal().setValorTotalNFe(totalizadores.getValorTotalNFe());
        tot.getIcmsTotal().setValorTotalTributos(totalizadores.getValorTotalTributos());
        tot.getIcmsTotal().setQtdeTribRetidoAnteriormente(totalizadores.getQtdeTotalBCIcmsMonoRetAnt());
        tot.getIcmsTotal().setValorICMSRetidoAnteriormente(totalizadores.getValorTotalIcmsMonoRetAnt());
        if (ToolMethods.isAffirmative((Number)totalizadores.getNFCe().getInformarDadosReformaTributaria())) {
            tot.setIbsTotal(new NFeNotaFiscalPropria.NFeNotaInfoTotal.NFeNotaInfoIBSTotal());
            tot.getIbsTotal().setBaseCalculo(totalizadores.getBaseCalculoCbsIbs());
            tot.getIbsTotal().setTotalIBS(totalizadores.getValorTotalIbs());
            tot.getIbsTotal().setIbsMun(new NFeNotaFiscalPropria.NFeNotaInfoTotal.NFeNotaInfoIBSTotalMun());
            tot.getIbsTotal().getIbsMun().setTotalIBSMun(totalizadores.getValorTotalIbsMun());
            tot.getIbsTotal().getIbsMun().setTotalDevTribMun(Double.valueOf(0.0));
            tot.getIbsTotal().getIbsMun().setTotalDiferimentoMun(Double.valueOf(0.0));
            tot.getIbsTotal().setIbsUF(new NFeNotaFiscalPropria.NFeNotaInfoTotal.NFeNotaInfoIBSTotalUF());
            tot.getIbsTotal().getIbsUF().setTotalIBSUF(totalizadores.getValorTotalIbsUF());
            tot.getIbsTotal().getIbsUF().setTotalDevTribUF(Double.valueOf(0.0));
            tot.getIbsTotal().getIbsUF().setTotalDiferimentoUF(Double.valueOf(0.0));
            tot.setCbsTotal(new NFeNotaFiscalPropria.NFeNotaInfoTotal.NFeNotaInfoCBSTotal());
            tot.getCbsTotal().setBaseCalculo(totalizadores.getValorTotalNFe());
            tot.getCbsTotal().setTotalCBS(totalizadores.getValorTotalCbs());
            tot.getCbsTotal().setTotalDevCBS(Double.valueOf(0.0));
            tot.getCbsTotal().setTotalDiferimentoCBS(Double.valueOf(0.0));
            tot.setValorNFTot(totalizadores.getValorTotalDoc());
        }
        return tot;
    }

    private NFeNotaFiscalPropria.NFeDestinatario getDestinatario(NFCe nfce, UnidadeFatCliente unidadeFatCliente) {
        if (nfce.getUnidadeFatCliente() != null) {
            NFeNotaFiscalPropria.NFeDestinatario dest = new NFeNotaFiscalPropria.NFeDestinatario();
            dest.setCnpjCpf(nfce.getUnidadeFatCliente().getPessoa().getComplemento().getCnpj());
            dest.setEmail(this.getEmail(nfce));
            dest.setEndereco(this.getEndereco(unidadeFatCliente.getPessoa().getEndereco(), this.getTelefone(nfce.getUnidadeFatCliente().getCliente().getPessoa().getComplemento())));
            if (unidadeFatCliente.getPessoa().getComplemento().getPassaporte() != null && !unidadeFatCliente.getPessoa().getComplemento().getPassaporte().isEmpty()) {
                dest.setIdEstrangeiro(unidadeFatCliente.getPessoa().getComplemento().getPassaporte());
            }
            if (ToolMethods.isEquals((Object)nfce.getModeloDocFiscal().getCodigo(), (Object)EnumConstantsModeloDocFiscal.NFCE_65.getCodigo())) {
                dest.setIndicadorIEDestinatario(ConstNFeIndicadorIEDest.NAO_CONTRIBUINTE);
            } else {
                if (nfce.getUnidadeFatCliente().getPessoa().getComplemento().getContribuinteEstado().equals(EnumConstContrEstadoIcms.CONTRIBUINTE.getEnumId())) {
                    dest.setIndicadorIEDestinatario(ConstNFeIndicadorIEDest.CONTRIBUINTE_ICMS);
                } else if (nfce.getUnidadeFatCliente().getPessoa().getComplemento().getContribuinteEstado().equals(EnumConstContrEstadoIcms.ISENTO.getEnumId())) {
                    dest.setIndicadorIEDestinatario(ConstNFeIndicadorIEDest.CONTRIBUINTE_ISENTO_INSCRICAO_CONTRIBUINTES_ICMS);
                } else {
                    dest.setIndicadorIEDestinatario(ConstNFeIndicadorIEDest.NAO_CONTRIBUINTE);
                }
                if ((dest.getIndicadorIEDestinatario().equals((Object)ConstNFeIndicadorIEDest.CONTRIBUINTE_ICMS) || dest.getIndicadorIEDestinatario().equals((Object)ConstNFeIndicadorIEDest.NAO_CONTRIBUINTE)) && nfce.getUnidadeFatCliente().getPessoa().getComplemento().getInscEst() != null && nfce.getUnidadeFatCliente().getPessoa().getComplemento().getInscEst().trim().length() > 0) {
                    dest.setInscricaoEstadual(nfce.getUnidadeFatCliente().getPessoa().getComplemento().getInscEst());
                }
            }
            dest.setInscricaoMunicipal(unidadeFatCliente.getPessoa().getComplemento().getInscMunicipal());
            dest.setRazaoSocial(nfce.getUnidadeFatCliente().getPessoa().getNome());
            return dest;
        }
        if (nfce.getNfcePessoa() != null) {
            NFeNotaFiscalPropria.NFeDestinatario dest = new NFeNotaFiscalPropria.NFeDestinatario();
            dest.setCnpjCpf(nfce.getNfcePessoa().getCpfCnpj());
            dest.setEndereco(this.getEnderecoNFCePessoa(nfce.getNfcePessoa()));
            if (nfce.getNfcePessoa().getPassaporte() != null && !nfce.getNfcePessoa().getPassaporte().isEmpty()) {
                dest.setIdEstrangeiro(nfce.getNfcePessoa().getPassaporte());
            }
            if (ToolMethods.isEquals((Object)nfce.getModeloDocFiscal().getCodigo(), (Object)EnumConstantsModeloDocFiscal.NFCE_65.getCodigo())) {
                dest.setIndicadorIEDestinatario(ConstNFeIndicadorIEDest.NAO_CONTRIBUINTE);
            } else if (nfce.getNfcePessoa().getInscricaoEstadual() == null || nfce.getNfcePessoa().getInscricaoEstadual().isEmpty()) {
                dest.setIndicadorIEDestinatario(ConstNFeIndicadorIEDest.NAO_CONTRIBUINTE);
            } else if (nfce.getNfcePessoa().getInscricaoEstadual().equalsIgnoreCase("ISENTO")) {
                dest.setIndicadorIEDestinatario(ConstNFeIndicadorIEDest.CONTRIBUINTE_ISENTO_INSCRICAO_CONTRIBUINTES_ICMS);
            } else {
                dest.setIndicadorIEDestinatario(ConstNFeIndicadorIEDest.CONTRIBUINTE_ICMS);
                dest.setInscricaoEstadual(nfce.getNfcePessoa().getInscricaoEstadual());
            }
            dest.setInscricaoMunicipal(nfce.getNfcePessoa().getInscricaoMunicipal());
            dest.setRazaoSocial(nfce.getNfcePessoa().getNome());
            if (nfce.getNfcePessoa().getEmail() != null && !nfce.getNfcePessoa().getEmail().isEmpty()) {
                dest.setEmail(nfce.getNfcePessoa().getEmail());
            }
            return dest;
        }
        if (nfce.getNfCeConsumidor() != null) {
            boolean setDest = false;
            NFeNotaFiscalPropria.NFeDestinatario dest = new NFeNotaFiscalPropria.NFeDestinatario();
            if (nfce.getNfCeConsumidor().getCpfCnpj() != null && nfce.getNfCeConsumidor().getCpfCnpj().length() > 0) {
                dest.setCnpjCpf(nfce.getNfCeConsumidor().getCpfCnpj());
                setDest = true;
            } else if (nfce.getNfCeConsumidor().getPassaporte() != null && nfce.getNfCeConsumidor().getPassaporte().length() > 0) {
                dest.setIdEstrangeiro(nfce.getNfCeConsumidor().getPassaporte());
                setDest = true;
            }
            if (nfce.getNfCeConsumidor().getEmail() != null && nfce.getNfCeConsumidor().getEmail().length() > 0) {
                dest.setEmail(nfce.getNfCeConsumidor().getEmail());
            }
            if (nfce.getNfCeConsumidor().getNome() != null && nfce.getNfCeConsumidor().getNome().length() > 0) {
                dest.setRazaoSocial(nfce.getNfCeConsumidor().getNome());
            }
            if (!setDest) {
                return null;
            }
            return dest;
        }
        return null;
    }

    private String getEmail(NFCe nfce) {
        if (nfce.getUnidadeFatCliente() != null) {
            for (EmailPessoa em : nfce.getUnidadeFatCliente().getCliente().getPessoa().getComplemento().getEmails()) {
                if (em.getAtivo() == null || em.getAtivo() != 1 || em.getEnviarDadosNfe() == null || em.getEnviarDadosNfe() != 1) continue;
                return em.getEmail();
            }
        }
        return null;
    }

    private NFeNotaFiscalPropria.NFeIdentificacao getIdentificacao(NFCe nfce) {
        TipoEmissaoNFe tipoEmissao;
        NFeNotaFiscalPropria.NFeIdentificacao id = new NFeNotaFiscalPropria.NFeIdentificacao();
        id.setAmbiente(ConstAmbiente.valueOfCodigo((String)String.valueOf(nfce.getAmbiente())));
        id.setCodigoUf(nfce.getEmpresa().getPessoa().getEndereco().getCidade().getUf().getCodIbge());
        id.setCodigoRandomico(ToolFormatter.completaZerosEsquerda((String)String.valueOf(nfce.getNumeroRandomico()), (int)8));
        id.setNaturezaOperacao(nfce.getNaturezaOperacao().getDescricao());
        id.setModelo(EnumConstModDocFiscal.get((Object)nfce.getModeloDocFiscal().getCodigo()));
        id.setSerie(nfce.getSerie());
        id.setNumeroNota(nfce.getNumero());
        id.setDataHoraEmissao(ZonedDateTime.ofInstant(nfce.getDataEmissao().toInstant(), ZoneId.systemDefault()));
        if (ToolMethods.isEquals((Object)nfce.getModeloDocFiscal().getCodigo(), (Object)EnumConstantsModeloDocFiscal.NFE_55.getCodigo()) && nfce.getDataPrevSaida() != null) {
            id.setDataHoraSaidaOuEntrada(ZonedDateTime.ofInstant(this.getDataSaida(nfce).toInstant(), ZoneId.systemDefault()));
        }
        id.setTipo(ConstNFeTipoEntSai.SAIDA);
        id.setIdentificadorLocalDestinoOperacao(this.getIdentificadorDestOperacao(nfce));
        id.setCodigoMunicipio(nfce.getEmpresa().getPessoa().getEndereco().getCidade().getCodIbgeCompleto());
        id.setTipoImpressao(ConstNFeTipoImpressao.valueOfCodigo((String)nfce.getFormatoImpressao().toString()));
        id.setDigitoVerificador(nfce.getDigitoVerificador());
        id.setFinalidade(ConstNFeFinalidade.NORMAL);
        id.setOperacaoConsumidorFinal(ConstNFeOperacaoConsumidorFinal.SIM);
        id.setIndicadorPresencaComprador(ConstNFeIndicadorPresenca.valueOfCodigo((String)nfce.getIndicadorPresencaConsumidor().toString()));
        TipoEmissaoNFe tipoEmissaoNFe = tipoEmissao = nfce.getPeriodoEmissaoNFCe() != null ? nfce.getPeriodoEmissaoNFCe().getTipoEmissaoNfe() : nfce.getPeriodoEmissaoNFe().getTipoEmissaoNfe();
        if (ToolMethods.isEquals((Object)tipoEmissao.getCodigo(), (Object)1)) {
            id.setTipoEmissao(ConstNFeTipoEmissao.EMISSAO_NORMAL);
        } else {
            if (ToolMethods.isEquals((Object)tipoEmissao.getCodigo(), (Object)4)) {
                id.setTipoEmissao(ConstNFeTipoEmissao.CONTINGENCIA_DPEC);
            } else if (ToolMethods.isEquals((Object)tipoEmissao.getCodigo(), (Object)9)) {
                id.setTipoEmissao(ConstNFeTipoEmissao.CONTIGENCIA_OFFLINE);
            } else if (ToolMethods.isEquals((Object)tipoEmissao.getCodigo(), (Object)6)) {
                id.setTipoEmissao(ConstNFeTipoEmissao.CONTINGENCIA_SVCAN);
            } else if (ToolMethods.isEquals((Object)tipoEmissao.getCodigo(), (Object)7)) {
                id.setTipoEmissao(ConstNFeTipoEmissao.CONTINGENCIA_SVCRS);
            } else {
                throw new RuntimeException("Tipo de contigencia ainda nao mapeada");
            }
            if (ToolMethods.isEquals((Object)nfce.getModeloDocFiscal().getCodigo(), (Object)EnumConstantsModeloDocFiscal.NFE_55.getCodigo())) {
                id.setDataHoraContigencia(ZonedDateTime.ofInstant(nfce.getPeriodoEmissaoNFe().getDataInicial().toInstant(), ZoneId.systemDefault()));
                id.setJustificativaEntradaContingencia(ToolString.clearInvalidUTF8Char((String)nfce.getPeriodoEmissaoNFe().getDescricao()));
            } else {
                id.setDataHoraContigencia(ZonedDateTime.ofInstant(nfce.getPeriodoEmissaoNFCe().getDataInicial().toInstant(), ZoneId.systemDefault()));
                id.setJustificativaEntradaContingencia(ToolString.clearInvalidUTF8Char((String)nfce.getPeriodoEmissaoNFCe().getDescricao()));
            }
        }
        id.setVersaoEmissor(nfce.getVersaoAplicativo());
        id.setTipoIntermediador(ConstNFeIntermediadorComerical.valueOfCodigo((String)String.valueOf(nfce.getTipoIntermediadorComercial())));
        return id;
    }

    private ConstNFeIdentificacaoLocalDestOperacao getIdentificadorDestOperacao(NFCe nfce) {
        if (nfce.getUnidadeFatCliente() == null || ToolMethods.isEquals((Object)nfce.getModeloDocFiscal().getCodigo(), (Object)EnumConstantsModeloDocFiscal.NFCE_65.getCodigo())) {
            return ConstNFeIdentificacaoLocalDestOperacao.OPERACAO_INTERNA;
        }
        UnidadeFederativa ufCli = new AuxModeloFiscal().getUFPrestServico(nfce);
        UnidadeFederativa ufEmp = nfce.getEmpresa().getPessoa().getEndereco().getCidade().getUf();
        String ufCliente = ufCli.getSigla();
        String ufEmpresa = ufEmp.getSigla();
        if (ToolMethods.isEquals((Object)ufCliente, (Object)"EX")) {
            return ConstNFeIdentificacaoLocalDestOperacao.OPERACAO_COM_EXTERIOR;
        }
        if (ToolMethods.isEquals((Object)ufCliente, (Object)ufEmpresa)) {
            return ConstNFeIdentificacaoLocalDestOperacao.OPERACAO_INTERNA;
        }
        return ConstNFeIdentificacaoLocalDestOperacao.OPERACAO_INTERESTADUAL;
    }

    private NFeNotaFiscalPropria.NFeEnderecoEntrega getEnderecoEntrega(NFCeEnderecoEntrega endEntrega) {
        NFeNotaFiscalPropria.NFeEnderecoEntrega end = new NFeNotaFiscalPropria.NFeEnderecoEntrega();
        end.setBairro(endEntrega.getBairro());
        end.setCnpjCpf(endEntrega.getCpfCnpj());
        end.setCodigoMunicipio(endEntrega.getCidade().getCodIbgeCompleto());
        end.setUf(endEntrega.getCidade().getUf().getCodIbge());
        end.setCodigoPais(endEntrega.getCidade().getUf().getPais().getCodIbge());
        end.setCep(endEntrega.getCep());
        end.setComplemento(endEntrega.getComplemento());
        end.setNomeMunicipio(endEntrega.getCidade().getDescricao());
        end.setLogradouro(endEntrega.getLogradouro());
        end.setNumero(endEntrega.getNumero());
        return end;
    }

    private NFeNotaFiscalPropria.NFeEmitente getEmitente(Empresa empresa) {
        NFeNotaFiscalPropria.NFeEmitente emit = new NFeNotaFiscalPropria.NFeEmitente();
        if (empresa.getEmpresaDados().getCnae() != null) {
            emit.setClassificacaoNacionalAtividadesEconomicas(empresa.getEmpresaDados().getCnae().getCodigo());
            emit.setInscricaoMunicipal(empresa.getPessoa().getComplemento().getInscMunicipal());
        }
        emit.setCnpjCpf(empresa.getPessoa().getComplemento().getCnpj());
        emit.setCodRegimeTributario(String.valueOf(empresa.getEmpresaDados().getRegimeTributario().getCodigo()));
        emit.setEndereco(this.getEndereco(empresa.getPessoa().getEndereco(), this.getTelefone(empresa.getPessoa().getComplemento())));
        emit.setInscricaoEstadual(empresa.getPessoa().getComplemento().getInscEst());
        emit.setNomeFantasia(empresa.getPessoa().getNomeFantasia());
        emit.setRazaoSocial(empresa.getPessoa().getNome());
        return emit;
    }

    private String getTelefone(Complemento complemento) {
        if (this.isInf(complemento.getFone1())) {
            return complemento.getFone1();
        }
        if (this.isInf(complemento.getFone2())) {
            return complemento.getFone2();
        }
        if (this.isInf(complemento.getCel1())) {
            return complemento.getCel1();
        }
        if (this.isInf(complemento.getCel2())) {
            return complemento.getCel2();
        }
        return null;
    }

    private boolean isInf(String text) {
        return text != null && text.length() > 0;
    }

    private NFeNotaFiscalPropria.NFeEndereco getEndereco(Endereco endereco, String telefone) {
        NFeNotaFiscalPropria.NFeEndereco end = new NFeNotaFiscalPropria.NFeEndereco();
        end.setBairro(endereco.getBairro());
        end.setCep(endereco.getCep());
        end.setCodigoMunicipio(endereco.getCidade().getCodIbgeCompleto());
        end.setCodigoPais(endereco.getCidade().getUf().getPais().getCodIbge());
        end.setCodigoUF(endereco.getCidade().getUf().getCodIbge());
        end.setComplemento(endereco.getComplemento());
        end.setDescricaoMunicipio(endereco.getCidade().getDescricao());
        end.setLogradouro(endereco.getLogradouro());
        end.setNumero(endereco.getNumero());
        end.setTelefone(telefone);
        return end;
    }

    private NFeNotaFiscalPropria.NFeEndereco getEnderecoNFCePessoa(NFCePessoa nfcePessoa) {
        NFeNotaFiscalPropria.NFeEndereco end = new NFeNotaFiscalPropria.NFeEndereco();
        end.setBairro(nfcePessoa.getBairro());
        end.setCep(nfcePessoa.getCep());
        end.setCodigoMunicipio(nfcePessoa.getCidade().getCodIbgeCompleto());
        end.setCodigoPais(nfcePessoa.getCidade().getUf().getPais().getCodIbge());
        end.setCodigoUF(nfcePessoa.getCidade().getUf().getCodIbge());
        end.setComplemento(nfcePessoa.getComplemento());
        end.setDescricaoMunicipio(nfcePessoa.getCidade().getDescricao());
        end.setLogradouro(nfcePessoa.getLogradouro());
        end.setNumero(nfcePessoa.getNumero());
        if (nfcePessoa.getFone1() != null && !nfcePessoa.getFone1().isEmpty()) {
            end.setTelefone(nfcePessoa.getFone1());
        }
        return end;
    }

    private EnumConstantsMentorSimNao getItemSujeitoIPI(NFCeItem it) {
        if (ToolMethods.isEquals((Object)it.getNfce().getModeloDocFiscal().getCodigo(), (Object)EnumConstantsModeloDocFiscal.NFE_55.getCodigo())) {
            return EnumConstantsMentorSimNao.SIM;
        }
        return EnumConstantsMentorSimNao.NAO;
    }

    private Double getCalculoIcmsOperacao(NFCeItemICMS icms) {
        return icms.getValorIcmsTributado() * icms.getAliquotaIcms();
    }

    private NFeNotaFiscalPropriaItem.NFeNotaInfoItemProduto.NFeNotaInfoItemProdutoCombustivel getCombustivel(NFCeItem it) {
        String uf = this.getUfConsumoComb(it.getCfop(), this.getUF(it));
        if (uf != null) {
            NFeNotaFiscalPropriaItem.NFeNotaInfoItemProduto.NFeNotaInfoItemProdutoCombustivel c = new NFeNotaFiscalPropriaItem.NFeNotaInfoItemProduto.NFeNotaInfoItemProdutoCombustivel();
            c.setCodigoProdutoANP(it.getProduto().getClassificacaoProdutoANP().getCodigo());
            c.setDescricaoProdutoANP(it.getProduto().getClassificacaoProdutoANP().getDescricao());
            c.setUf(uf);
            if (it.getProduto().getPercGLP() != null && it.getProduto().getPercGLP() > 0.0 || it.getProduto().getPercGNI() != null && it.getProduto().getPercGNI() > 0.0 || it.getProduto().getPercGNN() != null && it.getProduto().getPercGNN() > 0.0) {
                c.setPercentualGLPDerivadoPetroleo(it.getProduto().getPercGLP());
                c.setPercentualGasNaturalImportado(it.getProduto().getPercGNI());
                c.setPercentualGasNaturalNacional(it.getProduto().getPercGNN());
                if (it.getProduto().getClassificacaoProdutoANP() != null && it.getProduto().getPesoUnitario() > 0.0 && it.getQuantidadeComercial() > 0.0) {
                    Double valorIcms = it.getIcms().getValorIcms() == null || it.getIcms().getValorIcms() == 0.0 ? 0.0 : it.getIcms().getValorIcms();
                    it.setValorPartida((it.getValorTotal() - valorIcms) / (it.getQuantidadeComercial() * it.getProduto().getPesoUnitario()));
                    c.setValorPartida(Double.valueOf((it.getValorTotal() - valorIcms) / (it.getQuantidadeComercial() * it.getProduto().getPesoUnitario())));
                }
            }
            if (this.informarEncerranteByCodigoANP(it.getProduto().getClassificacaoProdutoANP().getCodigo()) && ToolMethods.isEquals((Object)it.getNfce().getModeloDocFiscal().getCodigo(), (Object)EnumConstantsModeloDocFiscal.NFCE_65.getCodigo())) {
                c.setEncerrante(this.getEncerrantes(it));
            }
            if (it.getProduto().getPercIndiceMisturaBioDiesel() != null && it.getProduto().getPercIndiceMisturaBioDiesel() > 0.0) {
                c.setPercentualIndiceMisturaBio(it.getProduto().getPercIndiceMisturaBioDiesel());
            }
            return c;
        }
        return null;
    }

    public boolean informarEncerranteByCodigoANP(String codigoANP) {
        return codigoANP.equals("810101002") || codigoANP.equals("810101001") || codigoANP.equals("220101005") || codigoANP.equals("220101006") || codigoANP.equals("320103001") || codigoANP.equals("320102002") || codigoANP.equals("320102001") || codigoANP.equals("320102003") || codigoANP.equals("820101033") || codigoANP.equals("820101034") || codigoANP.equals("420106001") || codigoANP.equals("820101011") || codigoANP.equals("820101003") || codigoANP.equals("820101013") || codigoANP.equals("820101012") || codigoANP.equals("420106002") || codigoANP.equals("420301004");
    }

    public String getUfConsumoComb(Cfop cf, UnidadeFederativa uf) {
        String cfop;
        if (cf != null && ((cfop = cf.getCodigo()).equals("1.651") || cfop.equals("1.652") || cfop.equals("1.653") || cfop.equals("1.658") || cfop.equals("1.659") || cfop.equals("1.660") || cfop.equals("1.661") || cfop.equals("1.662") || cfop.equals("1.663") || cfop.equals("1.664") || cfop.equals("2.651") || cfop.equals("2.652") || cfop.equals("2.653") || cfop.equals("2.658") || cfop.equals("2.659") || cfop.equals("2.660") || cfop.equals("2.661") || cfop.equals("2.662") || cfop.equals("2.663") || cfop.equals("2.664") || cfop.equals("3.651") || cfop.equals("3.652") || cfop.equals("3.653") || cfop.equals("5.651") || cfop.equals("5.652") || cfop.equals("5.653") || cfop.equals("5.654") || cfop.equals("5.655") || cfop.equals("5.656") || cfop.equals("5.657") || cfop.equals("5.658") || cfop.equals("5.659") || cfop.equals("5.660") || cfop.equals("5.661") || cfop.equals("5.662") || cfop.equals("5.663") || cfop.equals("5.664") || cfop.equals("5.665") || cfop.equals("5.666") || cfop.equals("5.667") || cfop.equals("6.651") || cfop.equals("6.652") || cfop.equals("6.653") || cfop.equals("6.654") || cfop.equals("6.655") || cfop.equals("6.656") || cfop.equals("6.657") || cfop.equals("6.658") || cfop.equals("6.659") || cfop.equals("6.660") || cfop.equals("6.661") || cfop.equals("6.662") || cfop.equals("6.663") || cfop.equals("6.664") || cfop.equals("6.665") || cfop.equals("6.666") || cfop.equals("6.667") || cfop.equals("7.651") || cfop.equals("7.654") || cfop.equals("7.667"))) {
            return uf.getSigla();
        }
        return null;
    }

    private UnidadeFederativa getUF(NFCeItem it) {
        UnidadeFederativa uf = null;
        uf = it.getNfce().getUnidadeFatCliente() != null ? it.getNfce().getUnidadeFatCliente().getPessoa().getEndereco().getCidade().getUf() : it.getNfce().getEmpresa().getPessoa().getEndereco().getCidade().getUf();
        return uf;
    }

    private NFeNotaFiscalPropria.NFNotaInfoCobranca getInfoCobranca(NFCe nf) {
        if (Objects.equals(nf.getModeloDocFiscal().getCodigo(), EnumConstantsModeloDocFiscal.NFCE_65.getCodigo())) {
            return null;
        }
        boolean possuiTitulos = false;
        if (nf.getPagamentos() != null && !nf.getPagamentos().isEmpty()) {
            for (NFCePagamento p : nf.getPagamentos()) {
                if (p.getTitulos() == null || p.getTitulos().isEmpty()) continue;
                possuiTitulos = true;
                break;
            }
        }
        if (!possuiTitulos) {
            return null;
        }
        NFeNotaFiscalPropria.NFNotaInfoCobranca c = new NFeNotaFiscalPropria.NFNotaInfoCobranca();
        Integer cont = 1;
        Double vlrLiqFatura = 0.0;
        for (NFCePagamento p : nf.getPagamentos()) {
            if (!ToolMethods.isEquals((Object)p.getTipoPagamentoNFe().getExibirTitulos(), (Object)1) || !ToolMethods.isEquals((Object)p.getStatus(), (Object)1)) continue;
            for (NFCeTitulo t : p.getTitulos()) {
                NFeNotaFiscalPropria.NFNotaInfoParcela infParc = new NFeNotaFiscalPropria.NFNotaInfoParcela();
                infParc.setDataVencimento(LocalDateTime.ofInstant(Instant.ofEpochMilli(t.getDataVencimento().getTime()), ZoneId.systemDefault()).toLocalDate());
                infParc.setValorParcela(t.getValor());
                infParc.setNumeroParcela(ToolString.completaZeros((String)cont.toString(), (int)3, (boolean)true));
                c.getParcelas().add(infParc);
                Integer n = cont;
                cont = cont + 1;
                vlrLiqFatura = vlrLiqFatura + t.getValor();
            }
        }
        if (vlrLiqFatura > 0.0) {
            c.setInfoFatura(this.getInfoFatura(vlrLiqFatura, nf));
        }
        return c;
    }

    private NFeNotaFiscalPropria.NFNotaInfoFatura getInfoFatura(Double vlrLiqFatura, NFCe nfce) {
        NFeNotaFiscalPropria.NFNotaInfoFatura f = new NFeNotaFiscalPropria.NFNotaInfoFatura();
        f.setNumeroFatura(ToolString.refina((String)nfce.getNumero().toString()));
        f.setValorDesconto(Double.valueOf(0.0));
        f.setValorOriginalFatura(vlrLiqFatura);
        f.setValorLiquidoFatura(vlrLiqFatura);
        return f;
    }

    private NFeNotaFiscalPropriaItem.NFeNotaInfoItemProduto.NFeNotaInfoItemProdutoCombustivel.NFeNotaInfoItemProdutoCombustivelEncerrante getEncerrantes(NFCeItem it) {
        if (it.getPreAbastecimento() == null) {
            return null;
        }
        NFeNotaFiscalPropriaItem.NFeNotaInfoItemProduto.NFeNotaInfoItemProdutoCombustivel.NFeNotaInfoItemProdutoCombustivelEncerrante enc = new NFeNotaFiscalPropriaItem.NFeNotaInfoItemProduto.NFeNotaInfoItemProdutoCombustivel.NFeNotaInfoItemProdutoCombustivelEncerrante();
        enc.setNumeroTanque(it.getPreAbastecimento().getBico().getTanqueCombustivel().getNumeroTanque().toString());
        enc.setNumeroBico(it.getPreAbastecimento().getBico().getCodigo());
        enc.setNumeroBomba(it.getPreAbastecimento().getBico().getBombaCombustivel().getNumeroBomba().toString());
        enc.setValorEncerramentoInicial(Double.valueOf(it.getPreAbastecimento().getValorEncerrante() - it.getPreAbastecimento().getQuantidade()));
        enc.setValorEncerramentoFinal(it.getPreAbastecimento().getValorEncerrante());
        return enc;
    }

    private NFeNotaFiscalPropria.NFeNotaInfoInformacoesAdicionais getInfoAdicionais(NFCe nfce) {
        NFeNotaFiscalPropria.NFeNotaInfoInformacoesAdicionais info = new NFeNotaFiscalPropria.NFeNotaInfoInformacoesAdicionais();
        StringBuilder obsFisco = new StringBuilder();
        StringBuilder obsContrib = new StringBuilder();
        if (nfce.getObsGeralContrib() != null) {
            obsContrib.append(nfce.getObsGeralContrib());
        }
        if (nfce.getObsGeralFisco() != null) {
            obsFisco.append(nfce.getObsGeralFisco());
        }
        nfce.getObsFisco().forEach(i -> {
            if (i.getConteudo() != null) {
                obsFisco.append(i.getConteudo());
            }
        });
        nfce.getObsContribuinte().forEach(i -> {
            if (i.getConteudo() != null) {
                obsContrib.append(i.getConteudo());
            }
        });
        info.setInformacoesComplementaresInteresseContribuinte(AuxEnviaNota.buildOBS(obsContrib.toString(), nfce));
        info.setInformacoesAdicionaisInteresseFisco(AuxEnviaNota.buildOBS(obsFisco.toString(), nfce));
        if (!ToolMethods.isStrWithData((String)obsContrib.toString()) && !ToolMethods.isStrWithData((String)obsFisco.toString())) {
            return null;
        }
        return info;
    }

    private static String buildOBS(String obsFat, NFCe nfce) {
        HelperSubOSFinderImpl helper = new HelperSubOSFinderImpl();
        if (obsFat != null && !obsFat.isEmpty()) {
            try {
                return ToolTextDynamic.build((Object)nfce, (String)obsFat, (ToolTextDynamic.HelperSubOSFinder)helper);
            }
            catch (ExceptionInvalidData | ExceptionReflection ex) {
                ex.printStackTrace();
                throw new RuntimeException(ex.getMessage());
            }
        }
        return "";
    }

    private Date getDataSaida(NFCe nfce) {
        if (ToolDate.dataSemHora((Date)nfce.getDataEmissao()).equals(ToolDate.dataSemHora((Date)nfce.getDataPrevSaida()))) {
            return nfce.getDataEmissao();
        }
        return nfce.getDataPrevSaida();
    }

    private NFeNotaFiscalPropriaItem.NFeNotaInfoItemProduto.NFeNotaInfoItemProdutoMedicamento getMedicamento(NFCeItem it) {
        if (ToolMethods.isStrWithData((String)it.getProduto().getCodAnvisa())) {
            NFeNotaFiscalPropriaItem.NFeNotaInfoItemProduto.NFeNotaInfoItemProdutoMedicamento med = new NFeNotaFiscalPropriaItem.NFeNotaInfoItemProduto.NFeNotaInfoItemProdutoMedicamento();
            med.setPrecoMaximoConsumidor(it.getProduto().getValorMaximoConsumo());
            if (!ToolMethods.isNull((Object)it.getProduto().getCodAnvisa()).booleanValue()) {
                med.setCodigoProdutoAnvisa(it.getProduto().getCodAnvisa());
            }
            return med;
        }
        return null;
    }

    private List<NFeNotaFiscalPropriaItem.NFeNotaInfoItemProduto.NFeNotaInfoItemProdutoRastreabilidade> getRastros(NFCeItem it) {
        ArrayList<NFeNotaFiscalPropriaItem.NFeNotaInfoItemProduto.NFeNotaInfoItemProdutoRastreabilidade> ret = new ArrayList<NFeNotaFiscalPropriaItem.NFeNotaInfoItemProduto.NFeNotaInfoItemProdutoRastreabilidade>();
        if (ToolMethods.isWithData(it.getLotes())) {
            it.getLotes().forEach(lt -> ret.add(this.getSingleRastro(lt.getNumeroLote(), lt.getDataFabricacao(), lt.getDataValidade(), lt.getQuantidade(), lt.getCodigoAgregacao())));
        } else {
            ret.add(this.getSingleRastro(it.getNrLoteFabricacao(), it.getDataFabricacao(), it.getDataValidade(), it.getQuantidadeComercial(), null));
        }
        return ret;
    }

    private NFeNotaFiscalPropriaItem.NFeNotaInfoItemProduto.NFeNotaInfoItemProdutoRastreabilidade getSingleRastro(String numeroLote, Date dataFabricacao, Date dataValidade, Double quantidade, String codigoAgregacao) {
        NFeNotaFiscalPropriaItem.NFeNotaInfoItemProduto.NFeNotaInfoItemProdutoRastreabilidade r = new NFeNotaFiscalPropriaItem.NFeNotaInfoItemProduto.NFeNotaInfoItemProdutoRastreabilidade();
        if (ToolMethods.isStrWithData((String)numeroLote)) {
            r.setNumeroLote(numeroLote);
        } else {
            r.setNumeroLote("UNICO");
        }
        if (dataFabricacao != null) {
            r.setDataFabricacao(LocalDateTime.ofInstant(Instant.ofEpochMilli(dataFabricacao.getTime()), ZoneId.systemDefault()).toLocalDate());
        } else {
            Date dataFab = ToolDate.previousDays((Date)new Date(), (int)30);
            r.setDataFabricacao(LocalDateTime.ofInstant(Instant.ofEpochMilli(dataFab.getTime()), ZoneId.systemDefault()).toLocalDate());
        }
        if (dataValidade != null) {
            r.setDataValidade(LocalDateTime.ofInstant(Instant.ofEpochMilli(dataValidade.getTime()), ZoneId.systemDefault()).toLocalDate());
        } else {
            Date dataVal = ToolDate.nextDays((Date)new Date(), (int)365);
            r.setDataValidade(LocalDateTime.ofInstant(Instant.ofEpochMilli(dataVal.getTime()), ZoneId.systemDefault()).toLocalDate());
        }
        r.setQuantidadeLote(quantidade);
        r.setCodigoAgregacao(ToolMethods.isNull((Object)codigoAgregacao) != false ? "-" : codigoAgregacao);
        return r;
    }

    private NFeNotaFiscalPropriaItem.NFeNotaInfoItemImposto.NFeNotaInfoItemImpostoICMS.NFeNotaInfoItemImpostoICMS90 getIcms90(NFCeItemICMS icms) {
        NFeNotaFiscalPropriaItem.NFeNotaInfoItemImposto.NFeNotaInfoItemImpostoICMS.NFeNotaInfoItemImpostoICMS90 ret = new NFeNotaFiscalPropriaItem.NFeNotaInfoItemImposto.NFeNotaInfoItemImpostoICMS.NFeNotaInfoItemImpostoICMS90();
        ret.setOrigem(ConstNFeOrigemProcedencia.valueOfCodigo((String)icms.getIncidenciaIcms().getCodigo().substring(0, 1)));
        ret.setCodSituacaoTributariaCST(icms.getIncidenciaIcms().getCodigo().substring(1));
        ret.setValorTributo(icms.getValorIcms());
        if (icms.getModalidadeIcms() != null) {
            ret.setCodModalidadeBCICMS(icms.getModalidadeIcms().getCodigo());
        }
        ret.setPercentualReducaoBC(icms.getPercRedBCIcms());
        ret.setValorBC(icms.getValorIcmsTributado());
        ret.setPercentualAliquota(icms.getAliquotaIcms());
        ret.setValorICMSDesoneracao(icms.getValorIcmsDesonerado());
        if (icms.getMotivoDesoneracaoIcms() != null) {
            ret.setCodigoDesoneracaoIcms(icms.getMotivoDesoneracaoIcms().getCodigo());
        }
        ret.setPercentualFundoCombatePobreza(Double.valueOf(0.0));
        ret.setPercentualFundoCombatePobrezaST(Double.valueOf(0.0));
        return ret;
    }

    private List ordenaListItens(List<NFCeItem> list) {
        Collections.sort(list, new Comparator(this){

            public int compare(Object o1, Object o2) {
                NFCeItem n1 = (NFCeItem)o1;
                NFCeItem n2 = (NFCeItem)o2;
                return n1.getNumeroItem().compareTo(n2.getNumeroItem());
            }
        });
        return list;
    }

    private static class HelperSubOSFinderImpl
    implements ToolTextDynamic.HelperSubOSFinder {
        public String getSubOSText(Long id) {
            if (id == null) {
                return null;
            }
            ObjectObsDinamica obs = (ObjectObsDinamica)Main.getBean(ServiceObjectObsDinamica.class).get(id);
            return obs != null ? obs.getObservacao() : null;
        }

        public String getSubOSTextCond(Long id) {
            if (id == null) {
                return null;
            }
            ObjectObsDinamica obs = (ObjectObsDinamica)Main.getBean(ServiceObjectObsDinamica.class).get(id);
            return obs != null ? obs.getCondicaoAplicacao() : null;
        }
    }
}

