/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.touchnfce.nfe.impl.versoes;

import com.fincatto.documentofiscal.DFModelo;
import com.fincatto.documentofiscal.DFUnidadeFederativa;
import com.fincatto.documentofiscal.nfe.NFeConfig;
import com.fincatto.documentofiscal.nfe310.classes.statusservico.consulta.NFStatusServicoConsultaRetorno;
import com.fincatto.documentofiscal.nfe310.webservices.WSFacade;
import com.fincatto.documentofiscal.nfe400.classes.cadastro.NFRetornoConsultaCadastro;
import com.fincatto.documentofiscal.nfe400.classes.cadastro.NFRetornoConsultaCadastroSituacaoCadastral;
import com.fincatto.documentofiscal.nfe400.classes.evento.NFEnviaEventoRetorno;
import com.fincatto.documentofiscal.nfe400.classes.evento.NFEventoRetorno;
import com.fincatto.documentofiscal.nfe400.classes.evento.NFInfoEventoRetorno;
import com.fincatto.documentofiscal.nfe400.classes.evento.epec.NFEnviaEventoEpecRetorno;
import com.fincatto.documentofiscal.nfe400.classes.evento.epec.NFEventoEpecRetorno;
import com.fincatto.documentofiscal.nfe400.classes.evento.epec.NFInfoEventoEpecRetorno;
import com.fincatto.documentofiscal.nfe400.classes.evento.inutilizacao.NFRetornoEventoInutilizacao;
import com.fincatto.documentofiscal.nfe400.classes.evento.manifestacaodestinatario.NFTipoEventoManifestacaoDestinatario;
import com.fincatto.documentofiscal.nfe400.classes.lote.consulta.NFLoteConsultaRetorno;
import com.fincatto.documentofiscal.nfe400.classes.lote.envio.NFCancelamentoRetornoDados;
import com.fincatto.documentofiscal.nfe400.classes.lote.envio.NFLoteEnvio;
import com.fincatto.documentofiscal.nfe400.classes.nota.consulta.NFNotaConsultaRetorno;
import com.touchcomp.basementor.constants.enums.EnumConstantsMentorStatus;
import com.touchcomp.basementor.constants.enums.configuracaocertificado.ConstAmbiente;
import com.touchcomp.basementor.constants.enums.nfce.EnumConstNFCeVersao;
import com.touchcomp.basementor.constants.enums.nfe.EnumConstNFeIndicadorContribuinte;
import com.touchcomp.basementor.constants.enums.nfe.EnumConstNFeStatus;
import com.touchcomp.basementor.constants.enums.uf.EnumConstUF;
import com.touchcomp.basementorclientwebservices.nfe.impl.envialote.UtilEnviaNFe;
import com.touchcomp.basementorclientwebservices.nfe.model.env.cancelarnota.NFeCancelarNota;
import com.touchcomp.basementorclientwebservices.nfe.model.env.consultacadastro.NFeConsultaCadastro;
import com.touchcomp.basementorclientwebservices.nfe.model.env.consultalote.NFeConsultaLote;
import com.touchcomp.basementorclientwebservices.nfe.model.env.consultanota.ConsultaNFeRet;
import com.touchcomp.basementorclientwebservices.nfe.model.env.consultanota.NFEventoInfoRet;
import com.touchcomp.basementorclientwebservices.nfe.model.env.consultanota.NFeConsultaNota;
import com.touchcomp.basementorclientwebservices.nfe.model.env.consultanota.NFeProtocolo;
import com.touchcomp.basementorclientwebservices.nfe.model.env.corrigenota.NFeCorrigirNota;
import com.touchcomp.basementorclientwebservices.nfe.model.env.inutilizarnota.NFeInutilizarNumeracao;
import com.touchcomp.basementorclientwebservices.nfe.model.env.lotefat.NFeLoteFaturamento;
import com.touchcomp.basementorclientwebservices.nfe.model.env.manifestonota.NFeManifestarNota;
import com.touchcomp.basementorclientwebservices.nfe.model.ret.NFeEnviaEventoRet;
import com.touchcomp.basementorclientwebservices.nfe.model.ret.consultacadastro.NFeConsultaCadastroRet;
import com.touchcomp.basementorclientwebservices.nfe.model.ret.consultalote.NFeLoteConsultaRet;
import com.touchcomp.basementorclientwebservices.nfe.model.ret.inutilizacao.NFeInutilizacaoRet;
import com.touchcomp.basementorclientwebservices.nfe.model.ret.lotefat.NFeLoteDadosRet;
import com.touchcomp.basementorclientwebservices.nfe.model.ret.statusservico.NFeStatusServicoRet;
import com.touchcomp.basementortools.tools.date.ToolDate;
import com.touchcomp.basementortools.tools.methods.ToolMethods;
import com.touchcomp.touchnfce.nfe.impl.versoes.ConfigCertificate;
import com.touchcomp.touchnfce.nfe.impl.versoes.ConstNFeVersoes;
import com.touchcomp.touchnfce.nfe.impl.versoes.UtilNFeFactory;
import com.touchcomp.touchnfce.nfe.impl.versoes.base.WritterNFeDef;
import com.touchcomp.touchnfce.utils.UtilXML;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.Date;
import org.jetbrains.annotations.NotNull;

public class UtilNfeSendWebServices {
    public static NFeStatusServicoRet consultarStatusServico(@NotNull ConfigCertificate configr, @NotNull EnumConstUF unidadeFederativa, @NotNull DFModelo modelo) throws Exception {
        NFeStatusServicoRet ret = new NFeStatusServicoRet();
        if (ToolMethods.isEquals((Object)unidadeFederativa.getCodigoIbge(), (Object)EnumConstUF.AM.getCodigoIbge())) {
            NFStatusServicoConsultaRetorno retNFCe = new WSFacade(UtilNfeSendWebServices.toInternalConf(configr)).consultaStatus(DFUnidadeFederativa.valueOfCodigo((String)unidadeFederativa.getCodigoIbge()), modelo);
            ret.setAmbiente(ConstAmbiente.valueOfCodigo((String)retNFCe.getAmbiente().getCodigo()));
            ret.setDataRecebimento(retNFCe.getDataRecebimento().toLocalDate().atStartOfDay());
            if (retNFCe.getDataRetorno() != null) {
                ret.setDataRetorno(retNFCe.getDataRetorno().toLocalDate().atStartOfDay());
            }
            if (ToolMethods.isEquals((Object)modelo, (Object)DFModelo.NFCE)) {
                ret.setStatusNFCe(retNFCe.getStatus());
                ret.setMotivoNFCe(retNFCe.getMotivo());
            } else {
                ret.setStatusNFe(retNFCe.getStatus());
                ret.setMotivoNFe(retNFCe.getMotivo());
            }
            ret.setObservacao(retNFCe.getObservacao());
            ret.setTempoMedio(retNFCe.getTempoMedio());
            ret.setVersao(retNFCe.getVersao());
            ret.setVersaoAplicacao(retNFCe.getVersaoAplicacao());
        } else {
            com.fincatto.documentofiscal.nfe400.classes.statusservico.consulta.NFStatusServicoConsultaRetorno retNFCe = new com.fincatto.documentofiscal.nfe400.webservices.WSFacade(UtilNfeSendWebServices.toInternalConf(configr)).consultaStatus(DFUnidadeFederativa.valueOfCodigo((String)unidadeFederativa.getCodigoIbge()), modelo);
            ret.setAmbiente(ConstAmbiente.valueOfCodigo((String)retNFCe.getAmbiente().getCodigo()));
            ret.setDataRecebimento(retNFCe.getDataRecebimento().toLocalDate().atStartOfDay());
            if (retNFCe.getDataRetorno() != null) {
                ret.setDataRetorno(retNFCe.getDataRetorno().toLocalDate().atStartOfDay());
            }
            if (ToolMethods.isEquals((Object)modelo, (Object)DFModelo.NFCE)) {
                ret.setStatusNFCe(retNFCe.getStatus());
                ret.setMotivoNFCe(retNFCe.getMotivo());
            } else {
                ret.setStatusNFe(retNFCe.getStatus());
                ret.setMotivoNFe(retNFCe.getMotivo());
            }
            ret.setObservacao(retNFCe.getObservacao());
            ret.setTempoMedio(retNFCe.getTempoMedio());
            ret.setVersao(retNFCe.getVersao());
            ret.setVersaoAplicacao(retNFCe.getVersaoAplicacao());
        }
        return ret;
    }

    public static NFLoteEnvio getLoteAssinado(ConfigCertificate config, ConstNFeVersoes versao, NFeLoteFaturamento lote) throws Exception {
        WritterNFeDef writter = UtilNFeFactory.getInstance().getVersao(versao, lote);
        NFLoteEnvio loteEnvio = writter.getLoteEnvio();
        System.out.println(loteEnvio.toString());
        NFLoteEnvio retorno = new com.fincatto.documentofiscal.nfe400.webservices.WSFacade(UtilNfeSendWebServices.toInternalConf(config)).getLoteAssinado(loteEnvio);
        return retorno;
    }

    public static NFeLoteDadosRet enviarNota(ConfigCertificate config, ConstNFeVersoes versao, NFeLoteFaturamento lote) throws Exception {
        WritterNFeDef writter = UtilNFeFactory.getInstance().getVersao(versao, lote);
        NFLoteEnvio loteEnvio = writter.getLoteEnvio();
        UtilXML.writeTempFileEnvio(String.valueOf(lote.getIdentificador()), loteEnvio.toString());
        NFeConfig confEnvio = UtilNfeSendWebServices.toInternalConf(config);
        UtilEnviaNFe api = new UtilEnviaNFe();
        NFeLoteDadosRet ret = api.enviarNota(confEnvio, EnumConstNFCeVersao.VERSAO_20180005_1_20, loteEnvio);
        return ret;
    }

    public static NFeEnviaEventoRet enviarNotaEPEC(ConfigCertificate config, ConstNFeVersoes versao, NFeLoteFaturamento lote) throws Exception {
        WritterNFeDef writter = UtilNFeFactory.getInstance().getVersao(versao, lote);
        NFLoteEnvio loteEnvio = writter.getLoteEnvio();
        NFEnviaEventoEpecRetorno retorno = new com.fincatto.documentofiscal.nfe400.webservices.WSFacade(UtilNfeSendWebServices.toInternalConf(config)).enviaLoteEpec(loteEnvio);
        System.out.println(retorno.toString());
        NFeEnviaEventoRet ret = new NFeEnviaEventoRet();
        ret.setAmbiente(ConstAmbiente.valueOfCodigo((String)retorno.getAmbiente().getCodigo()));
        ret.setCodigoStatusReposta(retorno.getCodigoStatusReposta());
        ret.setIdLote(retorno.getIdLote());
        ret.setMotivo(retorno.getMotivo());
        ret.setOrgao(EnumConstUF.valueOfCodigoIbge((String)retorno.getOrgao().getCodigoIbge()));
        ret.setVersao(retorno.getVersao());
        ret.setVersaoAplicativo(retorno.getVersaoAplicativo());
        for (NFEventoEpecRetorno retEvt : retorno.getEventoRetorno()) {
            NFInfoEventoEpecRetorno info = retEvt.getInfoEventoRetorno();
            NFeEnviaEventoRet.NFEEnviaEventoRetDet aux = new NFeEnviaEventoRet.NFEEnviaEventoRetDet();
            aux.setAmbiente(ConstAmbiente.valueOfCodigo((String)info.getAmbiente().getCodigo()));
            aux.setChave(info.getChave());
            aux.setCodigoStatus(info.getCodigoStatus());
            aux.setDataHoraRegistro(new Date());
            aux.setDescricaoEvento(info.getDescricaoEvento());
            aux.setId(info.getId());
            aux.setMotivo(info.getMotivo());
            aux.setNumeroProtocolo(info.getNumeroProtocolo());
            aux.setNumeroSequencialEvento(info.getNumeroSequencialEvento());
            aux.setCodUFOrgao(info.getOrgao().getCodigo());
            aux.setTipoEvento(info.getTipoEvento());
            aux.setVersaoAplicativo(info.getVersaoAplicativo());
            ret.getDetEventos().add(aux);
        }
        return ret;
    }

    public static byte[] createXMLSemValidade(ConstNFeVersoes versao, NFeLoteFaturamento lote) throws Exception {
        WritterNFeDef writter = UtilNFeFactory.getInstance().getVersao(versao, lote);
        NFLoteEnvio loteEnvio = writter.getLoteEnvio();
        return loteEnvio.toString().getBytes();
    }

    private static NFeEnviaEventoRet cancelarNotaPorSubstituicao(ConfigCertificate config, NFeCancelarNota dados) throws Exception {
        NFEnviaEventoRetorno retorno = new com.fincatto.documentofiscal.nfe400.webservices.WSFacade(UtilNfeSendWebServices.toInternalConf(config)).cancelaNotaPorSubstituicao(dados.getChave(), dados.getNumeroProtocolo(), dados.getMotivo(), "MENTOR_ERP_NFE_400", dados.getChaveSubstituta());
        return UtilNfeSendWebServices.buildRetornoCancelamento(retorno);
    }

    private static NFeEnviaEventoRet cancelarNota(ConfigCertificate config, NFeCancelarNota dados) throws Exception {
        NFCancelamentoRetornoDados retorno = new com.fincatto.documentofiscal.nfe400.webservices.WSFacade(UtilNfeSendWebServices.toInternalConf(config)).cancelaNota(dados.getChave(), dados.getNumeroProtocolo(), dados.getMotivo());
        return UtilNfeSendWebServices.buildRetornoCancelamento(retorno.getRetorno());
    }

    private static NFeEnviaEventoRet buildRetornoCancelamento(NFEnviaEventoRetorno retorno) {
        NFeEnviaEventoRet ret = new NFeEnviaEventoRet();
        ret.setAmbiente(ConstAmbiente.valueOfCodigo((String)retorno.getAmbiente().getCodigo()));
        ret.setCodigoStatusReposta(retorno.getCodigoStatusReposta());
        ret.setIdLote(retorno.getIdLote());
        ret.setMotivo(retorno.getMotivo());
        ret.setOrgao(EnumConstUF.valueOfCodigoIbge((String)retorno.getOrgao().getCodigoIbge()));
        ret.setVersao(retorno.getVersao());
        ret.setVersaoAplicativo(retorno.getVersaoAplicativo());
        for (NFEventoRetorno retEvt : retorno.getEventoRetorno()) {
            NFInfoEventoRetorno info = retEvt.getInfoEventoRetorno();
            NFeEnviaEventoRet.NFEEnviaEventoRetDet aux = new NFeEnviaEventoRet.NFEEnviaEventoRetDet();
            aux.setAmbiente(ConstAmbiente.valueOfCodigo((String)info.getAmbiente().getCodigo()));
            aux.setChave(info.getChave());
            aux.setCodigoStatus(info.getCodigoStatus());
            aux.setCpf(info.getCpf());
            aux.setCpnj(info.getCnpj());
            aux.setDataHoraRegistro(new Date());
            aux.setDescricaoEvento(info.getDescricaoEvento());
            aux.setEmail(info.getEmail());
            aux.setId(info.getId());
            aux.setMotivo(info.getMotivo());
            aux.setNumeroProtocolo(info.getNumeroProtocolo());
            aux.setNumeroSequencialEvento(info.getNumeroSequencialEvento());
            aux.setCodUFOrgao(info.getOrgao().getCodigo());
            aux.setTipoEvento(info.getTipoEvento());
            aux.setVersaoAplicativo(info.getVersaoAplicativo());
            ret.getDetEventos().add(aux);
        }
        return ret;
    }

    public static NFeEnviaEventoRet cancelarNota(ConfigCertificate config, ConstNFeVersoes versao, NFeCancelarNota dados, Boolean cancelamentoPorSubstituicao) throws Exception {
        if (cancelamentoPorSubstituicao.booleanValue()) {
            return UtilNfeSendWebServices.cancelarNotaPorSubstituicao(config, dados);
        }
        return UtilNfeSendWebServices.cancelarNota(config, dados);
    }

    public static NFeEnviaEventoRet corrigeNota(ConfigCertificate config, ConstNFeVersoes versao, NFeCorrigirNota dados) throws Exception {
        NFEnviaEventoRetorno retorno = new com.fincatto.documentofiscal.nfe400.webservices.WSFacade(UtilNfeSendWebServices.toInternalConf(config)).corrigeNota(dados.getChave(), dados.getTextoCorrecao(), dados.getNrSequencial());
        NFeEnviaEventoRet ret = new NFeEnviaEventoRet();
        ret.setAmbiente(ConstAmbiente.valueOfCodigo((String)retorno.getAmbiente().getCodigo()));
        ret.setCodigoStatusReposta(retorno.getCodigoStatusReposta());
        ret.setIdLote(retorno.getIdLote());
        ret.setMotivo(retorno.getMotivo());
        ret.setOrgao(EnumConstUF.valueOfCodigoIbge((String)retorno.getOrgao().getCodigoIbge()));
        ret.setVersao(retorno.getVersao());
        ret.setVersaoAplicativo(retorno.getVersaoAplicativo());
        return ret;
    }

    public static NFeEnviaEventoRet manifestarNota(ConfigCertificate config, ConstNFeVersoes versao, NFeManifestarNota dados) throws Exception {
        NFEnviaEventoRetorno retorno = new com.fincatto.documentofiscal.nfe400.webservices.WSFacade(UtilNfeSendWebServices.toInternalConf(config)).manifestaDestinatarioNota(dados.getChave(), NFTipoEventoManifestacaoDestinatario.valueOfCodigo((String)dados.getTipoEvento().getCodigo()), dados.getMotivo(), dados.getCnpj());
        NFeEnviaEventoRet ret = new NFeEnviaEventoRet();
        ret.setAmbiente(ConstAmbiente.valueOfCodigo((String)retorno.getAmbiente().getCodigo()));
        ret.setCodigoStatusReposta(retorno.getCodigoStatusReposta());
        ret.setIdLote(retorno.getIdLote());
        ret.setMotivo(retorno.getMotivo());
        ret.setOrgao(EnumConstUF.valueOfCodigoIbge((String)retorno.getOrgao().getCodigoIbge()));
        ret.setVersao(retorno.getVersao());
        ret.setVersaoAplicativo(retorno.getVersaoAplicativo());
        return ret;
    }

    public static NFeLoteConsultaRet consultarLote(ConfigCertificate config, ConstNFeVersoes versao, NFeConsultaLote dados) throws Exception {
        NFLoteConsultaRetorno retorno = new com.fincatto.documentofiscal.nfe400.webservices.WSFacade(UtilNfeSendWebServices.toInternalConf(config)).consultaLote(dados.getNumeroRecibo(), DFModelo.valueOfCodigo((String)dados.getTipoDocumento().getCodigo()));
        NFeLoteConsultaRet ret = new NFeLoteConsultaRet();
        ret.setAmbiente(ConstAmbiente.valueOfCodigo((String)retorno.getAmbiente().getCodigo()));
        ret.setCodigoMessage(retorno.getCodigoMessage());
        ret.setDataHoraRecebimento(retorno.getDataHoraRecebimento().toLocalDate().atStartOfDay());
        ret.setMensagem(retorno.getMensagem());
        ret.setMotivo(retorno.getMotivo());
        ret.setNumeroRecibo(retorno.getNumeroRecibo());
        ret.setStatus(retorno.getStatus());
        ret.setUf(EnumConstUF.valueOfCodigoIbge((String)retorno.getUf().getCodigoIbge()));
        ret.setVersao(retorno.getVersao());
        ret.setVersaoAplicacao(retorno.getVersaoAplicacao());
        retorno.getProtocolos().forEach(i -> {
            NFeProtocolo prot = new NFeProtocolo();
            prot.setAmbiente(ConstAmbiente.valueOfCodigo((String)i.getProtocoloInfo().getAmbiente().getCodigo()));
            prot.setChave(i.getProtocoloInfo().getChave());
            prot.setDataRecebimento(i.getProtocoloInfo().getDataRecebimento());
            prot.setIdentificador(i.getProtocoloInfo().getIdentificador());
            prot.setMotivo(i.getProtocoloInfo().getMotivo());
            prot.setNumeroProtocolo(i.getProtocoloInfo().getNumeroProtocolo());
            prot.setStatus(i.getProtocoloInfo().getStatus());
            prot.setValidador(i.getProtocoloInfo().getValidador());
            prot.setVersao(i.getVersao());
            prot.setVersaoAplicacao(i.getProtocoloInfo().getVersaoAplicacao());
            ret.getProtocolos().add(prot);
        });
        return ret;
    }

    public static ConsultaNFeRet consultarNota(ConfigCertificate config, ConstNFeVersoes versao, NFeConsultaNota dados) throws Exception {
        NFNotaConsultaRetorno retorno = new com.fincatto.documentofiscal.nfe400.webservices.WSFacade(UtilNfeSendWebServices.toInternalConf(config)).consultaNota(dados.getChaveNFe());
        if (EnumConstNFeStatus.getByCodigo((String)retorno.getStatus()) == EnumConstNFeStatus.REJ_FALHA_SCHEMA_XML) {
            throw new Exception("Houve falha ao consultar o status da NFe: " + retorno.getMotivo());
        }
        ConsultaNFeRet ret = new ConsultaNFeRet();
        ret.setAmbiente(ConstAmbiente.valueOfCodigo((String)retorno.getAmbiente().getCodigo()));
        ret.setChave(retorno.getChave());
        ret.setDataHoraRecibo(retorno.getDataHoraRecibo());
        ret.setMotivo(retorno.getMotivo());
        if (retorno.getProtocolo() != null) {
            ret.setProtocolo(new NFeProtocolo());
            ret.getProtocolo().setAmbiente(ConstAmbiente.valueOfCodigo((String)retorno.getProtocolo().getProtocoloInfo().getAmbiente().getCodigo()));
            ret.getProtocolo().setChave(retorno.getProtocolo().getProtocoloInfo().getChave());
            ret.getProtocolo().setDataRecebimento(retorno.getProtocolo().getProtocoloInfo().getDataRecebimento());
            ret.getProtocolo().setIdentificador(retorno.getProtocolo().getProtocoloInfo().getIdentificador());
            ret.getProtocolo().setMotivo(retorno.getProtocolo().getProtocoloInfo().getMotivo());
            ret.getProtocolo().setNumeroProtocolo(retorno.getProtocolo().getProtocoloInfo().getNumeroProtocolo());
            ret.getProtocolo().setStatus(retorno.getProtocolo().getProtocoloInfo().getStatus());
            ret.getProtocolo().setValidador(retorno.getProtocolo().getProtocoloInfo().getValidador());
            ret.getProtocolo().setVersao(retorno.getProtocolo().getVersao());
            ret.getProtocolo().setVersaoAplicacao(retorno.getProtocolo().getProtocoloInfo().getVersaoAplicacao());
            ret.getProtocolo().setXml(retorno.getProtocolo().toString());
        }
        if (retorno.getProtocoloCancelamento() != null) {
            ret.setProtocoloCancelamento(new NFeProtocolo());
            ret.getProtocoloCancelamento().setAmbiente(ConstAmbiente.valueOfCodigo((String)retorno.getProtocoloCancelamento().getInfoCancelamento().getAmbiente().getCodigo()));
            ret.getProtocoloCancelamento().setChave(retorno.getProtocoloCancelamento().getInfoCancelamento().getChave());
            ret.getProtocoloCancelamento().setDataRecebimento(retorno.getProtocoloCancelamento().getInfoCancelamento().getDatahoraRecebimento());
            ret.getProtocoloCancelamento().setIdentificador(retorno.getProtocoloCancelamento().getInfoCancelamento().getIdentificador());
            ret.getProtocoloCancelamento().setMotivo(retorno.getProtocoloCancelamento().getInfoCancelamento().getMotivo());
            ret.getProtocoloCancelamento().setNumeroProtocolo(retorno.getProtocoloCancelamento().getInfoCancelamento().getNumeroProtocolo());
            ret.getProtocoloCancelamento().setStatus(retorno.getProtocoloCancelamento().getInfoCancelamento().getCodigoStatus());
            ret.getProtocoloCancelamento().setVersao(retorno.getProtocoloCancelamento().getVersao());
            ret.getProtocoloCancelamento().setVersaoAplicacao(retorno.getProtocoloCancelamento().getInfoCancelamento().getVersaoAplicacao());
            ret.getProtocoloCancelamento().setXml(retorno.getProtocolo().toString());
        }
        ret.setUf(EnumConstUF.valueOfCodigoIbge((String)retorno.getUf().getCodigoIbge()));
        ret.setStatus(retorno.getStatus());
        ret.setVersao(retorno.getVersao());
        ret.setVersaoAplicacao(retorno.getVersaoAplicacao());
        if (retorno.getProtocoloEvento() != null) {
            retorno.getProtocoloEvento().forEach(i -> {
                NFEventoInfoRet prot = new NFEventoInfoRet();
                if (i.getEvento() != null) {
                    prot.setEvento(new NFEventoInfoRet.NFeEvento());
                    prot.getEvento().setAmbiente(ConstAmbiente.valueOfCodigo((String)i.getEvento().getInfoEvento().getAmbiente().getCodigo()));
                    prot.getEvento().setChave(i.getEvento().getInfoEvento().getChave());
                    prot.getEvento().setCnpj(i.getEvento().getInfoEvento().getCnpj());
                    prot.getEvento().setCodigoEvento(i.getEvento().getInfoEvento().getCodigoEvento());
                    prot.getEvento().setCpf(i.getEvento().getInfoEvento().getCpf());
                    prot.getEvento().setDataHoraEvento(i.getEvento().getInfoEvento().getDataHoraEvento());
                    prot.getEvento().setId(i.getEvento().getInfoEvento().getId());
                    prot.getEvento().setNumeroSequencialEvento(Integer.valueOf(i.getEvento().getInfoEvento().getNumeroSequencialEvento()));
                    prot.getEvento().setOrgao(EnumConstUF.valueOfCodigoIbge((String)i.getEvento().getInfoEvento().getOrgao().getCodigoIbge()));
                    prot.getEvento().setVersao(i.getEvento().getVersao());
                    prot.getEvento().setVersaoEvento(i.getEvento().getInfoEvento().getVersaoEvento());
                }
                if (i.getInfoEventoRetorno() != null) {
                    prot.setEventoRetorno(new NFEventoInfoRet.NFEventoRet());
                    prot.getEventoRetorno().setAmbiente(ConstAmbiente.valueOfCodigo((String)i.getInfoEventoRetorno().getInfoEventoRetorno().getAmbiente().getCodigo()));
                    prot.getEventoRetorno().setChave(i.getInfoEventoRetorno().getInfoEventoRetorno().getChave());
                    prot.getEventoRetorno().setCodigoStatus(i.getInfoEventoRetorno().getInfoEventoRetorno().getCodigoStatus());
                    prot.getEventoRetorno().setCpf(i.getInfoEventoRetorno().getInfoEventoRetorno().getCpf());
                    prot.getEventoRetorno().setCpnj(i.getInfoEventoRetorno().getInfoEventoRetorno().getCnpj());
                    prot.getEventoRetorno().setDataHoraRegistro(i.getInfoEventoRetorno().getInfoEventoRetorno().getDataHoraRegistro().toLocalDate().atStartOfDay());
                    prot.getEventoRetorno().setDescricaoEvento(i.getInfoEventoRetorno().getInfoEventoRetorno().getDescricaoEvento());
                    prot.getEventoRetorno().setEmail(i.getInfoEventoRetorno().getInfoEventoRetorno().getEmail());
                    prot.getEventoRetorno().setId(i.getInfoEventoRetorno().getInfoEventoRetorno().getId());
                    prot.getEventoRetorno().setMotivo(i.getInfoEventoRetorno().getInfoEventoRetorno().getMotivo());
                    prot.getEventoRetorno().setNumeroProtocolo(i.getInfoEventoRetorno().getInfoEventoRetorno().getNumeroProtocolo());
                    prot.getEventoRetorno().setNumeroSequencialEvento(i.getInfoEventoRetorno().getInfoEventoRetorno().getNumeroSequencialEvento());
                    prot.getEventoRetorno().setOrgao(EnumConstUF.valueOfCodigoIbge((String)i.getInfoEventoRetorno().getInfoEventoRetorno().getOrgao().getCodigoIbge()));
                    prot.getEventoRetorno().setTipoEvento(i.getInfoEventoRetorno().getInfoEventoRetorno().getTipoEvento());
                    prot.getEventoRetorno().setVersaoAplicativo(i.getInfoEventoRetorno().getInfoEventoRetorno().getVersaoAplicativo());
                }
                prot.setVersao(i.getVersao());
                ret.getProtocoloEvento().add(prot);
            });
        }
        return ret;
    }

    public static NFeInutilizacaoRet inutilizarNota(ConfigCertificate config, ConstNFeVersoes versao, NFeInutilizarNumeracao dados) throws Exception {
        NFRetornoEventoInutilizacao retorno = new com.fincatto.documentofiscal.nfe400.webservices.WSFacade(UtilNfeSendWebServices.toInternalConf(config)).inutilizaNota(dados.getAnoInutilizacaoNumeracao(), dados.getCnpjEmitente(), dados.getSerie(), dados.getNumeroInicial(), dados.getNumeroFinal(), dados.getJustificativa(), DFModelo.valueOfCodigo((String)dados.getModelo().getCodigo()));
        NFeInutilizacaoRet ret = new NFeInutilizacaoRet();
        ret.setAmbiente(ConstAmbiente.valueOfCodigo((String)retorno.getDados().getAmbiente().getCodigo()));
        ret.setAno(retorno.getDados().getAno());
        ret.setCnpj(retorno.getDados().getCnpj());
        ret.setDatahoraRecebimento(retorno.getDados().getDatahoraRecebimento());
        ret.setIdentificador(retorno.getDados().getIdentificador());
        ret.setModeloNotaFiscal(retorno.getDados().getModeloNotaFiscal());
        ret.setMotivo(retorno.getDados().getMotivo());
        ret.setNumeroNFInicial(retorno.getDados().getNumeroNFInicial());
        ret.setNumeroNFFinal(retorno.getDados().getNumeroNFFinal());
        ret.setNumeroProtocolo(retorno.getDados().getNumeroProtocolo());
        ret.setSerie(retorno.getDados().getSerie());
        ret.setStatus(retorno.getDados().getStatus());
        ret.setUf(EnumConstUF.valueOfCodigoIbge((String)retorno.getDados().getUf().getCodigoIbge()));
        ret.setVersao(retorno.getVersao());
        ret.setVersaoAplicacao(retorno.getDados().getVersaoAplicacao());
        ret.setXmlRecebido(retorno.getDados().toString());
        return ret;
    }

    public static NFeConsultaCadastroRet consultaCadastro(ConfigCertificate config, ConstNFeVersoes versao, NFeConsultaCadastro dados) throws Exception {
        NFRetornoConsultaCadastro retorno = new com.fincatto.documentofiscal.nfe400.webservices.WSFacade(UtilNfeSendWebServices.toInternalConf(config)).consultaCadastro(dados.getCnpj(), DFUnidadeFederativa.valueOfCodigo((String)dados.getCodigoUf()));
        NFeConsultaCadastroRet ret = new NFeConsultaCadastroRet();
        ret.setCnpj(retorno.getDados().getCnpj());
        ret.setCodigoUf(retorno.getDados().getUf().getCodigoIbge());
        ret.setCodigoUfAutorizadora(retorno.getDados().getUfAutorizadora().getCodigoIbge());
        ret.setCpf(retorno.getDados().getCpf());
        ret.setDataHoraProcessamento(ToolDate.asDate((LocalDateTime)retorno.getDados().getDataHoraProcessamento()));
        ret.setInscricaoEstadual(retorno.getDados().getInscricaoEstadual());
        ret.setMotivo(retorno.getDados().getMotivo());
        ret.setStatusResposta(retorno.getDados().getStatusResposta());
        ret.setVersaoAplicacao(retorno.getDados().getVersaoAplicacao());
        for (NFRetornoConsultaCadastroSituacaoCadastral aux : retorno.getDados().getSituacaoCadastral()) {
            NFeConsultaCadastroRet.NFeConsultaCadastroSitCadRet sit = new NFeConsultaCadastroRet.NFeConsultaCadastroSitCadRet();
            sit.setCnaePrincipalContribuinte(aux.getCnaePrincipalContribuinte());
            sit.setCnpj(aux.getCnpj());
            sit.setCodigoUf(aux.getUf().getCodigo());
            sit.setCpf(aux.getCpf());
            sit.setDataInicioAtividade(ToolDate.asDate((LocalDate)aux.getDataInicioAtividade()));
            sit.setDataOcorrenciaBaixa(ToolDate.asDate((LocalDate)aux.getDataOcorrenciaBaixa()));
            sit.setDataUltimaModificacaoSituacaoCadastral(ToolDate.asDate((LocalDate)aux.getDataUltimaModificacaoSituacaoCadastral()));
            sit.setIndicadorContribuinteNFe(EnumConstNFeIndicadorContribuinte.valueOfCodigo((int)aux.getIndicadorContribuinteNFe().getCodigo()));
            sit.setIndicaodrContribuinteCTe(EnumConstNFeIndicadorContribuinte.valueOfCodigo((int)aux.getIndicaodrContribuinteCTe().getCodigo()));
            sit.setInscricaoEstadual(aux.getInscricaoEstadual());
            sit.setInscricaoEstadualAtual(aux.getInscricaoEstadualAtual());
            sit.setInscricaoEstadualUnica(aux.getInscricaoEstadualUnica());
            sit.setNomeFantasia(aux.getNomeFantasia());
            sit.setRazaoSocial(aux.getRazaoSocial());
            sit.setRegimeApuracaoICMSContribuinte(aux.getRegimeApuracaoICMSContribuinte());
            sit.setSitContribuinteHabilitado(EnumConstantsMentorStatus.get((Object)String.valueOf(aux.getSituacaoContribuinte().getCodigo())));
            ret.getSituacaoCadastral().add(sit);
            sit.setEndereco(new NFeConsultaCadastroRet.NFeConsultaCadastroEndRet());
            sit.getEndereco().setBairro(aux.getEndereco().getBairro());
            sit.getEndereco().setCep(aux.getEndereco().getCep());
            sit.getEndereco().setCodigoMunicipio(aux.getEndereco().getCodigoMunicipio());
            sit.getEndereco().setComplemento(aux.getEndereco().getComplemento());
            sit.getEndereco().setDescricaoMunicipio(aux.getEndereco().getDescricaoMunicipio());
            sit.getEndereco().setLogradouro(aux.getEndereco().getLogradouro());
            sit.getEndereco().setNumero(aux.getEndereco().getNumero());
        }
        return ret;
    }

    private static NFeConfig toInternalConf(ConfigCertificate config) {
        return config;
    }

    private static String getXMLAutorizacao(String retorno) {
        String xml = retorno;
        int posicao = retorno.indexOf("<infProt");
        if (posicao >= 0) {
            xml = retorno.substring(posicao);
            xml = xml.replaceAll("</retEnviNFe>", "");
            StringBuilder sb = new StringBuilder();
            sb.append("<?xml version=\"1.0\" encoding=\"UTF-8\" standalone=\"yes\"?><protNFe xmlns=\"http://www.portalfiscal.inf.br/nfe\" versao=\"4.00\">");
            sb.append(xml);
            sb.append("</protNFe>");
            return sb.toString();
        }
        return null;
    }
}

