/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.touchnfce.print;

import com.touchcomp.basementorexceptions.exceptions.impl.ioexception.ExceptionIO;
import com.touchcomp.basementorexceptions.exceptions.impl.jasperreports.ExceptionJasperReports;
import com.touchcomp.basementorlogger.TLogger;
import com.touchcomp.basementortools.tools.file.ToolFile;
import com.touchcomp.basementortools.tools.methods.ToolMethods;
import com.touchcomp.basementortools.tools.system.ToolSystem;
import com.touchcomp.touchnfce.StaticObjects;
import java.awt.print.Pageable;
import java.awt.print.PrinterException;
import java.awt.print.PrinterJob;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.print.PrintService;
import javax.print.attribute.HashPrintServiceAttributeSet;
import javax.print.attribute.PrintServiceAttributeSet;
import javax.print.attribute.standard.PrinterName;
import net.sf.jasperreports.engine.JRDataSource;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JasperExportManager;
import net.sf.jasperreports.engine.JasperFillManager;
import net.sf.jasperreports.engine.JasperPrint;
import net.sf.jasperreports.engine.JasperPrintManager;
import net.sf.jasperreports.engine.data.JRBeanCollectionDataSource;
import net.sf.jasperreports.engine.data.JRXmlDataSource;
import net.sf.jasperreports.engine.export.JRPrintServiceExporter;
import net.sf.jasperreports.export.ExporterConfiguration;
import net.sf.jasperreports.export.ExporterInput;
import net.sf.jasperreports.export.SimpleExporterInput;
import net.sf.jasperreports.export.SimplePrintServiceExporterConfiguration;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.printing.PDFPageable;

public abstract class PrintReport<V> {
    private Map<String, Object> params = new HashMap<String, Object>();

    public JasperPrint generateReportListDataSource(List data) throws ExceptionJasperReports {
        try {
            JasperPrint jasperPrint = null;
            jasperPrint = JasperFillManager.fillReport((String)this.getPath(), this.getParams(), (JRDataSource)new JRBeanCollectionDataSource((Collection)data));
            return jasperPrint;
        }
        catch (JRException e) {
            e.printStackTrace();
            TLogger.get(PrintReport.class).error(((Object)((Object)e)).getClass(), (Throwable)e);
            throw new ExceptionJasperReports(e.getMessage(), (Throwable)e);
        }
    }

    public JasperPrint generateReportXMLSource(InputStream xml, String startTag) throws ExceptionJasperReports {
        try {
            JasperPrint jasperPrint = null;
            jasperPrint = JasperFillManager.fillReport((String)this.getPath(), this.getParams(), (JRDataSource)new JRXmlDataSource(xml, startTag));
            return jasperPrint;
        }
        catch (JRException e) {
            e.printStackTrace();
            TLogger.get(PrintReport.class).error(((Object)((Object)e)).getClass(), (Throwable)e);
            throw new ExceptionJasperReports(e.getMessage(), (Throwable)e);
        }
    }

    public void writterReportInPDF(JasperPrint jasperPrint, File file) throws ExceptionJasperReports {
        try {
            byte[] array = JasperExportManager.exportReportToPdf((JasperPrint)jasperPrint);
            ToolFile.writeBytesOnFile((File)file, (byte[])array);
        }
        catch (ExceptionIO | JRException e) {
            e.printStackTrace();
            TLogger.get(PrintReport.class).error(e.getClass(), e);
            throw new ExceptionJasperReports(e.getMessage(), e);
        }
    }

    public void printOnParamTermicaPrinter(JasperPrint print) throws ExceptionJasperReports {
        PrintService printer = null;
        if (StaticObjects.getDadosConfiguracaoLocal() != null && ToolMethods.isStrWithData((String)StaticObjects.getDadosConfiguracaoLocal().getNomeImpressoraTermica())) {
            printer = ToolSystem.getPrinter((String)StaticObjects.getDadosConfiguracaoLocal().getNomeImpressoraTermica());
        }
        if (printer == null) {
            printer = ToolSystem.getDefaultPrinter();
        }
        this.printOnSelectedPrinter(print, printer);
    }

    public void printOnParamLaserPrinter(JasperPrint print) throws ExceptionJasperReports {
        PrintService printer = null;
        if (StaticObjects.getDadosConfiguracaoLocal() != null && ToolMethods.isStrWithData((String)StaticObjects.getDadosConfiguracaoLocal().getNomeImpressoraLaser())) {
            printer = ToolSystem.getPrinter((String)StaticObjects.getDadosConfiguracaoLocal().getNomeImpressoraLaser());
        }
        if (printer == null) {
            printer = ToolSystem.getDefaultPrinter();
        }
        this.printOnSelectedPrinter(print, printer);
    }

    public void printOnParamLaserPrinter(PDDocument documento) throws ExceptionJasperReports, PrinterException, IOException {
        PrintService printer = null;
        if (StaticObjects.getDadosConfiguracaoLocal() != null && ToolMethods.isStrWithData((String)StaticObjects.getDadosConfiguracaoLocal().getNomeImpressoraLaser())) {
            printer = ToolSystem.getPrinter((String)StaticObjects.getDadosConfiguracaoLocal().getNomeImpressoraLaser());
        }
        if (printer == null) {
            printer = ToolSystem.getDefaultPrinter();
        }
        PrinterJob job = PrinterJob.getPrinterJob();
        job.setPageable((Pageable)new PDFPageable(documento));
        job.setPrintService(printer);
        job.print();
        documento.close();
    }

    public void printOnDefaultPrinter(JasperPrint print) throws ExceptionJasperReports {
        try {
            JasperPrintManager.printReport((JasperPrint)print, (boolean)false);
        }
        catch (JRException e) {
            e.printStackTrace();
            TLogger.get(PrintReport.class).error(((Object)((Object)e)).getClass(), (Throwable)e);
            throw new ExceptionJasperReports(e.getMessage(), (Throwable)e);
        }
    }

    public void printOnSelectedPrinter(JasperPrint print, PrintService impressora) throws ExceptionJasperReports {
        try {
            HashPrintServiceAttributeSet printServiceAttributeSet = new HashPrintServiceAttributeSet();
            printServiceAttributeSet.add(new PrinterName(impressora.getName(), null));
            JRPrintServiceExporter exporter = new JRPrintServiceExporter();
            exporter.setExporterInput((ExporterInput)new SimpleExporterInput(print));
            SimplePrintServiceExporterConfiguration configuration = new SimplePrintServiceExporterConfiguration();
            configuration.setPrintServiceAttributeSet((PrintServiceAttributeSet)printServiceAttributeSet);
            configuration.setDisplayPageDialog(Boolean.valueOf(false));
            configuration.setDisplayPrintDialog(Boolean.valueOf(false));
            exporter.setConfiguration((ExporterConfiguration)configuration);
            exporter.exportReport();
        }
        catch (JRException e) {
            e.printStackTrace();
            TLogger.get(PrintReport.class).error(((Object)((Object)e)).getClass(), (Throwable)e);
            throw new ExceptionJasperReports(e.getMessage(), (Throwable)e);
        }
    }

    public Map<String, Object> getParams() {
        return this.params;
    }

    public abstract String getPath();
}

