/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.touchnfce.print.impl;

import com.touchcomp.basementor.constants.enums.EnumConstAbertoFechado;
import com.touchcomp.basementor.constants.enums.nfce.EnumConstNFCeFonteImpressao;
import com.touchcomp.basementorexceptions.exceptions.impl.jasperreports.ExceptionJasperReports;
import com.touchcomp.basementorexceptions.exceptions.impl.print.ExceptionPrint;
import com.touchcomp.basementortools.tools.date.ToolDate;
import com.touchcomp.basementortools.tools.methods.ToolMethods;
import com.touchcomp.touchnfce.StaticObjects;
import com.touchcomp.touchnfce.controller.Alerts;
import com.touchcomp.touchnfce.controller.caixa.AberturaCaixaController;
import com.touchcomp.touchnfce.model.NFCeControleCaixa;
import com.touchcomp.touchnfce.model.NFCeEncerranteAbastecimento;
import com.touchcomp.touchnfce.modeltemp.AberturaCaixa;
import com.touchcomp.touchnfce.print.PrintReport;
import com.touchcomp.touchnfce.utils.abastecimentocompanytec.UtilCentralAbastecimento;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.sf.jasperreports.engine.JasperPrint;
import org.jetbrains.annotations.NotNull;

public class PrintAberturaCaixa
extends PrintReport {
    public void imprimeComprovante(NFCeControleCaixa abertCaixa) {
        try {
            AberturaCaixa abert = new AberturaCaixa();
            abert.setDataAbertura(abertCaixa.getDataAbertura());
            abert.setEmpresa(abertCaixa.getNFCeCaixa().getEmpresa());
            abert.setUsuario(abertCaixa.getUsuario());
            abert.setCaixa(abertCaixa.getNFCeCaixa().getDescricao());
            if (abertCaixa.getNFCeMovCaixaAbertura() != null) {
                abert.setSuprimento(abertCaixa.getNFCeMovCaixaAbertura().getValor());
            }
            if (ToolMethods.isEquals((Object)StaticObjects.getEmpresa().getEmpresaDados().getTipoEmpresa().getCodigo().shortValue(), (Object)6)) {
                abert.setEncerrantes(this.getEncerrantesAberturaCaixa(abertCaixa));
            }
            new PrintAberturaCaixa().printResumoCompleto(abert);
        }
        catch (ExceptionJasperReports | ExceptionPrint ex) {
            Logger.getLogger(AberturaCaixaController.class.getName()).log(Level.SEVERE, null, ex);
            Alerts.showAlertError(ex.getMessage());
        }
    }

    private List<AberturaCaixa.AberturaCaixaEncerrantes> getEncerrantesAberturaCaixa(NFCeControleCaixa abertCaixa) {
        ArrayList<AberturaCaixa.AberturaCaixaEncerrantes> aux = new ArrayList<AberturaCaixa.AberturaCaixaEncerrantes>();
        List<NFCeEncerranteAbastecimento> encerrantes = UtilCentralAbastecimento.get().getEncerranteAbastecimentoByControleCaixa(abertCaixa, EnumConstAbertoFechado.ABERTO.value);
        if (encerrantes != null && !encerrantes.isEmpty()) {
            for (NFCeEncerranteAbastecimento e : encerrantes) {
                aux.add(new AberturaCaixa.AberturaCaixaEncerrantes(e.getBico().getDescricao(), e.getQuantidade()));
            }
        }
        return aux;
    }

    public void printResumoCompleto(@NotNull AberturaCaixa abert) throws ExceptionJasperReports, ExceptionPrint {
        LinkedList data = new LinkedList();
        this.getParams().put("DATA_ABERTURA", ToolDate.dateToStr((Date)abert.getDataAbertura(), (String)"dd/MM/yyyy hh:mm"));
        this.getParams().put("USUARIO", abert.getUsuario().getPessoa().getNome());
        this.getParams().put("VALOR_SUPRIMENTO", abert.getSuprimento());
        this.getParams().put("CNPJ", abert.getEmpresa().getPessoa().getComplemento().getCnpj());
        this.getParams().put("NOME", abert.getEmpresa().getPessoa().getNomeFantasia());
        this.getParams().put("LOGRADOURO", abert.getEmpresa().getPessoa().getEndereco().getLogradouro());
        this.getParams().put("NUMERO", abert.getEmpresa().getPessoa().getEndereco().getNumero());
        this.getParams().put("BAIRRO", abert.getEmpresa().getPessoa().getEndereco().getBairro());
        this.getParams().put("CIDADE", abert.getEmpresa().getPessoa().getEndereco().getCidade().getDescricao());
        this.getParams().put("UF", abert.getEmpresa().getPessoa().getEndereco().getCidade().getUf().getSigla());
        this.getParams().put("CEP", abert.getEmpresa().getPessoa().getEndereco().getCep());
        this.getParams().put("CAIXA", abert.getCaixa());
        if (ToolMethods.isEquals((Object)StaticObjects.getNFCeCaixa().getFonteImpressao(), (Object)EnumConstNFCeFonteImpressao.ABEL.getValue())) {
            this.getParams().put("TIPO_FONTE", EnumConstNFCeFonteImpressao.ABEL.getValue());
        } else if (ToolMethods.isEquals((Object)StaticObjects.getNFCeCaixa().getFonteImpressao(), (Object)EnumConstNFCeFonteImpressao.BARLOW.getValue())) {
            this.getParams().put("TIPO_FONTE", EnumConstNFCeFonteImpressao.BARLOW.getValue());
        } else if (ToolMethods.isEquals((Object)StaticObjects.getNFCeCaixa().getFonteImpressao(), (Object)EnumConstNFCeFonteImpressao.BARLOW_CONDENSED.getValue())) {
            this.getParams().put("TIPO_FONTE", EnumConstNFCeFonteImpressao.BARLOW_CONDENSED.getValue());
        } else {
            this.getParams().put("TIPO_FONTE", EnumConstNFCeFonteImpressao.SANS_SERIF_PADRAO.getValue());
        }
        for (AberturaCaixa.AberturaCaixaEncerrantes e : abert.getEncerrantes()) {
            HashMap<String, Object> h = new HashMap<String, Object>();
            h.put("BICO", e.getBico());
            h.put("ENCERRANTE_INICIAL", e.getEncerranteInicial());
            data.add(h);
        }
        JasperPrint jasperPrint = this.generateReportListDataSource(data);
        this.printOnParamTermicaPrinter(jasperPrint);
    }

    @Override
    public String getPath() {
        return "reports/caixa/aberturacaixa/COMPROVANTE_ABERT_CAIXA.jasper";
    }
}

