/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.touchnfce.print.impl;

import com.touchcomp.basementor.constants.enums.EnumConstantsModeloDocFiscal;
import com.touchcomp.basementor.constants.enums.nfce.EnumConstNFCeFonteImpressao;
import com.touchcomp.basementor.constants.enums.nfe.EnumConstNFeStatus;
import com.touchcomp.basementorexceptions.exceptions.impl.jasperreports.ExceptionJasperReports;
import com.touchcomp.basementorexceptions.exceptions.impl.print.ExceptionPrint;
import com.touchcomp.basementortools.tools.date.ToolDate;
import com.touchcomp.basementortools.tools.methods.ToolMethods;
import com.touchcomp.touchnfce.Main;
import com.touchcomp.touchnfce.StaticObjects;
import com.touchcomp.touchnfce.model.NFCe;
import com.touchcomp.touchnfce.model.NFCeControleCaixa;
import com.touchcomp.touchnfce.print.PrintReport;
import com.touchcomp.touchnfce.service.impl.ServiceNFCe;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import net.sf.jasperreports.engine.JasperPrint;
import org.jetbrains.annotations.NotNull;

public class PrintFechamentoCaixaRes
extends PrintReport {
    public void printResumoCompleto(@NotNull NFCeControleCaixa cont) throws ExceptionJasperReports, ExceptionPrint {
        this.getParams().put("DATA_ABERTURA", ToolDate.dateToStr((Date)cont.getDataAbertura(), (String)"dd/MM/yyyy hh:mm"));
        this.getParams().put("DATA_FECHAMENTO", ToolDate.dateToStr((Date)cont.getDataFechamento(), (String)"dd/MM/yyyy hh:mm"));
        this.getParams().put("USUARIO", cont.getUsuario().getPessoa().getNome());
        this.getParams().put("VALOR_TOT_SISTEMA", cont.getValorTotalSistema());
        this.getParams().put("VALOR_TOT_INF", cont.getValorTotalInformadoDinh());
        this.getParams().put("VALOR_REMANESC_CAIXA", cont.getValorRemanescenteCaixaDinh());
        this.getParams().put("VALOR_REMANESC_INF_CAIXA", cont.getValorRemanescenteCaixaDinh());
        this.getParams().put("VALOR_REMANESC_CAIXA_ANT", cont.getValorRemanescenteCaixaAnterior());
        this.getParams().put("VALOR_TOT_ENTRADAS", cont.getValorTotalEntradasMov());
        this.getParams().put("VALOR_TOT_SAIDAS", cont.getValorTotalSaidasMov());
        this.getParams().put("CNPJ", cont.getNFCeCaixa().getEmpresa().getPessoa().getComplemento().getCnpj());
        this.getParams().put("NOME", cont.getNFCeCaixa().getEmpresa().getPessoa().getNomeFantasia());
        this.getParams().put("LOGRADOURO", cont.getNFCeCaixa().getEmpresa().getPessoa().getEndereco().getLogradouro());
        this.getParams().put("NUMERO", cont.getNFCeCaixa().getEmpresa().getPessoa().getEndereco().getNumero());
        this.getParams().put("BAIRRO", cont.getNFCeCaixa().getEmpresa().getPessoa().getEndereco().getBairro());
        this.getParams().put("CIDADE", cont.getNFCeCaixa().getEmpresa().getPessoa().getEndereco().getCidade().getDescricao());
        this.getParams().put("UF", cont.getNFCeCaixa().getEmpresa().getPessoa().getEndereco().getCidade().getUf().getSigla());
        this.getParams().put("CEP", cont.getNFCeCaixa().getEmpresa().getPessoa().getEndereco().getCep());
        this.getParams().put("CAIXA", cont.getNFCeCaixa().getDescricao());
        if (ToolMethods.isEquals((Object)StaticObjects.getNFCeCaixa().getFonteImpressao(), (Object)EnumConstNFCeFonteImpressao.ABEL.getValue())) {
            this.getParams().put("TIPO_FONTE", EnumConstNFCeFonteImpressao.ABEL.getValue());
        } else if (ToolMethods.isEquals((Object)StaticObjects.getNFCeCaixa().getFonteImpressao(), (Object)EnumConstNFCeFonteImpressao.BARLOW.getValue())) {
            this.getParams().put("TIPO_FONTE", EnumConstNFCeFonteImpressao.BARLOW.getValue());
        } else if (ToolMethods.isEquals((Object)StaticObjects.getNFCeCaixa().getFonteImpressao(), (Object)EnumConstNFCeFonteImpressao.BARLOW_CONDENSED.getValue())) {
            this.getParams().put("TIPO_FONTE", EnumConstNFCeFonteImpressao.BARLOW_CONDENSED.getValue());
        } else {
            this.getParams().put("TIPO_FONTE", EnumConstNFCeFonteImpressao.SANS_SERIF_PADRAO.getValue());
        }
        LinkedList<NFCeControleCaixa> data = new LinkedList<NFCeControleCaixa>();
        data.add(cont);
        this.analisarNotasEmitidas(cont);
        JasperPrint jasperPrint = this.generateReportListDataSource(data);
        this.printOnParamTermicaPrinter(jasperPrint);
    }

    private void analisarNotasEmitidas(NFCeControleCaixa nfceControleCaixa) {
        Integer nfeInicial = 0;
        Integer nfeFinal = 0;
        Integer nfeCancelamento = 0;
        Integer nfeInutilizacao = 0;
        Integer nfeInconsistencia = 0;
        Integer nfceInicial = 0;
        Integer nfceFinal = 0;
        Integer nfceCancelamento = 0;
        Integer nfceInutilizacao = 0;
        Integer nfceInconsistencia = 0;
        ServiceNFCe serviceNFCe = Main.getBean(ServiceNFCe.class);
        List<NFCe> listNfce = serviceNFCe.getNotas(nfceControleCaixa);
        for (NFCe n : listNfce) {
            Integer n2;
            if (ToolMethods.isEquals((Object)n.getModeloDocFiscal().getCodigo(), (Object)EnumConstantsModeloDocFiscal.NFE_55.getCodigo())) {
                if (ToolMethods.isEquals((Object)nfeInicial, (Object)0)) {
                    nfeInicial = n.getNumero().intValue();
                }
                nfeFinal = n.getNumero().intValue();
                if (ToolMethods.isEquals((Object)n.getStatus(), (Object)EnumConstNFeStatus.AUTORIZADA.getValue())) continue;
                if (ToolMethods.isEquals((Object)n.getStatus(), (Object)EnumConstNFeStatus.CANCELADA.getValue())) {
                    n2 = nfeCancelamento;
                    nfeCancelamento = nfeCancelamento + 1;
                    continue;
                }
                if (ToolMethods.isEquals((Object)n.getStatus(), (Object)EnumConstNFeStatus.INUTILIZADA.getValue())) {
                    n2 = nfeInutilizacao;
                    nfeInutilizacao = nfeInutilizacao + 1;
                    continue;
                }
                n2 = nfeInconsistencia;
                nfeInconsistencia = nfeInconsistencia + 1;
                continue;
            }
            if (ToolMethods.isEquals((Object)nfceInicial, (Object)0)) {
                nfceInicial = n.getNumero().intValue();
            }
            nfceFinal = n.getNumero().intValue();
            if (ToolMethods.isEquals((Object)n.getStatus(), (Object)EnumConstNFeStatus.AUTORIZADA.getValue())) continue;
            if (ToolMethods.isEquals((Object)n.getStatus(), (Object)EnumConstNFeStatus.CANCELADA.getValue())) {
                n2 = nfceCancelamento;
                nfceCancelamento = nfceCancelamento + 1;
                continue;
            }
            if (ToolMethods.isEquals((Object)n.getStatus(), (Object)EnumConstNFeStatus.INUTILIZADA.getValue())) {
                n2 = nfceInutilizacao;
                nfceInutilizacao = nfceInutilizacao + 1;
                continue;
            }
            n2 = nfceInconsistencia;
            nfceInconsistencia = nfceInconsistencia + 1;
        }
        this.getParams().put("NFE_INICIAL", nfeInicial);
        this.getParams().put("NFE_FINAL", nfeFinal);
        this.getParams().put("NFE_CANCELAMENTO", nfeCancelamento);
        this.getParams().put("NFE_INUTILIZACAO", nfeInutilizacao);
        this.getParams().put("NFE_INCONSISTENCIA", nfeInconsistencia);
        this.getParams().put("NFCE_INICIAL", nfceInicial);
        this.getParams().put("NFCE_FINAL", nfceFinal);
        this.getParams().put("NFCE_CANCELAMENTO", nfceCancelamento);
        this.getParams().put("NFCE_INUTILIZACAO", nfceInutilizacao);
        this.getParams().put("NFCE_INCONSISTENCIA", nfceInconsistencia);
    }

    @Override
    public String getPath() {
        return "reports/caixa/fechamentocaixa/resumo/DADOS_FEC_CAIXA_RESUMO.jasper";
    }
}

