/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.touchnfce.properties;

import com.touchcomp.basementorlogger.TLogger;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;

public class PropertiesLoader {
    private Properties props;
    private String FILE_NAME = "properties.properties";
    private static PropertiesLoader instance;
    private static TLogger logger;
    private String COR_BACKGROUND_1 = "cor.background.1";
    private String COR_BACKGROUND_2 = "cor.background.2";
    private String COR_BACKGROUND_3 = "cor.background.3";
    private String COR_BACKGROUND_4 = "cor.background.4";
    private String COR_BACKGROUND_5 = "cor.background.5";
    private String COR_RADIUS_BUTTON_1 = "cor.radius.button.1";
    private String COR_RADIUS_BUTTON_2 = "cor.radius.button.2";
    private String COR_TABELA_HEADER = "cor.tabela.header";
    private String COR_TEXTO_TABELA_HEADER = "cor.texto.tabela.header";
    private String COR_TABELA_BODY = "cor.tabela.body";
    private String COR_BORDA_BUTTON = "cor.borda.button";
    private String COR_TEXTO_BUTTON = "cor.texto.button";
    private String COR_TEXTO = "cor.texto";
    private String FULL_SCREEN = "fullScreen";

    private PropertiesLoader() {
        try {
            this.props = new Properties();
            File f = new File(this.FILE_NAME);
            if (!f.exists()) {
                FileOutputStream fout = new FileOutputStream(f);
                fout.flush();
                fout.close();
            }
            FileInputStream in = new FileInputStream(f);
            this.props.load(in);
            ((InputStream)in).close();
        }
        catch (IOException ex) {
            logger.error(ex.getClass(), (Throwable)ex);
            throw new RuntimeException(ex.getMessage(), ex);
        }
    }

    public static synchronized PropertiesLoader get() {
        if (instance == null) {
            instance = new PropertiesLoader();
        }
        return instance;
    }

    public void adicionaProperties(String chave, String valor) {
        try {
            FileOutputStream out = new FileOutputStream(this.FILE_NAME);
            this.props.setProperty(chave, valor);
            this.props.store(out, null);
            out.close();
        }
        catch (IOException ex) {
            logger.error(ex.getClass(), (Throwable)ex);
            throw new RuntimeException(ex.getMessage(), ex);
        }
    }

    public String getCorBackground_1() {
        if (this.props.getProperty(this.COR_BACKGROUND_1) == null || this.props.getProperty(this.COR_BACKGROUND_1).equals("")) {
            this.adicionaProperties(this.COR_BACKGROUND_1, "#0e5d8c");
        }
        return this.props.getProperty(this.COR_BACKGROUND_1);
    }

    public String getCorBackground_2() {
        if (this.props.getProperty(this.COR_BACKGROUND_2) == null || this.props.getProperty(this.COR_BACKGROUND_2).equals("")) {
            this.adicionaProperties(this.COR_BACKGROUND_2, "#00759f");
        }
        return this.props.getProperty(this.COR_BACKGROUND_2);
    }

    public String getCorBackground_3() {
        if (this.props.getProperty(this.COR_BACKGROUND_3) == null || this.props.getProperty(this.COR_BACKGROUND_3).equals("")) {
            this.adicionaProperties(this.COR_BACKGROUND_3, "#008daf");
        }
        return this.props.getProperty(this.COR_BACKGROUND_3);
    }

    public String getCorBackground_4() {
        if (this.props.getProperty(this.COR_BACKGROUND_4) == null || this.props.getProperty(this.COR_BACKGROUND_4).equals("")) {
            this.adicionaProperties(this.COR_BACKGROUND_4, "#22a6bc");
        }
        return this.props.getProperty(this.COR_BACKGROUND_4);
    }

    public String getCorBackground_5() {
        if (this.props.getProperty(this.COR_BACKGROUND_5) == null || this.props.getProperty(this.COR_BACKGROUND_5).equals("")) {
            this.adicionaProperties(this.COR_BACKGROUND_5, "#44bec6");
        }
        return this.props.getProperty(this.COR_BACKGROUND_5);
    }

    public String getCorRadiusButton1() {
        if (this.props.getProperty(this.COR_RADIUS_BUTTON_1) == null || this.props.getProperty(this.COR_RADIUS_BUTTON_1).equals("")) {
            this.adicionaProperties(this.COR_RADIUS_BUTTON_1, "#3DBDDF");
        }
        return this.props.getProperty(this.COR_RADIUS_BUTTON_1);
    }

    public String getCorRadiusButton2() {
        if (this.props.getProperty(this.COR_RADIUS_BUTTON_2) == null || this.props.getProperty(this.COR_RADIUS_BUTTON_2).equals("")) {
            this.adicionaProperties(this.COR_RADIUS_BUTTON_2, "#1296BC");
        }
        return this.props.getProperty(this.COR_RADIUS_BUTTON_2);
    }

    public String getCorTabelaHeader() {
        if (this.props.getProperty(this.COR_TABELA_HEADER) == null || this.props.getProperty(this.COR_TABELA_HEADER).equals("")) {
            this.adicionaProperties(this.COR_TABELA_HEADER, "#3DBDDF");
        }
        return this.props.getProperty(this.COR_TABELA_HEADER);
    }

    public String getCorTabelaBody() {
        if (this.props.getProperty(this.COR_TABELA_BODY) == null || this.props.getProperty(this.COR_TABELA_BODY).equals("")) {
            this.adicionaProperties(this.COR_TABELA_BODY, "#FFFFFF");
        }
        return this.props.getProperty(this.COR_TABELA_BODY);
    }

    public String getCorBordaButton() {
        if (this.props.getProperty(this.COR_BORDA_BUTTON) == null || this.props.getProperty(this.COR_BORDA_BUTTON).equals("")) {
            this.adicionaProperties(this.COR_BORDA_BUTTON, "#FFFFFF");
        }
        return this.props.getProperty(this.COR_BORDA_BUTTON);
    }

    public String getCorTextoButton() {
        if (this.props.getProperty(this.COR_TEXTO_BUTTON) == null || this.props.getProperty(this.COR_TEXTO_BUTTON).equals("")) {
            this.adicionaProperties(this.COR_TEXTO_BUTTON, "#FFFFFF");
        }
        return this.props.getProperty(this.COR_TEXTO_BUTTON);
    }

    public String getCorTexto() {
        if (this.props.getProperty(this.COR_TEXTO) == null || this.props.getProperty(this.COR_TEXTO).equals("")) {
            this.adicionaProperties(this.COR_TEXTO, "#FFFFFF");
        }
        return this.props.getProperty(this.COR_TEXTO);
    }

    public String getCorTextoTabelaHeader() {
        if (this.props.getProperty(this.COR_TEXTO_TABELA_HEADER) == null || this.props.getProperty(this.COR_TEXTO_TABELA_HEADER).equals("")) {
            this.adicionaProperties(this.COR_TEXTO_TABELA_HEADER, "#FFFFFF");
        }
        return this.props.getProperty(this.COR_TEXTO_TABELA_HEADER);
    }

    public boolean getFullScreen() {
        if (this.props.getProperty(this.FULL_SCREEN) == null || this.props.getProperty(this.FULL_SCREEN).equals("")) {
            this.adicionaProperties(this.FULL_SCREEN, "#FFFFFF");
        }
        return Boolean.valueOf(this.props.getProperty(this.FULL_SCREEN));
    }

    static {
        logger = TLogger.get(PropertiesLoader.class);
    }
}

