/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.touchnfce.repo.impl.representante;

import com.touchcomp.basementor.constants.enums.EnumConstantsMentorSimNao;
import com.touchcomp.touchnfce.model.Empresa;
import com.touchcomp.touchnfce.model.Representante;
import com.touchcomp.touchnfce.repo.impl.representante.RepoCustomRepresentante;
import java.util.List;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import javax.persistence.Query;

public class RepoCustomRepresentanteImpl
implements RepoCustomRepresentante {
    @PersistenceContext
    private EntityManager em;

    @Override
    public Representante getRepresentanteByPessoa(Long idPessoa) {
        String q = "select distinct rep from " + Representante.class.getCanonicalName() + " rep inner join rep.pessoa pes where pes.identificador=:identificador and rep.ativo=:sim and pes.ativo=:sim";
        Query query = this.em.createQuery(q);
        query.setParameter("identificador", (Object)idPessoa);
        query.setParameter("sim", (Object)EnumConstantsMentorSimNao.SIM.getValue());
        return (Representante)query.getSingleResult();
    }

    @Override
    public List<Representante> getRepresentantesAtivos(Empresa empresa) {
        String q = "select distinct rep from " + Representante.class.getCanonicalName() + " rep inner join rep.pessoa pes inner join rep.representanteEmpresa re where pes.identificador=:identificador and rep.ativo=:sim and pes.ativo=:sim and re.ativo=:sim and re.empresa=:empresa order by pes.nome";
        Query query = this.em.createQuery(q);
        query.setParameter("empresa", (Object)empresa);
        query.setParameter("sim", (Object)EnumConstantsMentorSimNao.SIM.getValue());
        return query.getResultList();
    }

    @Override
    public List<Representante> getRepresentantesAtivos(String search, Empresa empresa) {
        String q = "select distinct rep from " + Representante.class.getCanonicalName() + " rep inner join rep.pessoa pes inner join rep.representanteEmpresa re inner join re.empresa emp where rep.ativo=:sim and pes.ativo=:sim and re.ativo=:sim and emp.identificador=:empresa and (lower(pes.nome) LIKE lower('%" + search + "%') or lower(pes.nomeFantasia) LIKE lower('%" + search + "%')) order by pes.nome";
        Query query = this.em.createQuery(q);
        query.setParameter("empresa", (Object)empresa.getIdentificador());
        query.setParameter("sim", (Object)EnumConstantsMentorSimNao.SIM.getValue());
        return query.getResultList();
    }
}

