/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.touchnfce.service.impl;

import com.touchcomp.touchnfce.controller.venda.auxmodelofiscal.AuxModeloFiscal;
import com.touchcomp.touchnfce.model.CategoriaPessoa;
import com.touchcomp.touchnfce.model.Empresa;
import com.touchcomp.touchnfce.model.ModeloDocFiscal;
import com.touchcomp.touchnfce.model.ModeloFiscal;
import com.touchcomp.touchnfce.model.NaturezaOperacao;
import com.touchcomp.touchnfce.model.Produto;
import com.touchcomp.touchnfce.model.UnidadeFederativa;
import com.touchcomp.touchnfce.repo.RepoBaseJPA;
import com.touchcomp.touchnfce.repo.impl.modelofiscal.RepoModeloFiscal;
import com.touchcomp.touchnfce.service.ServiceEntityAPI;
import java.util.List;
import org.springframework.stereotype.Service;

@Service
public class ServiceModeloFiscal
extends ServiceEntityAPI<ModeloFiscal, Long> {
    public ServiceModeloFiscal(RepoBaseJPA<ModeloFiscal, Long> repository) {
        super(repository);
    }

    @Override
    public RepoModeloFiscal getRepository() {
        return (RepoModeloFiscal)super.getRepository();
    }

    public ModeloFiscal getFirst(Produto produto, CategoriaPessoa categoriaPessoa, UnidadeFederativa uf, NaturezaOperacao naturezaOperacao, String cnpj, Short contribuinteEstado, Short habilitadoSuframa, Empresa empresa) {
        if (produto == null || naturezaOperacao == null || empresa == null) {
            return null;
        }
        Short tipoInscFederal = new AuxModeloFiscal().buildTipoInscFederal(cnpj);
        Short tipoInscEstadual = new AuxModeloFiscal().buildTipoInscEstadual(contribuinteEstado);
        return this.getRepository().getFirst(produto, categoriaPessoa, uf, naturezaOperacao, tipoInscFederal, tipoInscEstadual, habilitadoSuframa, empresa);
    }

    public List<ModeloFiscal> get(Produto produto, CategoriaPessoa categoriaPessoa, UnidadeFederativa uf, NaturezaOperacao naturezaOperacao, String cnpj, Short contribuinteEstado, Short habilitadoSuframa, Empresa empresa) {
        if (produto == null || naturezaOperacao == null || empresa == null) {
            return null;
        }
        Short tipoInscFederal = new AuxModeloFiscal().buildTipoInscFederal(cnpj);
        Short tipoInscEstadual = new AuxModeloFiscal().buildTipoInscEstadual(contribuinteEstado);
        return this.getRepository().get(produto, categoriaPessoa, uf, naturezaOperacao, tipoInscFederal, tipoInscEstadual, habilitadoSuframa, empresa);
    }

    public List<ModeloFiscal> get(Produto produto, UnidadeFederativa uf, NaturezaOperacao naturezaOperacao, Empresa empresa) {
        if (produto == null || naturezaOperacao == null || empresa == null) {
            return null;
        }
        return this.getRepository().get(produto, uf, naturezaOperacao, empresa);
    }

    public ModeloFiscal getFirst(Produto produto, NaturezaOperacao naturezaOperacao, Empresa empresa, CategoriaPessoa categoriaPessoa, Short usarPesqCategoria, Short usarPesqNcm, Short usarPesqProduto) {
        if (produto == null || naturezaOperacao == null || empresa == null) {
            return null;
        }
        return this.getRepository().getFirst(produto, naturezaOperacao, empresa, categoriaPessoa, usarPesqCategoria, usarPesqNcm, usarPesqProduto);
    }

    public List<ModeloFiscal> getModelosSaida(ModeloDocFiscal modelo) {
        return this.getRepository().getModelosSaida(modelo, (short)1);
    }
}

