/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.touchnfce.service.impl;

import com.touchcomp.basementor.constants.enums.EnumConstantsModeloDocFiscal;
import com.touchcomp.basementorexceptions.exceptions.impl.erroprogramacao.ExceptionErroProgramacao;
import com.touchcomp.basementortools.tools.date.ToolDate;
import com.touchcomp.basementortools.tools.methods.ToolMethods;
import com.touchcomp.basementortools.tools.string.ToolString;
import com.touchcomp.touchnfce.model.Empresa;
import com.touchcomp.touchnfce.model.ModeloDocFiscal;
import com.touchcomp.touchnfce.model.NFCe;
import com.touchcomp.touchnfce.model.NFCeCaixa;
import com.touchcomp.touchnfce.model.NFCeControleCaixa;
import com.touchcomp.touchnfce.repo.impl.nfce.RepoNFCe;
import com.touchcomp.touchnfce.service.ServiceSincEntityAPI;
import com.touchcomp.touchvomodel.webservices.PackObjectsSinc;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;

@Service
public class ServiceNFCe
extends ServiceSincEntityAPI<NFCe, Long> {
    public ServiceNFCe(RepoNFCe repository) {
        super(repository);
    }

    public List getResumoPagamentosCaixa(NFCeControleCaixa nfCeControleCaixa) {
        return this.getRepository().getResumoPagamentosCaixa(nfCeControleCaixa);
    }

    @Override
    public RepoNFCe getRepository() {
        return (RepoNFCe)super.getRepository();
    }

    @Override
    public Long getCountForSinc(Date dataUltSinc) {
        return this.getRepository().getCountForSinc(dataUltSinc, EnumConstantsModeloDocFiscal.NFCE_65.getCodigo());
    }

    @Override
    public void saveSinc(List<NFCe> data, List<PackObjectsSinc> res) {
        for (PackObjectsSinc p : res) {
            this.getRepository().updateSinc(p.getIdObjectMentor(), p.getStatus(), p.getSerialObjetoOrigem());
        }
    }

    @Override
    public NFCe save(NFCe entity) {
        this.atualizarDataModificacao(entity);
        return super.save(entity);
    }

    @Override
    public NFCe saveOrUdate(NFCe entity) {
        this.atualizarDataModificacao(entity);
        return super.saveOrUdate(entity);
    }

    @Override
    public NFCe merge(NFCe entity) {
        this.atualizarDataModificacao(entity);
        return super.merge(entity);
    }

    @Override
    public Iterable<NFCe> saveAll(Iterable<NFCe> entity) {
        this.atualizarDataModificacao(entity);
        return super.saveAll(entity);
    }

    @Override
    public List<NFCe> merge(List<NFCe> entities) {
        this.atualizarDataModificacao(entities);
        return super.merge(entities);
    }

    private void atualizarDataModificacao(Iterable<NFCe> entity) {
        entity.forEach(i -> this.atualizarDataModificacao((NFCe)i));
    }

    private void atualizarDataModificacao(NFCe entity) {
        entity.setDataUltModificacao(new Date());
    }

    @Override
    public List<NFCe> getAllForSincZip(Date lastSinc, int atualPage, int regPerTime) {
        List<NFCe> toSend = this.getRepository().getForSinc(lastSinc, (Pageable)PageRequest.of((int)atualPage, (int)regPerTime), EnumConstantsModeloDocFiscal.NFCE_65.getCodigo());
        return toSend;
    }

    public NFCe getNFCeAberta(NFCeCaixa nfCeCaixa) {
        return this.getRepository().getUltimaNFCeAbertaSemEnvio(nfCeCaixa);
    }

    public Long getProximoNumero(NFCeCaixa nfCeCaixa, ModeloDocFiscal modeloDocFiscal) {
        if (nfCeCaixa == null) {
            throw new ExceptionErroProgramacao("Primeiro informe o Caixa!");
        }
        if (modeloDocFiscal == null) {
            throw new ExceptionErroProgramacao("Primeiro informe o Modelo de Documento Fiscal!");
        }
        Long ret = this.getRepository().getProximoNumero(nfCeCaixa, modeloDocFiscal);
        if ((ret == null || ret == 0L) && ToolMethods.isEquals((Object)modeloDocFiscal.getCodigo(), (Object)EnumConstantsModeloDocFiscal.NFCE_65.getCodigo())) {
            ret = nfCeCaixa.getNumeroInicialNFCe();
        } else if ((ret == null || ret == 0L) && ToolMethods.isEquals((Object)modeloDocFiscal.getCodigo(), (Object)EnumConstantsModeloDocFiscal.NFE_55.getCodigo())) {
            ret = nfCeCaixa.getNumeroInicialNFe();
        }
        return ret + 1L;
    }

    public List<NFCe> getNotasProblemaEnvio(NFCeCaixa nfCeCaixa) {
        return this.getRepository().getNotasComInconsistencias(nfCeCaixa);
    }

    public List<NFCe> getNotasPesquisa(String aux, Empresa e, NFCeCaixa nfCeCaixa) {
        LinkedList<NFCe> notas = new LinkedList<NFCe>();
        if (!aux.isEmpty()) {
            if (ToolString.isAIntegerNumber((String)aux)) {
                notas.addAll(this.getRepository().getNotasByStatus(aux, e, nfCeCaixa));
            } else if (ToolString.isADoubleNumber((String)aux)) {
                notas.addAll(this.getRepository().getNotasByValor(aux, e, nfCeCaixa));
            } else if (ToolString.isADateClassic((String)aux, (String)"dd/MM/yyyy")) {
                if (aux.length() == 10) {
                    Date data = ToolDate.strToDate((String)aux);
                    notas.addAll(this.getRepository().getNotasByDate(data, e, nfCeCaixa));
                }
            } else {
                notas.addAll(this.getRepository().getNotasByMotivo(aux, e, nfCeCaixa));
                notas.addAll(this.getRepository().getNotasByCliente(aux, e, nfCeCaixa));
            }
        }
        return notas;
    }

    public List<NFCe> getNotas(NFCeControleCaixa nfceControleCaixa) {
        return this.getRepository().getNotas(nfceControleCaixa);
    }

    @Override
    public void delete(NFCe entity) {
        super.delete(entity);
    }

    @Override
    public void deleteAll(Iterable<NFCe> entities) {
    }

    @Override
    public void deleteById(Long id) {
    }

    public void updateSincManual(Short status, Short sincronizacaoManual, Long idNFCe) {
        this.getRepository().updateSincManual(status, sincronizacaoManual, idNFCe);
    }
}

