/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.touchnfce.service.impl;

import com.touchcomp.touchnfce.model.Pessoa;
import com.touchcomp.touchnfce.repo.RepoBaseJPA;
import com.touchcomp.touchnfce.repo.impl.pessoa.RepoPessoa;
import com.touchcomp.touchnfce.service.ServiceEntityAPI;
import java.util.LinkedList;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional
public class ServicePessoa
extends ServiceEntityAPI<Pessoa, Long> {
    @Autowired
    private RepoBaseJPA<Pessoa, Long> repo;

    public ServicePessoa(RepoBaseJPA<Pessoa, Long> repository) {
        super(repository);
    }

    @Override
    public RepoPessoa getRepository() {
        return (RepoPessoa)this.repo;
    }

    public Pessoa getPessoa(String cnpj) {
        Pessoa ret = this.getRepository().getPessoaCnpj(cnpj);
        return ret;
    }

    public List<Pessoa> searchPessoa(String aux) {
        if (aux == null || ((String)aux).isEmpty()) {
            return new LinkedList<Pessoa>();
        }
        LinkedList<Pessoa> pessoas = new LinkedList<Pessoa>();
        Pessoa p = this.getRepository().getPessoaCpf((String)aux);
        if (p != null) {
            pessoas.add(p);
        }
        aux = "%" + (String)aux + "%";
        pessoas.addAll(this.getRepository().getPessoaNome((String)aux));
        return pessoas;
    }

    @Override
    public Iterable<Pessoa> saveAll(Iterable<Pessoa> entity) {
        return this.getRepository().saveAll(entity);
    }
}

