/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.touchnfce.sinc;

import com.touchcomp.basementor.constants.enums.EnumConstantsMentorSimNao;
import com.touchcomp.basementortools.tools.methods.ToolMethods;
import com.touchcomp.touchnfce.Main;
import com.touchcomp.touchnfce.model.DadosSincronizacao;
import com.touchcomp.touchnfce.model.ServidorSincronizacao;
import com.touchcomp.touchnfce.service.impl.ServiceServidorSincronizacao;
import java.util.Collections;
import java.util.Comparator;

public class RepoServer {
    private static RepoServer uniqueInstance;
    private ServidorSincronizacao servidor;
    private DadosSincronizacao params;

    public static synchronized RepoServer getInstance() {
        if (uniqueInstance == null) {
            uniqueInstance = new RepoServer();
        }
        return uniqueInstance;
    }

    public ServidorSincronizacao getOtherServer(DadosSincronizacao params) {
        this.orderServers(params);
        if (params != null && params.getServidores() != null) {
            for (ServidorSincronizacao s : params.getServidores()) {
                if (!(ToolMethods.isEquals((Object)this.servidor, (Object)s) || ToolMethods.isAffirmative((Number)s.getPrincipal()) || s.getSequencia() == null || !ToolMethods.isAffirmative((Number)this.servidor.getPrincipal()) && s.getSequencia() < this.servidor.getSequencia())) {
                    this.servidor = s;
                    return this.servidor;
                }
                if (!ToolMethods.isEquals((Object)s, (Object)params.getServidores().get(params.getServidores().size() - 1))) continue;
                this.servidor = params.getServidores().get(0);
                return this.servidor;
            }
        }
        return this.servidor;
    }

    private void orderServers(DadosSincronizacao params) {
        if (params != null && params.getServidores() != null) {
            Collections.sort(params.getServidores(), new Comparator<ServidorSincronizacao>(this){

                @Override
                public int compare(ServidorSincronizacao o1, ServidorSincronizacao o2) {
                    int sComp = o2.getPrincipal().compareTo(o1.getPrincipal());
                    if (sComp != 0) {
                        return sComp;
                    }
                    return o1.getSequencia().compareTo(o2.getSequencia());
                }
            });
        }
    }

    public ServidorSincronizacao getServidor(DadosSincronizacao params) {
        this.params = params;
        if (params == null || params.getServidores() == null) {
            return null;
        }
        if (this.servidor != null) {
            return this.servidor;
        }
        this.servidor = this.getServidorPricipal(params);
        return this.servidor;
    }

    private ServidorSincronizacao getServidorPricipal(DadosSincronizacao vo) {
        if (vo.getServidores() != null) {
            for (ServidorSincronizacao s : vo.getServidores()) {
                if (!ToolMethods.isAffirmative((Number)s.getPrincipal())) continue;
                return s;
            }
        }
        return this.migraServidorNovaEstrutura(vo);
    }

    private ServidorSincronizacao migraServidorNovaEstrutura(DadosSincronizacao vo) {
        ServiceServidorSincronizacao service = Main.getBean(ServiceServidorSincronizacao.class);
        ServidorSincronizacao server = new ServidorSincronizacao();
        server.setIp(vo.getServidor());
        server.setPorta(vo.getPortaServidor());
        server.setPossuiProxy(vo.getPossuiProxy());
        server.setServidorProxy(vo.getServidorProxy());
        server.setPortaServidorProxy(vo.getPortaServidorProxy());
        server.setPossuiAutenticacaoProxy(vo.getPossuiAutenticacaoProxy());
        server.setUsuarioProxy(vo.getUsuarioProxy());
        server.setSenhaProxy(vo.getSenhaProxy());
        server.setPrincipal(EnumConstantsMentorSimNao.SIM.getValue());
        server.setDadosSincronizacao(vo);
        server = service.save(server);
        vo.getServidores().add(server);
        return server;
    }
}

