/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.touchnfce.sinc.receive;

import com.touchcomp.basementorexceptions.exceptions.impl.certificado.ExceptionCertificado;
import com.touchcomp.basementorexceptions.exceptions.impl.decoder.ExceptionDecodeHexString64;
import com.touchcomp.basementorexceptions.exceptions.impl.ioexception.ExceptionIO;
import com.touchcomp.basementorexceptions.exceptions.impl.reflection.ExceptionReflection;
import com.touchcomp.basementorexceptions.exceptions.impl.webservice.ExceptionWebService;
import com.touchcomp.basementorexceptions.exceptions.impl.zip.ExceptionZip;
import com.touchcomp.basementortools.tools.date.TDate;
import com.touchcomp.basementortools.tools.formatter.ToolFormatter;
import com.touchcomp.basementortools.tools.methods.ToolMethods;
import com.touchcomp.touchnfce.Main;
import com.touchcomp.touchnfce.StaticObjects;
import com.touchcomp.touchnfce.model.LogSincronizacao;
import com.touchcomp.touchnfce.service.impl.ServiceLogSincronizacao;
import com.touchcomp.touchnfce.sinc.ToolWebService;
import com.touchcomp.touchnfce.sinc.receive.SincBase;
import com.touchcomp.touchnfce.sinc.receive.SincListener;
import com.touchcomp.touchnfce.sinc.receive.SincParams;
import com.touchcomp.touchnfce.sinc.receive.impl.SincAliquotaPadraoImposto;
import com.touchcomp.touchnfce.sinc.receive.impl.SincAliquotaReferenciaImposto;
import com.touchcomp.touchnfce.sinc.receive.impl.SincAvaliadorExpTabExp;
import com.touchcomp.touchnfce.sinc.receive.impl.SincAvaliadorExpTabExpValor;
import com.touchcomp.touchnfce.sinc.receive.impl.SincAvaliadorExpressoes;
import com.touchcomp.touchnfce.sinc.receive.impl.SincAvaliadorExpressoesFormulas;
import com.touchcomp.touchnfce.sinc.receive.impl.SincAvaliadorExpressoesPreFormulas;
import com.touchcomp.touchnfce.sinc.receive.impl.SincAvaliadorExpressoesVarConst;
import com.touchcomp.touchnfce.sinc.receive.impl.SincBandeiraCartaoNFe;
import com.touchcomp.touchnfce.sinc.receive.impl.SincBandeiraTEF;
import com.touchcomp.touchnfce.sinc.receive.impl.SincBicoBombaCombustivel;
import com.touchcomp.touchnfce.sinc.receive.impl.SincBombaCombustivel;
import com.touchcomp.touchnfce.sinc.receive.impl.SincCarteiraCobranca;
import com.touchcomp.touchnfce.sinc.receive.impl.SincCategoriaCbsIbs;
import com.touchcomp.touchnfce.sinc.receive.impl.SincCategoriaPessoa;
import com.touchcomp.touchnfce.sinc.receive.impl.SincCentroEstoque;
import com.touchcomp.touchnfce.sinc.receive.impl.SincCest;
import com.touchcomp.touchnfce.sinc.receive.impl.SincCfop;
import com.touchcomp.touchnfce.sinc.receive.impl.SincCidade;
import com.touchcomp.touchnfce.sinc.receive.impl.SincClasseEnquadramentoIpi;
import com.touchcomp.touchnfce.sinc.receive.impl.SincClassificacaoClientes;
import com.touchcomp.touchnfce.sinc.receive.impl.SincClassificacaoProduto;
import com.touchcomp.touchnfce.sinc.receive.impl.SincClassificacaoProdutoANP;
import com.touchcomp.touchnfce.sinc.receive.impl.SincClassificacaoTribCbsIbsModDoc;
import com.touchcomp.touchnfce.sinc.receive.impl.SincClassificacaoTributariaCbsIbs;
import com.touchcomp.touchnfce.sinc.receive.impl.SincCliente;
import com.touchcomp.touchnfce.sinc.receive.impl.SincClienteFichaFinanceiraAutorizados;
import com.touchcomp.touchnfce.sinc.receive.impl.SincClienteNFCe;
import com.touchcomp.touchnfce.sinc.receive.impl.SincClienteNFCeMeioPag;
import com.touchcomp.touchnfce.sinc.receive.impl.SincClienteUnidadeFat;
import com.touchcomp.touchnfce.sinc.receive.impl.SincClienteVeiculo;
import com.touchcomp.touchnfce.sinc.receive.impl.SincCnae;
import com.touchcomp.touchnfce.sinc.receive.impl.SincCondicoesPagamento;
import com.touchcomp.touchnfce.sinc.receive.impl.SincConfigValPedidos;
import com.touchcomp.touchnfce.sinc.receive.impl.SincConfigValPedidosItGrupo;
import com.touchcomp.touchnfce.sinc.receive.impl.SincConfigValPedidosItem;
import com.touchcomp.touchnfce.sinc.receive.impl.SincConfiguracaoCertificado;
import com.touchcomp.touchnfce.sinc.receive.impl.SincConfiguracaoCertificadoItem;
import com.touchcomp.touchnfce.sinc.receive.impl.SincCor;
import com.touchcomp.touchnfce.sinc.receive.impl.SincDadosFiscaisUF;
import com.touchcomp.touchnfce.sinc.receive.impl.SincDadosFiscaisUFNCMFCP;
import com.touchcomp.touchnfce.sinc.receive.impl.SincDiaSemana;
import com.touchcomp.touchnfce.sinc.receive.impl.SincEmbalagem;
import com.touchcomp.touchnfce.sinc.receive.impl.SincEmpresa;
import com.touchcomp.touchnfce.sinc.receive.impl.SincEspecie;
import com.touchcomp.touchnfce.sinc.receive.impl.SincGrupo;
import com.touchcomp.touchnfce.sinc.receive.impl.SincGrupoEmpresa;
import com.touchcomp.touchnfce.sinc.receive.impl.SincGrupoPessoas;
import com.touchcomp.touchnfce.sinc.receive.impl.SincICMSSTRetidoAntInfo;
import com.touchcomp.touchnfce.sinc.receive.impl.SincIncidenciaCbsIbs;
import com.touchcomp.touchnfce.sinc.receive.impl.SincIncidenciaIcms;
import com.touchcomp.touchnfce.sinc.receive.impl.SincIncidenciaIpi;
import com.touchcomp.touchnfce.sinc.receive.impl.SincIncidenciaPisCofins;
import com.touchcomp.touchnfce.sinc.receive.impl.SincInfoUltEntradaProduto;
import com.touchcomp.touchnfce.sinc.receive.impl.SincIntermediadorComercial;
import com.touchcomp.touchnfce.sinc.receive.impl.SincMeioPagamento;
import com.touchcomp.touchnfce.sinc.receive.impl.SincModalidadeIcms;
import com.touchcomp.touchnfce.sinc.receive.impl.SincModeloDocFiscal;
import com.touchcomp.touchnfce.sinc.receive.impl.SincModeloEmail;
import com.touchcomp.touchnfce.sinc.receive.impl.SincModeloFiscal;
import com.touchcomp.touchnfce.sinc.receive.impl.SincModeloFiscalCatPessoa;
import com.touchcomp.touchnfce.sinc.receive.impl.SincModeloFiscalCbsIbs;
import com.touchcomp.touchnfce.sinc.receive.impl.SincModeloFiscalEmpresa;
import com.touchcomp.touchnfce.sinc.receive.impl.SincModeloFiscalIcms;
import com.touchcomp.touchnfce.sinc.receive.impl.SincModeloFiscalIpi;
import com.touchcomp.touchnfce.sinc.receive.impl.SincModeloFiscalNCM;
import com.touchcomp.touchnfce.sinc.receive.impl.SincModeloFiscalNatOperacao;
import com.touchcomp.touchnfce.sinc.receive.impl.SincModeloFiscalOBSContrib;
import com.touchcomp.touchnfce.sinc.receive.impl.SincModeloFiscalOBSFisco;
import com.touchcomp.touchnfce.sinc.receive.impl.SincModeloFiscalPisCofins;
import com.touchcomp.touchnfce.sinc.receive.impl.SincModeloFiscalProduto;
import com.touchcomp.touchnfce.sinc.receive.impl.SincModeloFiscalProdutos;
import com.touchcomp.touchnfce.sinc.receive.impl.SincModeloFiscalProdutosVinc;
import com.touchcomp.touchnfce.sinc.receive.impl.SincModeloFiscalUF;
import com.touchcomp.touchnfce.sinc.receive.impl.SincMotivoDesoneracaoIcms;
import com.touchcomp.touchnfce.sinc.receive.impl.SincMsgComandosNFCe;
import com.touchcomp.touchnfce.sinc.receive.impl.SincMsgComandosNFCeEmp;
import com.touchcomp.touchnfce.sinc.receive.impl.SincNFCeCaixa;
import com.touchcomp.touchnfce.sinc.receive.impl.SincNFCeOpcoes;
import com.touchcomp.touchnfce.sinc.receive.impl.SincNFCeOpcoesCondPagamento;
import com.touchcomp.touchnfce.sinc.receive.impl.SincNFCeOpcoesGereMaquinas;
import com.touchcomp.touchnfce.sinc.receive.impl.SincNFCeOpcoesGrupoAferAbastecimento;
import com.touchcomp.touchnfce.sinc.receive.impl.SincNFCeOpcoesGrupoCanc;
import com.touchcomp.touchnfce.sinc.receive.impl.SincNFCeOpcoesGrupoDesc;
import com.touchcomp.touchnfce.sinc.receive.impl.SincNFCeOpcoesGrupoFinanc;
import com.touchcomp.touchnfce.sinc.receive.impl.SincNFCeOpcoesGrupoOpBomba;
import com.touchcomp.touchnfce.sinc.receive.impl.SincNFCeOpcoesMeioPagamento;
import com.touchcomp.touchnfce.sinc.receive.impl.SincNFCeOpcoesTipoPagNFe;
import com.touchcomp.touchnfce.sinc.receive.impl.SincNaturezaOperacao;
import com.touchcomp.touchnfce.sinc.receive.impl.SincNcm;
import com.touchcomp.touchnfce.sinc.receive.impl.SincObjectObsDinamica;
import com.touchcomp.touchnfce.sinc.receive.impl.SincObsFaturamento;
import com.touchcomp.touchnfce.sinc.receive.impl.SincPais;
import com.touchcomp.touchnfce.sinc.receive.impl.SincParamCreditoLoja;
import com.touchcomp.touchnfce.sinc.receive.impl.SincParamCreditoLojaItem;
import com.touchcomp.touchnfce.sinc.receive.impl.SincParamTribCbsIbs;
import com.touchcomp.touchnfce.sinc.receive.impl.SincParamTribCbsIbsCat;
import com.touchcomp.touchnfce.sinc.receive.impl.SincParamTribCbsIbsCfop;
import com.touchcomp.touchnfce.sinc.receive.impl.SincParamTribCbsIbsClass;
import com.touchcomp.touchnfce.sinc.receive.impl.SincParamTribCbsIbsClassNcm;
import com.touchcomp.touchnfce.sinc.receive.impl.SincParamTribCbsIbsEmp;
import com.touchcomp.touchnfce.sinc.receive.impl.SincPessoa;
import com.touchcomp.touchnfce.sinc.receive.impl.SincPessoaEmail;
import com.touchcomp.touchnfce.sinc.receive.impl.SincPrevImpostosNcm;
import com.touchcomp.touchnfce.sinc.receive.impl.SincProduto;
import com.touchcomp.touchnfce.sinc.receive.impl.SincProdutoCodBarras;
import com.touchcomp.touchnfce.sinc.receive.impl.SincProdutoCodBarrasVinc;
import com.touchcomp.touchnfce.sinc.receive.impl.SincProdutoGrade;
import com.touchcomp.touchnfce.sinc.receive.impl.SincProdutoGradeCor;
import com.touchcomp.touchnfce.sinc.receive.impl.SincProdutoGradeCorVinc;
import com.touchcomp.touchnfce.sinc.receive.impl.SincProdutoGradeVinc;
import com.touchcomp.touchnfce.sinc.receive.impl.SincProdutoItemUnMedida;
import com.touchcomp.touchnfce.sinc.receive.impl.SincProdutoItemUnMedidaVinc;
import com.touchcomp.touchnfce.sinc.receive.impl.SincProdutoVinc;
import com.touchcomp.touchnfce.sinc.receive.impl.SincPropCertificadoConexao;
import com.touchcomp.touchnfce.sinc.receive.impl.SincRegiaoTabPrecoDinamica;
import com.touchcomp.touchnfce.sinc.receive.impl.SincRegimeTributario;
import com.touchcomp.touchnfce.sinc.receive.impl.SincRegraExcecaoCbsIbs;
import com.touchcomp.touchnfce.sinc.receive.impl.SincRegraExcecaoNCM;
import com.touchcomp.touchnfce.sinc.receive.impl.SincRepresentante;
import com.touchcomp.touchnfce.sinc.receive.impl.SincRepresentanteEmpresa;
import com.touchcomp.touchnfce.sinc.receive.impl.SincServidorEmail;
import com.touchcomp.touchnfce.sinc.receive.impl.SincSituacaoDocumento;
import com.touchcomp.touchnfce.sinc.receive.impl.SincSituacaoPedidos;
import com.touchcomp.touchnfce.sinc.receive.impl.SincSubEspecie;
import com.touchcomp.touchnfce.sinc.receive.impl.SincTabelaPrecoBase;
import com.touchcomp.touchnfce.sinc.receive.impl.SincTabelaPrecoBaseProduto;
import com.touchcomp.touchnfce.sinc.receive.impl.SincTabelaPrecoBaseProdutoVinc;
import com.touchcomp.touchnfce.sinc.receive.impl.SincTabelaPrecoBaseVinc;
import com.touchcomp.touchnfce.sinc.receive.impl.SincTabelaPrecoPromocoes;
import com.touchcomp.touchnfce.sinc.receive.impl.SincTabelaPrecoPromocoesEmp;
import com.touchcomp.touchnfce.sinc.receive.impl.SincTabelaPrecoPromocoesProd;
import com.touchcomp.touchnfce.sinc.receive.impl.SincTabelaPrecoPromocoesProdQtd;
import com.touchcomp.touchnfce.sinc.receive.impl.SincTabelaPrecosDinCond;
import com.touchcomp.touchnfce.sinc.receive.impl.SincTabelaPrecosDinEmp;
import com.touchcomp.touchnfce.sinc.receive.impl.SincTabelaPrecosDinamica;
import com.touchcomp.touchnfce.sinc.receive.impl.SincTanqueCombustivel;
import com.touchcomp.touchnfce.sinc.receive.impl.SincTipoAutomacaoPosto;
import com.touchcomp.touchnfce.sinc.receive.impl.SincTipoBandeiraTef;
import com.touchcomp.touchnfce.sinc.receive.impl.SincTipoBandeiraTefEmpresa;
import com.touchcomp.touchnfce.sinc.receive.impl.SincTipoContribuinteCbsIbs;
import com.touchcomp.touchnfce.sinc.receive.impl.SincTipoEmissaoNFe;
import com.touchcomp.touchnfce.sinc.receive.impl.SincTipoEmpresa;
import com.touchcomp.touchnfce.sinc.receive.impl.SincTipoFrete;
import com.touchcomp.touchnfce.sinc.receive.impl.SincTipoPagamentoNFe;
import com.touchcomp.touchnfce.sinc.receive.impl.SincTransportador;
import com.touchcomp.touchnfce.sinc.receive.impl.SincUnidadeFederativa;
import com.touchcomp.touchnfce.sinc.receive.impl.SincUnidadeMedida;
import com.touchcomp.touchnfce.sinc.receive.impl.SincUsuario;
import com.touchcomp.touchnfce.sinc.receive.impl.SincUsuarioEmpresa;
import com.touchcomp.touchnfce.sinc.receive.impl.SincVeiculo;
import com.touchcomp.touchnfce.sinc.receive.impl.SincVersaoNFe;
import com.touchcomp.touchnfce.utils.UtilDataSincCheck;
import java.io.FileNotFoundException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;

public class SincFactory {
    private long duration = 0L;
    private static SincFactory instance;
    private SincListener listener = null;

    private SincFactory() {
    }

    public static SincFactory getInstance() {
        if (instance == null) {
            instance = new SincFactory();
        }
        return instance;
    }

    public List<SincBase> getSincs(SincParams params) {
        LinkedList<SincBase> aux = new LinkedList<SincBase>();
        aux.add(new SincIncidenciaPisCofins(params));
        aux.add(new SincIncidenciaIcms(params));
        aux.add(new SincIncidenciaIpi(params));
        aux.add(new SincClasseEnquadramentoIpi(params));
        aux.add(new SincObjectObsDinamica(params));
        aux.add(new SincObsFaturamento(params));
        aux.add(new SincGrupoEmpresa(params));
        aux.add(new SincCest(params));
        aux.add(new SincRegimeTributario(params));
        aux.add(new SincMotivoDesoneracaoIcms(params));
        aux.add(new SincPropCertificadoConexao(params));
        aux.add(new SincConfiguracaoCertificado(params));
        aux.add(new SincConfiguracaoCertificadoItem(params));
        aux.add(new SincDiaSemana(params));
        aux.add(new SincPais(params));
        aux.add(new SincUnidadeFederativa(params));
        aux.add(new SincCidade(params));
        aux.add(new SincBandeiraCartaoNFe(params));
        aux.add(new SincBandeiraTEF(params));
        aux.add(new SincCategoriaPessoa(params));
        aux.add(new SincCategoriaCbsIbs(params));
        aux.add(new SincTipoContribuinteCbsIbs(params));
        aux.add(new SincCnae(params));
        aux.add(new SincTipoEmpresa(params));
        aux.add(new SincCor(params));
        aux.add(new SincClassificacaoProduto(params));
        aux.add(new SincModalidadeIcms(params));
        aux.add(new SincModeloDocFiscal(params));
        aux.add(new SincCfop(params));
        aux.add(new SincNcm(params));
        aux.add(new SincRegraExcecaoNCM(params));
        aux.add(new SincRegraExcecaoCbsIbs(params));
        aux.add(new SincPrevImpostosNcm(params));
        aux.add(new SincTipoEmissaoNFe(params));
        aux.add(new SincTipoPagamentoNFe(params));
        aux.add(new SincTipoBandeiraTef(params));
        aux.add(new SincSituacaoDocumento(params));
        aux.add(new SincClassificacaoProdutoANP(params));
        aux.add(new SincEmbalagem(params));
        aux.add(new SincEspecie(params));
        aux.add(new SincSubEspecie(params));
        aux.add(new SincGrupoPessoas(params));
        aux.add(new SincPessoa(params));
        aux.add(new SincPessoaEmail(params));
        aux.add(new SincUnidadeMedida(params));
        aux.add(new SincVersaoNFe(params));
        aux.add(new SincMeioPagamento(params));
        aux.add(new SincCondicoesPagamento(params));
        aux.add(new SincGrupo(params));
        aux.add(new SincEmpresa(params));
        aux.add(new SincDadosFiscaisUF(params));
        aux.add(new SincDadosFiscaisUFNCMFCP(params));
        aux.add(new SincRepresentante(params));
        aux.add(new SincRepresentanteEmpresa(params));
        aux.add(new SincUsuario(params));
        aux.add(new SincUsuarioEmpresa(params));
        aux.add(new SincTransportador(params));
        aux.add(new SincVeiculo(params));
        aux.add(new SincIntermediadorComercial(params));
        aux.add(new SincMsgComandosNFCe(params));
        aux.add(new SincMsgComandosNFCeEmp(params));
        aux.add(new SincClassificacaoClientes(params));
        aux.add(new SincCliente(params));
        aux.add(new SincClienteNFCe(params));
        aux.add(new SincClienteNFCeMeioPag(params));
        aux.add(new SincClienteFichaFinanceiraAutorizados(params));
        aux.add(new SincClienteUnidadeFat(params));
        aux.add(new SincClienteVeiculo(params));
        aux.add(new SincRegiaoTabPrecoDinamica(params));
        aux.add(new SincAvaliadorExpTabExp(params));
        aux.add(new SincAvaliadorExpTabExpValor(params));
        aux.add(new SincAvaliadorExpressoes(params));
        aux.add(new SincAvaliadorExpressoesFormulas(params));
        aux.add(new SincAvaliadorExpressoesPreFormulas(params));
        aux.add(new SincAvaliadorExpressoesVarConst(params));
        aux.add(new SincTipoBandeiraTefEmpresa(params));
        aux.add(new SincServidorEmail(params));
        aux.add(new SincModeloEmail(params));
        aux.add(new SincTipoFrete(params));
        aux.add(new SincProduto(params));
        aux.add(new SincProdutoVinc(params));
        aux.add(new SincProdutoCodBarras(params));
        aux.add(new SincProdutoCodBarrasVinc(params));
        aux.add(new SincProdutoItemUnMedida(params));
        aux.add(new SincProdutoItemUnMedidaVinc(params));
        aux.add(new SincProdutoGrade(params));
        aux.add(new SincProdutoGradeVinc(params));
        aux.add(new SincProdutoGradeCor(params));
        aux.add(new SincProdutoGradeCorVinc(params));
        aux.add(new SincModeloFiscalIcms(params));
        aux.add(new SincModeloFiscalPisCofins(params));
        aux.add(new SincModeloFiscalIpi(params));
        aux.add(new SincNaturezaOperacao(params));
        aux.add(new SincAliquotaReferenciaImposto(params));
        aux.add(new SincAliquotaPadraoImposto(params));
        aux.add(new SincIncidenciaCbsIbs(params));
        aux.add(new SincClassificacaoTributariaCbsIbs(params));
        aux.add(new SincClassificacaoTribCbsIbsModDoc(params));
        aux.add(new SincModeloFiscalCbsIbs(params));
        aux.add(new SincModeloFiscal(params));
        aux.add(new SincModeloFiscalOBSFisco(params));
        aux.add(new SincModeloFiscalOBSContrib(params));
        aux.add(new SincInfoUltEntradaProduto(params));
        aux.add(new SincTabelaPrecoBaseVinc(params));
        aux.add(new SincTabelaPrecoBase(params));
        aux.add(new SincTabelaPrecoBaseProduto(params));
        aux.add(new SincTabelaPrecoBaseProdutoVinc(params));
        aux.add(new SincTabelaPrecosDinamica(params));
        aux.add(new SincTabelaPrecosDinCond(params));
        aux.add(new SincTabelaPrecosDinEmp(params));
        aux.add(new SincModeloFiscalNatOperacao(params));
        aux.add(new SincModeloFiscalProduto(params));
        aux.add(new SincModeloFiscalProdutos(params));
        aux.add(new SincModeloFiscalProdutosVinc(params));
        aux.add(new SincModeloFiscalEmpresa(params));
        aux.add(new SincModeloFiscalNCM(params));
        aux.add(new SincModeloFiscalUF(params));
        aux.add(new SincModeloFiscalCatPessoa(params));
        aux.add(new SincICMSSTRetidoAntInfo(params));
        aux.add(new SincSituacaoPedidos(params));
        aux.add(new SincCarteiraCobranca(params));
        aux.add(new SincTipoAutomacaoPosto(params));
        aux.add(new SincParamCreditoLoja(params));
        aux.add(new SincParamCreditoLojaItem(params));
        aux.add(new SincCentroEstoque(params));
        aux.add(new SincConfigValPedidos(params));
        aux.add(new SincConfigValPedidosItem(params));
        aux.add(new SincConfigValPedidosItGrupo(params));
        aux.add(new SincNFCeOpcoes(params));
        aux.add(new SincNFCeOpcoesCondPagamento(params));
        aux.add(new SincNFCeOpcoesGereMaquinas(params));
        aux.add(new SincNFCeOpcoesGrupoAferAbastecimento(params));
        aux.add(new SincNFCeOpcoesGrupoCanc(params));
        aux.add(new SincNFCeOpcoesGrupoDesc(params));
        aux.add(new SincNFCeOpcoesGrupoOpBomba(params));
        aux.add(new SincNFCeOpcoesGrupoFinanc(params));
        aux.add(new SincNFCeOpcoesMeioPagamento(params));
        aux.add(new SincNFCeOpcoesTipoPagNFe(params));
        aux.add(new SincNFCeCaixa(params));
        aux.add(new SincTanqueCombustivel(params));
        aux.add(new SincBombaCombustivel(params));
        aux.add(new SincBicoBombaCombustivel(params));
        aux.add(new SincTabelaPrecoPromocoes(params));
        aux.add(new SincTabelaPrecoPromocoesProd(params));
        aux.add(new SincTabelaPrecoPromocoesEmp(params));
        aux.add(new SincTabelaPrecoPromocoesProdQtd(params));
        aux.add(new SincParamTribCbsIbs(params));
        aux.add(new SincParamTribCbsIbsEmp(params));
        aux.add(new SincParamTribCbsIbsClass(params));
        aux.add(new SincParamTribCbsIbsClassNcm(params));
        aux.add(new SincParamTribCbsIbsCfop(params));
        aux.add(new SincParamTribCbsIbsCat(params));
        return aux;
    }

    public synchronized boolean startSincRecebimento(SincParams params) throws ExceptionIO, ExceptionReflection, ExceptionWebService, ExceptionDecodeHexString64, ExceptionZip, FileNotFoundException, ExceptionCertificado, Exception {
        params.setDataHoraUltSincRec(StaticObjects.getDadosSincronizacao().getDataUltimaSincRec());
        Long now = this.getDateTimeFromServer(params);
        Long last = this.getLastSincWithDelay(params);
        UtilDataSincCheck.checaDataPCVsUltSincThrowEx(now, last);
        List<SincBase> sincs = this.getSincs(params);
        this.startIt(sincs);
        HashMap<String, Long> stats = this.getDataEstatistics(sincs, last, now);
        this.startSincInternal(stats, sincs, last, now);
        this.endItRecebimento(sincs, last, now);
        return true;
    }

    public synchronized boolean startSincCliente() throws ExceptionIO, ExceptionReflection, ExceptionWebService, ExceptionDecodeHexString64, ExceptionZip, FileNotFoundException, ExceptionCertificado, Exception {
        SincParams params = new SincParams(StaticObjects.getDadosSincronizacao());
        params.setDataHoraUltSincRec(StaticObjects.getDadosSincronizacao().getDataUltimaSincRec());
        Long now = this.getDateTimeFromServer(params);
        Long last = this.getLastSincWithDelay(params);
        ArrayList<SincBase> sincs = new ArrayList<SincBase>();
        sincs.add(new SincPessoa(params));
        sincs.add(new SincPessoaEmail(params));
        sincs.add(new SincCliente(params));
        sincs.add(new SincClienteNFCe(params));
        sincs.add(new SincClienteNFCeMeioPag(params));
        sincs.add(new SincClienteFichaFinanceiraAutorizados(params));
        sincs.add(new SincClienteUnidadeFat(params));
        sincs.add(new SincVeiculo(params));
        sincs.add(new SincClienteVeiculo(params));
        this.startIt(sincs);
        HashMap<String, Long> ret = this.getDataEstatistics(sincs, last, now);
        this.startSincInternal(ret, sincs, last, now);
        return true;
    }

    public void startSincMsg() throws Exception {
        if (StaticObjects.getDadosSincronizacao().getDataUltimaSincRec() == null) {
            return;
        }
        SincParams params = new SincParams(StaticObjects.getDadosSincronizacao());
        params.setDataHoraUltSincRec(StaticObjects.getDadosSincronizacao().getDataUltimaSincRec());
        Long now = this.getDateTimeFromServer(params);
        Long last = this.getLastSincWithDelay(params);
        new SincMsgComandosNFCe(params).sincAndSave(last, now);
    }

    private Long getLastSincWithDelay(SincParams params) {
        Long last = params.getDataHoraUltSincRec();
        last = last - 10000L;
        return last;
    }

    private void endItRecebimento(List<SincBase> sincs, Long last, Long now) {
        this.duration = (now - last) / 1000L;
        if (this.listener != null) {
            this.listener.afterSincRec(sincs, new Date(last), new Date(now), this.duration);
        }
        System.out.println("Tempo decorrido " + this.duration);
        long tempoEntreSinc = 300L;
        if (StaticObjects.getOpcoes() != null && ToolMethods.isWithData((Number)StaticObjects.getOpcoes().getTempoSegSincRec())) {
            tempoEntreSinc = StaticObjects.getOpcoes().getTempoSegSincRec().intValue();
        }
        boolean showEx = false;
        long nextSinc = now;
        if (tempoEntreSinc * 1000L < 600000L) {
            showEx = true;
            nextSinc = now - 5000L;
        } else {
            nextSinc = now - 600000L;
        }
        StaticObjects.getDadosSincronizacao().setDataUltimaSincRec(nextSinc);
        StaticObjects.getDadosSincronizacao().setSincronizadoCompeletamente((short)1);
        StaticObjects.refreshDadosSincronizacao();
        Date dataIn = new Date(last);
        Date dataFim = new Date(nextSinc);
        System.out.println("Date " + TDate.dateToStr((Date)dataIn, (String)"dd-MM-yyyy HH:mm:ss.SSS"));
        System.out.println("Date " + TDate.dateToStr((Date)dataFim, (String)"dd-MM-yyyy HH:mm:ss.SSS"));
        LogSincronizacao l = new LogSincronizacao();
        l.setDataIn(dataIn);
        l.setDataFim(dataFim);
        l.setDataInL(last);
        l.setDataFimL(nextSinc);
        Main.getBean(ServiceLogSincronizacao.class).save(l);
        if (showEx) {
            throw new RuntimeException("Tempo/intervalo de sincronizacao nao pode ser menor que o delay de seguranca(Segundos): 10000. A sincronizacao foi realizada, mas este tempo curto de sincroniza\u00e7\u00e3o pode provocar problemas.");
        }
    }

    private void startIt(List<SincBase> sincs) {
        if (this.listener != null) {
            this.listener.beforeSincRec(sincs);
            this.listener.onSincProgressItemRec(0L);
        }
    }

    private HashMap<String, Long> getDataEstatistics(List<SincBase> sincs, Long last, Long atual) throws Exception {
        int increment = 0;
        HashMap<String, Long> stats = new HashMap<String, Long>();
        for (SincBase sinc : sincs) {
            if (this.listener != null) {
                this.listener.onSincDataSizeRec(sinc, increment / sincs.size() * 100);
            }
            System.out.println("Iniciando contagem de dados para sincronizar: " + sinc.getPath());
            long ret = sinc.getDataSize(last, atual);
            stats.put(sinc.getPath(), ret);
            System.out.println("Dados para sincronizar: : " + ret);
            ++increment;
            if (this.listener == null) continue;
            double perc = ToolFormatter.arrredondarNumero((Double)((double)increment * 1.0 / (double)sincs.size()), (int)2);
            this.listener.onSincDataSizeRec(sinc, perc * 100.0);
        }
        return stats;
    }

    private void startSincInternal(HashMap<String, Long> stats, List<SincBase> sincs, Long last, Long atual) throws ExceptionIO, ExceptionReflection, ExceptionWebService, ExceptionDecodeHexString64, ExceptionZip, FileNotFoundException, ExceptionCertificado, Exception {
        int increment = 0;
        int counter = 1;
        for (SincBase sinc : sincs) {
            Long data;
            if (this.listener != null) {
                double perc = ToolFormatter.arrredondarNumero((Double)((double)increment * 1.0 / (double)sincs.size()), (int)2);
                this.listener.onSincDataRec(sinc, perc * 100.0);
            }
            if ((data = stats.get(sinc.getPath())) == null || data > 0L) {
                sinc.setListener(this.listener);
                System.out.println("Iniciando carregamento de dados: " + sinc.getPath());
                long ret = sinc.sincAndSave(last, atual);
                System.out.println("Terminado: " + sinc.getPath());
            }
            if (++increment % 5 == 0) {
                System.gc();
            }
            if (this.listener != null) {
                double perc = ToolFormatter.arrredondarNumero((Double)((double)counter * 1.0 / (double)sincs.size()), (int)2);
                this.listener.onSincDataRec(sinc, perc * 100.0);
            }
            ++counter;
        }
    }

    public SincListener getListener() {
        return this.listener;
    }

    public void setListener(SincListener listener) {
        this.listener = listener;
    }

    private Long getDateTimeFromRemoteServer(SincParams params) throws Exception {
        String str = ToolWebService.getData("server-info/get-date-time-miliseconds");
        Long res = new Long(str);
        return res;
    }

    private Long getDateTimeFromServer(SincParams params) throws Exception {
        Long d = this.getDateTimeFromRemoteServer(params);
        return d;
    }
}

