/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.touchnfce.sinc.send;

import com.touchcomp.basementorexceptions.exceptions.impl.certificado.ExceptionCertificado;
import com.touchcomp.basementorexceptions.exceptions.impl.decoder.ExceptionDecodeHexString64;
import com.touchcomp.basementorexceptions.exceptions.impl.ioexception.ExceptionIO;
import com.touchcomp.basementorexceptions.exceptions.impl.reflection.ExceptionReflection;
import com.touchcomp.basementorexceptions.exceptions.impl.webservice.ExceptionWebService;
import com.touchcomp.basementortools.tools.date.ToolDate;
import com.touchcomp.basementortools.tools.hexadecimal.ToolHexString;
import com.touchcomp.basementortools.tools.json.ToolJson;
import com.touchcomp.basementortools.tools.methods.ToolMethods;
import com.touchcomp.basementortools.tools.reflections.ToolReflections;
import com.touchcomp.touchnfce.Main;
import com.touchcomp.touchnfce.service.ServiceSincEntityAPI;
import com.touchcomp.touchnfce.service.impl.ServicePedidoEnv;
import com.touchcomp.touchnfce.sinc.ToolWebService;
import com.touchcomp.touchnfce.sinc.send.SincParamsSend;
import com.touchcomp.touchvomodel.webservices.PackObjectsSinc;
import com.touchcomp.touchvomodel.webservices.RequisicaoWebservice;
import com.touchcomp.touchvomodel.webservices.RespostaWebService;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.Serializable;
import java.lang.reflect.Type;
import java.util.Collection;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import lombok.Generated;
import org.modelmapper.ModelMapper;
import org.springframework.util.ResourceUtils;

public abstract class SincEnvBase<T extends Serializable, S, ID extends Serializable> {
    private final SincParamsSend params;
    private ServiceSincEntityAPI<T, ID> service;
    private ModelMapper modelMapper;
    private long numberOfRegisters = 0L;
    private int atualPage = 0;
    private int REG_PER_TIME_DEFAULT = 10;
    private static final String METHOD_SINC_NAME = "putDataSinc";
    private Class retTypeClass;
    private Date lastSinc = ToolDate.strToDate((String)"01/01/2000");
    private boolean sincInfReg;

    public SincEnvBase(SincParamsSend params) {
        this.params = params;
        if (params.getDataHoraUltSincEnv() != null) {
            this.lastSinc = new Date(params.getDataHoraUltSincEnv());
        }
        if (ToolMethods.isWithData((Collection)params.getRegistros())) {
            this.sincInfReg = true;
        }
    }

    public abstract String getPath();

    public abstract String getDescSinc();

    public File getKeyStore() throws FileNotFoundException {
        try {
            return ResourceUtils.getFile((String)"src/main/resources/keystore/touchcomp.p12");
        }
        catch (FileNotFoundException ex) {
            ex.printStackTrace();
            throw new FileNotFoundException("Certificado de sincroniza\u00e7\u00e3o n\u00e3o encontrado!");
        }
    }

    public String getStorePassword() {
        return "co68010203";
    }

    public String getWebServiceSincMethod() {
        return METHOD_SINC_NAME;
    }

    protected long sendData() throws ExceptionIO, ExceptionWebService, ExceptionReflection, ExceptionDecodeHexString64, Exception, ExceptionCertificado {
        if (this.sincInfReg) {
            return this.sendData(this.params.getRegistros());
        }
        return this.sendDataFromDatabase();
    }

    protected long sendDataFromDatabase() throws ExceptionIO, ExceptionWebService, ExceptionReflection, ExceptionDecodeHexString64, Exception, ExceptionCertificado {
        this.numberOfRegisters = this.service.getCountForSinc(this.lastSinc);
        if (this.numberOfRegisters == 0L) {
            return this.numberOfRegisters;
        }
        do {
            System.out.println("Data Ultimo Envio NFCe/ERP: " + String.valueOf(this.lastSinc));
            List<T> data = this.service.getAllForSincZip(this.lastSinc, this.atualPage, this.getRegPerTime());
            this.sendData(data);
            this.atualPage += this.getRegPerTime();
        } while ((long)this.atualPage < this.numberOfRegisters);
        return this.numberOfRegisters;
    }

    private long sendData(List<T> data) throws ExceptionIO, ExceptionWebService, ExceptionReflection, ExceptionDecodeHexString64, Exception, ExceptionCertificado {
        System.out.println("Data Ultimo Envio NFCe/ERP: " + String.valueOf(this.lastSinc));
        List<S> converted = this.convert(data);
        RequisicaoWebservice r = new RequisicaoWebservice();
        r.setMensagem(ToolHexString.encodeToHex((String)ToolJson.toJson(converted)));
        RespostaWebService resp = (RespostaWebService)ToolWebService.sendData(this.getPath() + "/" + this.getWebServiceSincMethod(this.atualPage), r, RespostaWebService.class);
        this.processaRespostaWebService(resp);
        String str = ToolHexString.decodeToStr((String)resp.getDetalhes());
        List res = ToolJson.readJsonList((String)str, PackObjectsSinc.class);
        this.service.saveSinc(data, res);
        return data.size();
    }

    private List<S> convert(List<T> data) throws ExceptionReflection {
        LinkedList<Object> ret = new LinkedList<Object>();
        for (Serializable obj : data) {
            Object r = this.getModelMapper().map((Object)obj, (Type)this.getDTOClass());
            ret.add(r);
        }
        return ret;
    }

    private Class getDTOClass() {
        if (this.retTypeClass == null) {
            this.retTypeClass = ToolReflections.getGenericTypeClass(this.getClass(), (int)1);
        }
        return this.retTypeClass;
    }

    private String getWebServiceSincMethod(long atualPage) {
        return this.getWebServiceSincMethod();
    }

    private int getRegPerTime() {
        int tempRegPerTime = this.REG_PER_TIME_DEFAULT;
        if (this.params.getNrRegPerTime() > 0) {
            tempRegPerTime = this.params.getNrRegPerTime();
        }
        return tempRegPerTime;
    }

    private ModelMapper getModelMapper() throws ExceptionReflection {
        if (this.modelMapper == null) {
            this.modelMapper = new ModelMapper();
        }
        return this.modelMapper;
    }

    public void beforeSave(T data) {
    }

    public long getDataSize() {
        return this.service.getCountForSinc(this.lastSinc);
    }

    protected void isRespostaValida(RespostaWebService res) throws Exception {
        if (ToolMethods.isEquals((Object)res.getCodStatus(), (Object)0)) {
            throw new Exception("Erro ao sincronizar: " + res.getMensagem());
        }
    }

    protected void processaRespostaWebService(RespostaWebService res) throws Exception {
        this.isRespostaValida(res);
        String json = ToolHexString.decodeToStr((String)res.getDetalhes());
        List sinc = ToolJson.readJsonList((String)json, PackObjectsSinc.class);
        ServicePedidoEnv service = Main.getBean(ServicePedidoEnv.class);
        for (PackObjectsSinc pa : sinc) {
            service.updatePedidoEnv(pa.getIdObjectMentor(), pa.getSerialObjetoOrigem());
        }
    }

    @Generated
    public ServiceSincEntityAPI<T, ID> getService() {
        return this.service;
    }

    @Generated
    public void setService(ServiceSincEntityAPI<T, ID> service) {
        this.service = service;
    }
}

