/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.touchnfce.sinc.send;

import com.touchcomp.basementor.constants.enums.EnumConstantsModeloDocFiscal;
import com.touchcomp.basementorexceptions.exceptions.impl.decoder.ExceptionDecodeHexString64;
import com.touchcomp.basementorexceptions.exceptions.impl.ioexception.ExceptionIO;
import com.touchcomp.basementorexceptions.exceptions.impl.reflection.ExceptionReflection;
import com.touchcomp.basementorexceptions.exceptions.impl.webservice.ExceptionWebService;
import com.touchcomp.basementortools.tools.formatter.ToolFormatter;
import com.touchcomp.basementortools.tools.methods.ToolMethods;
import com.touchcomp.touchnfce.StaticObjects;
import com.touchcomp.touchnfce.model.ControleEntregaNotaPropria;
import com.touchcomp.touchnfce.model.NFCe;
import com.touchcomp.touchnfce.model.NFCeControleCaixa;
import com.touchcomp.touchnfce.model.NFCePessoa;
import com.touchcomp.touchnfce.model.Pedido;
import com.touchcomp.touchnfce.sinc.send.SincEnvBase;
import com.touchcomp.touchnfce.sinc.send.SincEnvListener;
import com.touchcomp.touchnfce.sinc.send.SincParamsSend;
import com.touchcomp.touchnfce.sinc.send.impl.SincControleEntrega;
import com.touchcomp.touchnfce.sinc.send.impl.SincNFCe;
import com.touchcomp.touchnfce.sinc.send.impl.SincNFCeAfericaoPreAbastecimento;
import com.touchcomp.touchnfce.sinc.send.impl.SincNFCeControleCaixa;
import com.touchcomp.touchnfce.sinc.send.impl.SincNFCeEncerranteAbastecimento;
import com.touchcomp.touchnfce.sinc.send.impl.SincNFCeLogPermissaoUsuario;
import com.touchcomp.touchnfce.sinc.send.impl.SincNFCeMovimentoCaixa;
import com.touchcomp.touchnfce.sinc.send.impl.SincNFCePeriodoEmissao;
import com.touchcomp.touchnfce.sinc.send.impl.SincNFCePessoa;
import com.touchcomp.touchnfce.sinc.send.impl.SincNFCePreAbastecimento;
import com.touchcomp.touchnfce.sinc.send.impl.SincNFe;
import com.touchcomp.touchnfce.sinc.send.impl.SincPedidoPreVenda;
import com.touchcomp.touchnfce.sinc.send.impl.SincPeriodoEmissaoNFe;
import com.touchcomp.touchnfce.utils.UtilDataSincCheck;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;

public class SincEnvFactory {
    private Date dateIn;
    private Date dateEnd;
    private long duration = 0L;
    private static SincEnvFactory instance;
    private long totalReg = 0L;
    private SincEnvListener listener = null;
    private boolean isSincronizando = false;

    private SincEnvFactory() {
    }

    public static SincEnvFactory getInstance() {
        if (instance == null) {
            instance = new SincEnvFactory();
        }
        return instance;
    }

    public List<SincEnvBase> getSincs(SincParamsSend params) {
        LinkedList<SincEnvBase> aux = new LinkedList<SincEnvBase>();
        aux.add(new SincNFCePeriodoEmissao(params));
        aux.add(new SincPeriodoEmissaoNFe(params));
        aux.add(new SincNFCeControleCaixa(params));
        aux.add(new SincNFCeMovimentoCaixa(params));
        aux.add(new SincNFCePreAbastecimento(params));
        aux.add(new SincNFCe(params));
        aux.add(new SincNFe(params));
        aux.add(new SincNFCeEncerranteAbastecimento(params));
        aux.add(new SincNFCeAfericaoPreAbastecimento(params));
        aux.add(new SincNFCeLogPermissaoUsuario(params));
        return aux;
    }

    public synchronized boolean startSinc(SincParamsSend params) throws Exception {
        params.setDataHoraUltSincEnv(StaticObjects.getDadosSincronizacao().getDataUltimaSincEnv());
        Date now = new Date();
        UtilDataSincCheck.checaDataPCVsUltSincThrowEx(now.getTime(), params.getDataHoraUltSincEnv());
        List<SincEnvBase> sincs = this.getSincs(params);
        this.startIt(sincs);
        this.getDataEstatistics(sincs);
        this.startSincInternal(sincs);
        this.endIt(sincs);
        StaticObjects.getDadosSincronizacao().setDataUltimaSincEnv(now.getTime());
        StaticObjects.refreshDadosSincronizacao();
        return true;
    }

    public synchronized boolean startSincPedido(Pedido pedido) throws ExceptionIO, ExceptionReflection, ExceptionWebService, ExceptionDecodeHexString64, Exception {
        SincParamsSend params = new SincParamsSend(StaticObjects.getDadosSincronizacao(), StaticObjects.getNFCeCaixa());
        params.setRegistros(ToolMethods.toList((Object[])new Object[]{pedido}));
        SincPedidoPreVenda sinc = new SincPedidoPreVenda(params);
        this.startSincInternal(ToolMethods.toList((Object[])new Object[]{sinc}));
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized boolean startSincNFCeImediatamente(NFCe vo) throws ExceptionIO, ExceptionReflection, ExceptionWebService, ExceptionDecodeHexString64, Exception {
        try {
            SincParamsSend params = new SincParamsSend(StaticObjects.getDadosSincronizacao(), StaticObjects.getNFCeCaixa());
            params.setRegistros(ToolMethods.toList((Object[])new Object[]{vo}));
            SincEnvBase sinc = ToolMethods.isEquals((Object)vo.getModeloDocFiscal().getCodigo(), (Object)EnumConstantsModeloDocFiscal.NFCE_65.getCodigo()) ? new SincNFCe(params) : new SincNFe(params);
            this.startSincInternal(ToolMethods.toList((Object[])new Object[]{sinc}));
        }
        finally {
            vo.setSincronizacaoManual((short)0);
        }
        return true;
    }

    public synchronized boolean startSincUnidadeFatCliente(NFCePessoa pessoa) throws ExceptionIO, ExceptionReflection, ExceptionWebService, ExceptionDecodeHexString64, Exception {
        SincParamsSend params = new SincParamsSend(StaticObjects.getDadosSincronizacao(), StaticObjects.getNFCeCaixa());
        params.setRegistros(ToolMethods.toList((Object[])new Object[]{pessoa}));
        SincNFCePessoa sinc = new SincNFCePessoa(params);
        this.startSincInternal(ToolMethods.toList((Object[])new Object[]{sinc}));
        return true;
    }

    private void endIt(List<SincEnvBase> sincs) {
        this.dateEnd = new Date();
        this.duration = (this.dateEnd.getTime() - this.dateIn.getTime()) / 1000L;
        if (this.listener != null) {
            this.listener.afterSincEnv(sincs, this.dateIn, this.dateEnd, this.duration);
        }
    }

    private void startIt(List<SincEnvBase> sincs) {
        this.dateIn = new Date();
        if (this.listener != null) {
            this.listener.beforeSincEnv(sincs);
        }
    }

    private synchronized void getDataEstatistics(List<SincEnvBase> sincs) throws ExceptionIO, ExceptionReflection, ExceptionWebService {
        int increment = 0;
        for (SincEnvBase sinc : sincs) {
            System.out.println("Inciando: " + sinc.getPath());
            long ret = sinc.getDataSize();
            this.totalReg += ret;
            System.out.println("Dados para sincronizar: : " + ret);
            ++increment;
            if (this.listener == null) continue;
            double perc = ToolFormatter.arrredondarNumero((Double)((double)increment * 1.0 / (double)sincs.size()), (int)2);
            this.listener.onSincDataSizeEnv(sinc, perc * 100.0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void startSincInternal(List<SincEnvBase> sincs) throws ExceptionIO, ExceptionReflection, ExceptionWebService, ExceptionDecodeHexString64, Exception {
        this.isSincronizando = true;
        try {
            int increment = 0;
            for (SincEnvBase sinc : sincs) {
                System.out.println("Iniciando: " + sinc.getPath());
                long ret = sinc.sendData();
                System.out.println("Terminado: " + sinc.getPath());
                ++increment;
                if (this.listener == null) continue;
                this.listener.onSincDataEnv(sinc, increment / sincs.size() * 100);
            }
        }
        finally {
            this.isSincronizando = false;
        }
    }

    public SincEnvListener getListener() {
        return this.listener;
    }

    public void setListener(SincEnvListener listener) {
        this.listener = listener;
    }

    public synchronized boolean startSincControleEntrega(ControleEntregaNotaPropria controleEntrega) throws ExceptionIO, ExceptionReflection, ExceptionWebService, ExceptionDecodeHexString64, Exception {
        SincParamsSend params = new SincParamsSend(StaticObjects.getDadosSincronizacao(), StaticObjects.getNFCeCaixa());
        params.setRegistros(ToolMethods.toList((Object[])new Object[]{controleEntrega}));
        SincControleEntrega sinc = new SincControleEntrega(params);
        this.startSincInternal(ToolMethods.toList((Object[])new Object[]{sinc}));
        return true;
    }

    public synchronized boolean startSincNFCeControleCaixa(NFCeControleCaixa controleCaixa) throws ExceptionIO, ExceptionReflection, ExceptionWebService, ExceptionDecodeHexString64, Exception {
        SincParamsSend params = new SincParamsSend(StaticObjects.getDadosSincronizacao(), StaticObjects.getNFCeCaixa());
        params.setRegistros(ToolMethods.toList((Object[])new Object[]{controleCaixa}));
        SincNFCeControleCaixa sinc = new SincNFCeControleCaixa(params);
        this.startSincInternal(ToolMethods.toList((Object[])new Object[]{sinc}));
        return true;
    }
}

