/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.touchnfce.tasks.impl;

import com.fincatto.documentofiscal.nfe400.classes.lote.envio.NFLoteEnvio;
import com.fincatto.documentofiscal.nfe400.classes.nota.NFNota;
import com.touchcomp.basementorclientwebservices.nfe.model.env.lotefat.NFeLoteFaturamento;
import com.touchcomp.basementorexceptions.exceptions.impl.erroprogramacao.ExceptionErroProgramacao;
import com.touchcomp.basementortools.tools.methods.ToolMethods;
import com.touchcomp.touchnfce.Main;
import com.touchcomp.touchnfce.model.Empresa;
import com.touchcomp.touchnfce.model.NFCe;
import com.touchcomp.touchnfce.model.NFCeLoteNotas;
import com.touchcomp.touchnfce.model.NFCeOpcoes;
import com.touchcomp.touchnfce.model.TipoEmissaoNFe;
import com.touchcomp.touchnfce.nfe.AuxEnviaNota;
import com.touchcomp.touchnfce.nfe.impl.versoes.ConfigCertificate;
import com.touchcomp.touchnfce.nfe.impl.versoes.ConstNFeVersoes;
import com.touchcomp.touchnfce.nfe.impl.versoes.UtilNfeSendWebServices;
import com.touchcomp.touchnfce.service.impl.ServiceTipoEmissaoNFe;
import com.touchcomp.touchnfce.tasks.AppTask;
import com.touchcomp.touchnfce.tasks.TaskResult;
import com.touchcomp.touchnfce.utils.UtilNFCe;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

public class AppTaskGerarXmlNFe
extends AppTask<NFCeLoteNotas> {
    private final NFCeLoteNotas loteNotas;
    private final NFCeOpcoes opcoes;
    private final Empresa empresa;

    public AppTaskGerarXmlNFe(TaskResult result, NFCeOpcoes opcoes, NFCeLoteNotas nfCe, Empresa empresa) {
        super(result);
        this.loteNotas = nfCe;
        this.opcoes = opcoes;
        this.empresa = empresa;
    }

    @Override
    protected NFCeLoteNotas execute() throws Exception {
        TipoEmissaoNFe tipoEmissaoNFe = null;
        tipoEmissaoNFe = ToolMethods.isWithData(this.loteNotas.getNotas()) ? UtilNFCe.getTipoEmissaoNFe(this.loteNotas.getNotas().get(0)) : Main.getBean(ServiceTipoEmissaoNFe.class).getTipoEmissaoNormal();
        ConfigCertificate config = new ConfigCertificate(this.empresa.getPessoa().getEndereco().getCidade().getUf(), this.opcoes, tipoEmissaoNFe);
        NFeLoteFaturamento lt = new AuxEnviaNota(this.opcoes).criarNotaEnvio(this.loteNotas);
        NFLoteEnvio stat = UtilNfeSendWebServices.getLoteAssinado(config, ConstNFeVersoes.VERSAO_20180005_1_20, lt);
        List notas = stat.getNotas();
        this.setXMLNFCe(notas, this.loteNotas);
        return this.loteNotas;
    }

    private void setXMLNFCe(List<NFNota> notas, NFCeLoteNotas loteNotas) throws Exception {
        for (NFCe nf : loteNotas.getNotas()) {
            Optional<NFNota> found = notas.stream().filter(i -> Objects.equals(i.getInfo().getIdentificador(), "NFe" + nf.getChaveNFCe())).findFirst();
            if (found.isPresent()) {
                nf.setXml(found.get().toString().getBytes());
                nf.setDigestValue(found.get().getAssinatura().getSignedInfo().getReference().getDigestValue());
                nf.setUrlQrCode(found.get().getInfoSuplementar().getQrCode());
                nf.setUrlConsulta(found.get().getInfoSuplementar().getUrlConsultaChaveAcesso());
                continue;
            }
            throw new ExceptionErroProgramacao("Ocorreu um erro ao comparar as notas enviadas com o retorno. Verifique a NF id " + nf.getIdentificador());
        }
    }
}

