/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.touchnfce.tasks.utils;

import com.touchcomp.basementor.constants.enums.nfe.EnumConstNFeStatus;
import com.touchcomp.basementorclientwebservices.nfe.model.env.consultanota.ConsultaNFeRet;
import com.touchcomp.basementorclientwebservices.nfe.model.env.consultanota.NFeConsultaNota;
import com.touchcomp.basementorlogger.TLogger;
import com.touchcomp.touchnfce.Main;
import com.touchcomp.touchnfce.model.Empresa;
import com.touchcomp.touchnfce.model.NFCe;
import com.touchcomp.touchnfce.model.NFCeOpcoes;
import com.touchcomp.touchnfce.model.TipoEmissaoNFe;
import com.touchcomp.touchnfce.nfe.impl.versoes.ConfigCertificate;
import com.touchcomp.touchnfce.nfe.impl.versoes.ConstNFeVersoes;
import com.touchcomp.touchnfce.nfe.impl.versoes.UtilNfeSendWebServices;
import com.touchcomp.touchnfce.service.impl.ServiceTipoEmissaoNFe;
import com.touchcomp.touchnfce.utils.UtilNFCe;
import java.sql.Date;
import java.time.LocalDateTime;
import java.time.ZoneId;

public class UtilConsultaStatusNFCe {
    public static NFCe execute(NFCeOpcoes opcoes, NFCe nfce) throws Exception {
        try {
            TipoEmissaoNFe tipoEmissaoNFe = Main.getBean(ServiceTipoEmissaoNFe.class).getTipoEmissaoNormal();
            Empresa empresa = nfce.getEmpresa();
            ConfigCertificate config = new ConfigCertificate(empresa.getPessoa().getEndereco().getCidade().getUf(), opcoes, tipoEmissaoNFe);
            NFeConsultaNota consultaNota = new NFeConsultaNota();
            consultaNota.setChaveNFe(nfce.getChaveNFCe());
            ConsultaNFeRet stat = UtilNfeSendWebServices.consultarNota(config, ConstNFeVersoes.VERSAO_20180005_1_20, consultaNota);
            nfce.setStatus(Integer.valueOf(stat.getStatus()));
            nfce.setMotivo(stat.getMotivo());
            nfce.setTipoAmbiente(Integer.valueOf(stat.getAmbiente().getCodigo()));
            if (stat.getProtocolo() != null) {
                nfce.setNrProtocolo(stat.getProtocolo().getNumeroProtocolo());
                LocalDateTime dataRec = stat.getProtocolo().getDataRecebimento();
                nfce.setDataAutorizacao(Date.from(dataRec.atZone(ZoneId.systemDefault()).toInstant()));
                if (stat.getProtocolo().getXml() != null && nfce.getXmlAutorizacao() == null && EnumConstNFeStatus.isStatusAutorizada((Integer)nfce.getStatus())) {
                    nfce.setXmlAutorizacao(stat.getProtocolo().getXml().getBytes());
                }
            }
        }
        catch (Throwable ex) {
            TLogger.get(UtilConsultaStatusNFCe.class).error(ex);
            throw ex;
        }
        return UtilConsultaStatusNFCe.save(nfce);
    }

    private static NFCe save(NFCe nfCe) {
        return UtilNFCe.save(nfCe);
    }
}

