/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.touchnfce.tasks.utils;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.touchcomp.basementortools.tools.downloadweb.ToolDownloadWeb;
import com.touchcomp.basementortools.tools.string.ToolString;
import com.touchcomp.touchnfce.Main;
import com.touchcomp.touchnfce.StaticObjects;
import com.touchcomp.touchnfce.model.Cidade;
import com.touchcomp.touchnfce.model.DadosSincronizacao;
import com.touchcomp.touchnfce.modeltemp.TempImplLogradouro;
import com.touchcomp.touchnfce.service.impl.ServiceCidade;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import org.apache.commons.io.IOUtils;

public class UtilPesquisaCEP {
    public static TempImplLogradouro pesquisaEnderecoCep(String cep) throws Exception {
        return UtilPesquisaCEP.callWebServiceAndGetAddress(cep);
    }

    private static String callWebService(String cep) throws IOException {
        File f = File.createTempFile("temp", ".xml");
        DadosSincronizacao sin = StaticObjects.getDadosSincronizacao();
        if (sin != null && sin.getPossuiProxy() != null && sin.getPossuiProxy().equals((short)1)) {
            ToolDownloadWeb.InternalProxy d = sin.getPossuiAutenticacaoProxy() != null && sin.getPossuiAutenticacaoProxy().equals((short)1) ? new ToolDownloadWeb.InternalProxy(sin.getServidorProxy(), sin.getPortaServidorProxy().intValue(), sin.getUsuarioProxy(), sin.getSenhaProxy()) : new ToolDownloadWeb.InternalProxy(sin.getServidorProxy(), sin.getPortaServidorProxy().intValue());
            ToolDownloadWeb.downloadFileToServer((File)f, (String)("http://viacep.com.br/ws/" + cep + "/json/"), (ToolDownloadWeb.InternalProxy)d);
        } else {
            ToolDownloadWeb.downloadFileToServer((File)f, (String)("http://viacep.com.br/ws/" + cep + "/json/"));
        }
        String aux = IOUtils.toString((InputStream)new FileInputStream(f), (String)StandardCharsets.UTF_8.name());
        aux = ToolString.clearSpecialCharacXML((String)aux);
        return aux;
    }

    private static TempImplLogradouro callWebServiceAndGetAddress(String cep) throws Exception {
        String out = UtilPesquisaCEP.callWebService(cep);
        ObjectMapper mapper = new ObjectMapper();
        JsonFactory factory = mapper.getJsonFactory();
        JsonParser parser = factory.createJsonParser(out);
        JsonNode actualObj = (JsonNode)mapper.readTree(parser);
        if (actualObj.findValue("erro") != null) {
            return null;
        }
        String logradouro = actualObj.findValue("logradouro").asText();
        String complemento = actualObj.findValue("complemento").asText();
        String bairro = actualObj.findValue("bairro").asText();
        String localidade = actualObj.findValue("localidade").asText();
        String uf = actualObj.findValue("uf").asText();
        String ibge = actualObj.findValue("ibge").asText();
        ServiceCidade serviceCidade = Main.getBean(ServiceCidade.class);
        Cidade c = serviceCidade.findCidadeCodMunicipio(ibge);
        TempImplLogradouro log = new TempImplLogradouro();
        if (bairro != null) {
            log.setBairro(bairro.toUpperCase());
        }
        log.setCep(cep);
        log.setCidade(c);
        if (logradouro != null) {
            log.setLogradouro(logradouro.toUpperCase());
        }
        if (complemento != null) {
            log.setComplemento(complemento.toUpperCase());
        }
        return log;
    }
}

