/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.touchnfce.utils;

import com.touchcomp.basementor.constants.enums.modelofiscal.EnumConstModeloFiscalObs;
import com.touchcomp.basementorexceptions.exceptions.impl.avaliadorexpressoes.ExceptionAvaliadorExpressoes;
import com.touchcomp.basementorexceptions.exceptions.impl.invaliddata.ExceptionInvalidData;
import com.touchcomp.basementortools.tools.methods.ToolMethods;
import com.touchcomp.basementortools.tools.string.ToolString;
import com.touchcomp.basementortools.tools.textdynamic.ToolTextDynamic;
import com.touchcomp.touchnfce.Main;
import com.touchcomp.touchnfce.model.ModeloFiscal;
import com.touchcomp.touchnfce.model.ModeloFiscalObsContrib;
import com.touchcomp.touchnfce.model.ModeloFiscalObsFisco;
import com.touchcomp.touchnfce.model.NFCe;
import com.touchcomp.touchnfce.model.NFCeItem;
import com.touchcomp.touchnfce.model.NFCeObsContrib;
import com.touchcomp.touchnfce.model.NFCeObsFisco;
import com.touchcomp.touchnfce.model.ObjectObsDinamica;
import com.touchcomp.touchnfce.model.ObsFaturamento;
import com.touchcomp.touchnfce.service.impl.ServiceObjectObsDinamica;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;

class HelperObservacoesFaturamento {
    HelperObservacoesFaturamento() {
    }

    static void definirObservacoes(NFCe nfce) throws ExceptionAvaliadorExpressoes, ExceptionInvalidData {
        HelperObservacoesFaturamento.definirObsNFCe(nfce);
        HelperObservacoesFaturamento.definirObsItens(nfce);
    }

    private static void definirObsItens(NFCe nfce) throws ExceptionAvaliadorExpressoes, ExceptionInvalidData {
        for (NFCeItem item : nfce.getItens()) {
            LinkedList<ObsFaturamento> obsModContrib = new LinkedList<ObsFaturamento>();
            HelperObservacoesFaturamento.addObsMod(obsModContrib, item.getModeloFiscal(), EnumConstModeloFiscalObs.TIPO_OBS_PRODUTO, item);
            HelperObservacoesFaturamento.addObsModFisco(obsModContrib, item.getModeloFiscal(), EnumConstModeloFiscalObs.TIPO_OBS_PRODUTO);
            StringBuilder sb = new StringBuilder();
            for (ObsFaturamento o : obsModContrib) {
                sb.append(HelperObservacoesFaturamento.buildOBS(o, item));
            }
            if (sb.length() > 0) {
                item.setInfAdicionalProd(sb.toString());
                continue;
            }
            item.setInfAdicionalProd(null);
        }
    }

    private static void definirObsNFCe(NFCe nfce) throws ExceptionAvaliadorExpressoes, ExceptionInvalidData {
        LinkedList<ObsFaturamento> obsModContrib = new LinkedList<ObsFaturamento>();
        List<NFCeObsContrib> obsNF = nfce.getObsContribuinte();
        Object all = "";
        for (NFCeItem item : nfce.getItens()) {
            HelperObservacoesFaturamento.addObsMod(obsModContrib, item.getModeloFiscal(), EnumConstModeloFiscalObs.TIPO_OBS_MODELO, item);
        }
        for (ObsFaturamento ob : obsModContrib) {
            NFCeObsContrib bo;
            Optional<NFCeObsContrib> found = obsNF.stream().filter(i -> ToolMethods.isEquals((Object)i.getObsFaturamento(), (Object)ob)).findFirst();
            if (!found.isPresent()) {
                bo = new NFCeObsContrib();
                obsNF.add(bo);
            } else {
                bo = found.get();
            }
            bo.setObsFaturamento(ob);
            bo.setNfce(nfce);
            bo.setConteudo(HelperObservacoesFaturamento.buildOBS(ob, nfce));
            all = (String)all + bo.getConteudo();
        }
        LinkedList obsModFisco = new LinkedList();
        List<NFCeObsFisco> obsNFFisco = nfce.getObsFisco();
        nfce.getItens().forEach(i -> HelperObservacoesFaturamento.addObsModFisco(obsModFisco, i.getModeloFiscal(), EnumConstModeloFiscalObs.TIPO_OBS_MODELO));
        for (ObsFaturamento ob : obsModFisco) {
            NFCeObsFisco bo;
            Optional<NFCeObsFisco> found = obsNFFisco.stream().filter(i -> ToolMethods.isEquals((Object)i.getObsFaturamento(), (Object)ob)).findFirst();
            if (!found.isPresent()) {
                bo = new NFCeObsFisco();
                obsNFFisco.add(bo);
            } else {
                bo = found.get();
            }
            bo.setObsFaturamento(ob);
            bo.setNfce(nfce);
            bo.setConteudo(HelperObservacoesFaturamento.buildOBS(ob, nfce));
        }
    }

    private static void addObsModFisco(List<ObsFaturamento> obsModFisco, ModeloFiscal modeloFiscal, EnumConstModeloFiscalObs tipoObs) {
        if (modeloFiscal == null) {
            return;
        }
        for (ModeloFiscalObsFisco ob : modeloFiscal.getObsFisco()) {
            if (!ToolMethods.isEquals((Object)ob.getAtivo(), (Object)1) || !ToolMethods.isEquals((Object)ob.getUsarNFCe(), (Object)1) || !ToolMethods.isEquals((Object)ob.getTipoObservacao(), (Object)tipoObs.getValue()) || ob.getObsFaturamento().getObservacaoDinamica() == null || obsModFisco.contains(ob)) continue;
            obsModFisco.add(ob.getObsFaturamento());
        }
    }

    private static void addObsMod(List<ObsFaturamento> obsModContrib, ModeloFiscal modeloFiscal, EnumConstModeloFiscalObs tipoObs, NFCeItem item) throws ExceptionAvaliadorExpressoes, ExceptionInvalidData {
        if (modeloFiscal == null) {
            return;
        }
        for (ModeloFiscalObsContrib ob : modeloFiscal.getObsContribuinte()) {
            if (!ToolMethods.isEquals((Object)ob.getAtivo(), (Object)1) || !ToolMethods.isEquals((Object)ob.getUsarNFCe(), (Object)1) || !ToolMethods.isEquals((Object)ob.getTipoObservacao(), (Object)tipoObs.getValue()) || ob.getObsFaturamento().getObservacaoDinamica() == null || obsModContrib.contains(ob) || !HelperObservacoesFaturamento.isAddObsCondicaoObs(ob.getObsFaturamento().getObservacaoDinamica(), item)) continue;
            obsModContrib.add(ob.getObsFaturamento());
        }
    }

    public static String buildOBS(ObsFaturamento obsFat, NFCe nfce) {
        HelperSubOSFinderImpl helper = new HelperSubOSFinderImpl();
        String obs = obsFat.getObservacao();
        if (obsFat.getObservacaoDinamica() != null) {
            try {
                obs = ToolTextDynamic.build((Object)nfce, (String)obsFat.getObservacaoDinamica().getObservacao(), (ToolTextDynamic.HelperSubOSFinder)helper);
            }
            catch (Exception ex) {
                ex.printStackTrace();
                throw new RuntimeException("Erro ao construir a observacao (ID OBS: " + obsFat.getIdentificador() + "): " + obsFat.getObservacaoDinamica().getObservacao() + "\n" + ex.getMessage());
            }
        }
        return ToolString.clearSpecialCharacXML((String)obs);
    }

    private static String buildOBS(ObsFaturamento obsFat, NFCeItem nfCeItem) {
        HelperSubOSFinderImpl helper = new HelperSubOSFinderImpl();
        String obs = obsFat.getObservacao();
        if (obsFat.getObservacaoDinamica() != null) {
            try {
                obs = ToolTextDynamic.build((Object)nfCeItem, (String)obsFat.getObservacaoDinamica().getObservacao(), (ToolTextDynamic.HelperSubOSFinder)helper);
            }
            catch (Exception ex) {
                ex.printStackTrace();
                throw new RuntimeException(ex.getMessage());
            }
        }
        return ToolString.clearSpecialCharacXML((String)obs);
    }

    private static boolean isAddObsCondicaoObs(ObjectObsDinamica obsFaturamento, Object item) throws ExceptionAvaliadorExpressoes, ExceptionInvalidData {
        if (obsFaturamento == null) {
            return true;
        }
        if (!ToolMethods.isStrWithData((String)obsFaturamento.getCondicaoAplicacao())) {
            return true;
        }
        return ToolTextDynamic.isValidToAdd((String)obsFaturamento.getCondicaoAplicacao(), (Object)item);
    }

    private static class HelperSubOSFinderImpl
    implements ToolTextDynamic.HelperSubOSFinder {
        public String getSubOSText(Long id) {
            if (id == null) {
                return null;
            }
            ObjectObsDinamica obs = (ObjectObsDinamica)Main.getBean(ServiceObjectObsDinamica.class).get(id);
            return obs != null ? obs.getObservacao() : null;
        }

        public String getSubOSTextCond(Long id) {
            if (id == null) {
                return null;
            }
            ObjectObsDinamica obs = (ObjectObsDinamica)Main.getBean(ServiceObjectObsDinamica.class).get(id);
            return obs != null ? obs.getCondicaoAplicacao() : null;
        }
    }
}

