/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.touchnfce.utils;

import com.touchcomp.basementor.constants.enums.tipopagamentonfe.EnumConstTipoPagamentoNFe;
import com.touchcomp.basementortools.tools.methods.ToolMethods;
import com.touchcomp.touchnfce.StaticObjects;
import com.touchcomp.touchnfce.model.ClienteNFCeMeioPagamento;
import com.touchcomp.touchnfce.model.CondicoesPagamento;
import com.touchcomp.touchnfce.model.NFCeOpcoesCondPagamento;
import com.touchcomp.touchnfce.model.NFCeOpcoesValidMeioPagamento;
import com.touchcomp.touchnfce.model.TipoPagamentoNFe;
import com.touchcomp.touchnfce.model.UnidadeFatCliente;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;

public class UtilClienteCondicoesPagamento {
    private static List<TipoPagamentoNFe> getTiposPagCliente(UnidadeFatCliente u) {
        ArrayList<TipoPagamentoNFe> tiposPagamentos = new ArrayList<TipoPagamentoNFe>();
        if (u == null) {
            return tiposPagamentos;
        }
        for (ClienteNFCeMeioPagamento m : u.getCliente().getClienteNFCeMeioPagamento()) {
            if (!ToolMethods.isEquals((Object)m.getAtivo(), (Object)1)) continue;
            tiposPagamentos.add(m.getTipoPagamentoNFe());
        }
        return tiposPagamentos;
    }

    private static List<TipoPagamentoNFe> getTiposPagOpcoes() {
        ArrayList<TipoPagamentoNFe> tiposPagamentos = new ArrayList<TipoPagamentoNFe>();
        ArrayList lista = new ArrayList();
        for (NFCeOpcoesCondPagamento cond : StaticObjects.getOpcoes().getCondicoesPagamento()) {
            if (!ToolMethods.isEquals((Object)cond.getAtivo(), (Object)1)) continue;
            tiposPagamentos.add(cond.getCondicoesPagamento().getMeioPagamento().getTipoPagamentoNFe());
        }
        return tiposPagamentos;
    }

    public static List<TipoPagamentoNFe> getTiposPagamento(UnidadeFatCliente u) {
        LinkedHashSet<TipoPagamentoNFe> tiposPagamentosCliente = new LinkedHashSet<TipoPagamentoNFe>();
        for (CondicoesPagamento c : UtilClienteCondicoesPagamento.getCondicaoPagamento(u)) {
            if (c.getMeioPagamento() != null && ToolMethods.isEquals((Object)c.getMeioPagamento().getAtivo(), (Object)1)) {
                tiposPagamentosCliente.add(c.getMeioPagamento().getTipoPagamentoNFe());
                continue;
            }
            System.out.println("Tipo Meio nao adicionado: " + String.valueOf(c) + "/" + String.valueOf(c.getMeioPagamento()));
        }
        return new LinkedList<TipoPagamentoNFe>(tiposPagamentosCliente);
    }

    public static List<CondicoesPagamento> getCondicaoPagamento(UnidadeFatCliente unidadeFatCliente, TipoPagamentoNFe tipoPagamentoNFe) {
        List<CondicoesPagamento> condicoesPagamento = UtilClienteCondicoesPagamento.getCondicaoPagamento(unidadeFatCliente);
        LinkedHashSet<CondicoesPagamento> condicoes = new LinkedHashSet<CondicoesPagamento>();
        for (CondicoesPagamento c : condicoesPagamento) {
            if (c.getMeioPagamento() == null || c.getMeioPagamento().getTipoPagamentoNFe() == null || !ToolMethods.isEquals((Object)c.getMeioPagamento().getAtivo(), (Object)1) || !ToolMethods.isEquals((Object)c.getMeioPagamento().getTipoPagamentoNFe(), (Object)tipoPagamentoNFe)) continue;
            condicoes.add(c);
        }
        return new LinkedList<CondicoesPagamento>(condicoes);
    }

    public static List<CondicoesPagamento> getCondicaoPagamento(UnidadeFatCliente u) {
        List<TipoPagamentoNFe> tiposPagamentosCliente = UtilClienteCondicoesPagamento.getTiposPagCliente(u);
        List<NFCeOpcoesCondPagamento> condicoesPagamento = StaticObjects.getOpcoes().getCondicoesPagamento();
        LinkedHashSet<CondicoesPagamento> condicoesPagamentoFiltro = new LinkedHashSet<CondicoesPagamento>();
        if (tiposPagamentosCliente.size() > 0) {
            for (TipoPagamentoNFe cond : tiposPagamentosCliente) {
                for (NFCeOpcoesCondPagamento a : condicoesPagamento) {
                    if (a.getCondicoesPagamento().getMeioPagamento() == null || !ToolMethods.isEquals((Object)a.getCondicoesPagamento().getMeioPagamento().getTipoPagamentoNFe(), (Object)cond)) continue;
                    condicoesPagamentoFiltro.add(a.getCondicoesPagamento());
                }
            }
            for (NFCeOpcoesCondPagamento condPagEmp : condicoesPagamento) {
                if (!ToolMethods.isEquals((Object)condPagEmp.getCondicoesPagamento().getMeioPagamento().getTipoPagamentoNFe().getCodigo(), (Object)EnumConstTipoPagamentoNFe.DINHEIRO.getValue())) continue;
                condicoesPagamentoFiltro.add(condPagEmp.getCondicoesPagamento());
            }
            for (NFCeOpcoesCondPagamento condPagEmp : condicoesPagamento) {
                Optional<NFCeOpcoesValidMeioPagamento> aux = StaticObjects.getOpcoes().getMeiosPagamentoValid().stream().filter(i -> condPagEmp.getCondicoesPagamento().getMeioPagamento() != null && ToolMethods.isEquals((Object)i.getTipoPagamentoNFe(), (Object)condPagEmp.getCondicoesPagamento().getMeioPagamento().getTipoPagamentoNFe()) && ToolMethods.isEquals((Object)i.getAtivo(), (Object)1)).findFirst();
                if (aux.isPresent()) continue;
                condicoesPagamentoFiltro.add(condPagEmp.getCondicoesPagamento());
            }
            return new LinkedList<CondicoesPagamento>(condicoesPagamentoFiltro);
        }
        LinkedList<CondicoesPagamento> temp = new LinkedList<CondicoesPagamento>();
        condicoesPagamento.forEach(i -> {
            if (ToolMethods.isEquals((Object)i.getAtivo(), (Object)1)) {
                temp.add(i.getCondicoesPagamento());
            }
        });
        return temp;
    }

    public static List<CondicoesPagamento> getCondicaoPagamento(UnidadeFatCliente unidadeFatCliente, TipoPagamentoNFe tipoPagamentoNFe, Short numeroParcelas) {
        List<CondicoesPagamento> conds = UtilClienteCondicoesPagamento.getCondicaoPagamento(unidadeFatCliente, tipoPagamentoNFe);
        List<CondicoesPagamento> found = conds.stream().filter(i -> i.getNumeroParcelas() != null && ToolMethods.isEquals((Object)i.getNumeroParcelas().toString(), (Object)numeroParcelas.toString())).collect(Collectors.toList());
        if (found != null && found.size() > 0) {
            return found;
        }
        return conds;
    }
}

