/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.touchnfce.utils;

import com.touchcomp.basementortools.tools.date.TDate;
import com.touchcomp.basementortools.tools.string.TString;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;

public class UtilCronoanalise {
    private static Date lastDate;
    private static List<ItemLog> data;
    private static ItemLog last;

    public static void start() {
        if (lastDate == null) {
            lastDate = new Date();
            data = new LinkedList<ItemLog>();
        }
    }

    public static void endAndPrintAll() {
        UtilCronoanalise.endItemLog(last);
        UtilCronoanalise.printAll();
        UtilCronoanalise.end();
    }

    public static void end() {
        UtilCronoanalise.endItemLog(last);
        last = null;
        lastDate = null;
        data = new LinkedList<ItemLog>();
    }

    public static void addTask(String descricao) {
        UtilCronoanalise.start();
        UtilCronoanalise.endItemLog(last);
        last = UtilCronoanalise.newItemLog(descricao);
    }

    public static void printAll() {
        System.out.println("--------------------------------------------------");
        System.out.println("Dados analise:\n");
        for (ItemLog il : data) {
            System.out.println("Tempo: " + TString.completaZeros((String)String.valueOf(il.getMilisegundos()), (int)3) + " Tarefa: " + il.descricao + "\n");
        }
        System.out.println("--------------------------------------------------");
    }

    private static ItemLog newItemLog(String descricao) {
        ItemLog item = new ItemLog();
        item.setDataInicio(new Date());
        item.setDescricao(descricao);
        data.add(item);
        return item;
    }

    private static void endItemLog(ItemLog last) {
        if (last == null) {
            return;
        }
        last.setDataFim(new Date());
        last.setMilisegundos(TDate.difBetweenDatesInMiliseconds((Date)last.getDataInicio(), (Date)last.getDataFim()));
    }

    static {
        data = new LinkedList<ItemLog>();
    }

    public static class ItemLog {
        private Date dataInicio;
        private Date dataFim;
        private Long milisegundos;
        private String descricao;

        public Date getDataInicio() {
            return this.dataInicio;
        }

        public void setDataInicio(Date dataInicio) {
            this.dataInicio = dataInicio;
        }

        public Date getDataFim() {
            return this.dataFim;
        }

        public void setDataFim(Date dataFim) {
            this.dataFim = dataFim;
        }

        public String getDescricao() {
            return this.descricao;
        }

        public void setDescricao(String descricao) {
            this.descricao = descricao;
        }

        public Long getMilisegundos() {
            return this.milisegundos;
        }

        public void setMilisegundos(Long milisegundos) {
            this.milisegundos = milisegundos;
        }
    }
}

