/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.touchnfce.utils;

import com.touchcomp.basementor.constants.enums.nfe.EnumConstNFeTipoEmissao;
import com.touchcomp.touchnfce.Main;
import com.touchcomp.touchnfce.StaticObjects;
import com.touchcomp.touchnfce.model.NFCe;
import com.touchcomp.touchnfce.model.NFCeCaixa;
import com.touchcomp.touchnfce.model.NFCePeriodoEmissao;
import com.touchcomp.touchnfce.model.PeriodoEmissaoNFe;
import com.touchcomp.touchnfce.model.TipoEmissaoNFe;
import com.touchcomp.touchnfce.service.impl.ServiceNFCePeriodoEmissao;
import com.touchcomp.touchnfce.service.impl.ServicePeriodoEmissaoNFe;
import com.touchcomp.touchnfce.service.impl.ServiceTipoEmissaoNFe;
import com.touchcomp.touchnfce.utils.UtilNFCeSerial;
import java.util.Date;
import javafx.application.Platform;

public class UtilPeriodoEmissao {
    public static NFCePeriodoEmissao getCurrentNFCe(NFCeCaixa nfCeCaixa) {
        ServiceNFCePeriodoEmissao service = Main.getBean(ServiceNFCePeriodoEmissao.class);
        NFCePeriodoEmissao periodoEmissao = service.getUltimoPeriodoEmissaoNFCe(nfCeCaixa);
        if (periodoEmissao == null) {
            periodoEmissao = UtilPeriodoEmissao.getNewPeriodoNFCe(nfCeCaixa, EnumConstNFeTipoEmissao.NORMAL);
            periodoEmissao = UtilPeriodoEmissao.savePeriodoEmissaoNFCe(periodoEmissao);
        }
        return periodoEmissao;
    }

    public static PeriodoEmissaoNFe getCurrentNFe(NFCeCaixa nfCeCaixa) {
        ServicePeriodoEmissaoNFe service = Main.getBean(ServicePeriodoEmissaoNFe.class);
        PeriodoEmissaoNFe periodoEmissao = service.getUltimoPeriodoEmissaoNFe(nfCeCaixa);
        if (periodoEmissao == null) {
            periodoEmissao = UtilPeriodoEmissao.getNewPeriodoNFe(nfCeCaixa, EnumConstNFeTipoEmissao.NORMAL);
            periodoEmissao = UtilPeriodoEmissao.savePeriodoEmissaoNFe(periodoEmissao);
        }
        return periodoEmissao;
    }

    public static NFCePeriodoEmissao criarPeriodoNFCe(NFCeCaixa nfCeCaixa, TipoEmissaoNFe tipoEmissaoNFe) {
        NFCePeriodoEmissao periodoEmissao = null;
        if (periodoEmissao == null) {
            EnumConstNFeTipoEmissao tp = EnumConstNFeTipoEmissao.valueOfCodigo((int)tipoEmissaoNFe.getCodigo().intValue());
            periodoEmissao = UtilPeriodoEmissao.getNewPeriodoNFCe(nfCeCaixa, tp);
            periodoEmissao = UtilPeriodoEmissao.savePeriodoEmissaoNFCe(periodoEmissao);
        }
        return periodoEmissao;
    }

    public static PeriodoEmissaoNFe criarPeriodoNFe(NFCeCaixa nfCeCaixa, TipoEmissaoNFe tipoEmissaoNFe) {
        PeriodoEmissaoNFe periodoEmissao = null;
        if (periodoEmissao == null) {
            EnumConstNFeTipoEmissao tp = EnumConstNFeTipoEmissao.valueOfCodigo((int)tipoEmissaoNFe.getCodigo().intValue());
            periodoEmissao = UtilPeriodoEmissao.getNewPeriodoNFe(nfCeCaixa, tp);
            periodoEmissao = UtilPeriodoEmissao.savePeriodoEmissaoNFe(periodoEmissao);
        }
        return periodoEmissao;
    }

    public static NFCePeriodoEmissao savePeriodoEmissaoNFCe(NFCePeriodoEmissao periodoEmissao) {
        ServiceNFCePeriodoEmissao service = Main.getBean(ServiceNFCePeriodoEmissao.class);
        return service.save(periodoEmissao);
    }

    public static PeriodoEmissaoNFe savePeriodoEmissaoNFe(PeriodoEmissaoNFe periodoEmissao) {
        ServicePeriodoEmissaoNFe service = Main.getBean(ServicePeriodoEmissaoNFe.class);
        return service.save(periodoEmissao);
    }

    private static NFCePeriodoEmissao getNewPeriodoNFCe(NFCeCaixa nfCeCaixa, EnumConstNFeTipoEmissao tp) {
        NFCePeriodoEmissao periodoEmissao = new NFCePeriodoEmissao();
        periodoEmissao.setDataCadastro(new Date());
        periodoEmissao.setDataInicial(new Date());
        periodoEmissao.setDescricao(tp.getDescricao());
        periodoEmissao.setNfCeCaixa(nfCeCaixa);
        periodoEmissao.setTipoEmissaoNfe(UtilPeriodoEmissao.getTipoEmissao(tp));
        periodoEmissao.setSerialForSinc(UtilNFCeSerial.getSerial(nfCeCaixa));
        return periodoEmissao;
    }

    private static PeriodoEmissaoNFe getNewPeriodoNFe(NFCeCaixa nfCeCaixa, EnumConstNFeTipoEmissao tp) {
        PeriodoEmissaoNFe periodoEmissao = new PeriodoEmissaoNFe();
        periodoEmissao.setDataCadastro(new Date());
        periodoEmissao.setDataInicial(new Date());
        periodoEmissao.setDescricao(tp.getDescricao());
        periodoEmissao.setNfceCaixa(nfCeCaixa);
        periodoEmissao.setTipoEmissaoNfe(UtilPeriodoEmissao.getTipoEmissao(tp));
        periodoEmissao.setSerialForSinc(UtilNFCeSerial.getSerial(nfCeCaixa));
        periodoEmissao.setOrigemNFCe((short)1);
        periodoEmissao.setEmpresa(StaticObjects.getEmpresa());
        return periodoEmissao;
    }

    public static NFCePeriodoEmissao checarAlterarParaContigencia(NFCe nfCe) {
        NFCePeriodoEmissao periodoEmissao = nfCe.getPeriodoEmissaoNFCe();
        TipoEmissaoNFe tpEmissao = periodoEmissao.getTipoEmissaoNfe();
        if (tpEmissao.getCodigo() != 9) {
            periodoEmissao = StaticObjects.getNFCePeriodoEmissao();
            tpEmissao = periodoEmissao.getTipoEmissaoNfe();
        }
        if (tpEmissao.getCodigo() != 9) {
            periodoEmissao = UtilPeriodoEmissao.getNewPeriodoNFCe(nfCe.getNfCeCaixa(), EnumConstNFeTipoEmissao.CONTIGENCIA_OFFLINE);
            periodoEmissao.setDescricao("Devido a problemas tecnicos, o periodo foi modificado automaticamente para Contigencia.");
            periodoEmissao = UtilPeriodoEmissao.savePeriodoEmissaoNFCe(periodoEmissao);
            StaticObjects.setPeriodoEmissaoNFCe(periodoEmissao);
            Platform.runLater((Runnable)new Runnable(){

                @Override
                public void run() {
                    Main.get().getFooterController().atualizaPeriodoEmissaoNFCe();
                }
            });
        }
        return periodoEmissao;
    }

    private static TipoEmissaoNFe getTipoEmissao(EnumConstNFeTipoEmissao tipoEmissao) {
        ServiceTipoEmissaoNFe tp = Main.getBean(ServiceTipoEmissaoNFe.class);
        return tp.findByCodigo(tipoEmissao);
    }
}

