/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.touchnfce.utils.abastecimentocompanytec;

import com.touchcomp.basementorexceptions.exceptions.impl.jasperreports.ExceptionJasperReports;
import com.touchcomp.basementorexceptions.exceptions.impl.print.ExceptionPrint;
import com.touchcomp.basementorlogger.TLogger;
import com.touchcomp.basementortools.constants.EnumConstantsStatus;
import com.touchcomp.basementortools.tools.formatter.ToolFormatter;
import com.touchcomp.basementortools.tools.methods.ToolMethods;
import com.touchcomp.basementortools.tools.string.ToolString;
import com.touchcomp.basenativeequipments.comunicadorpostoscombustiveis.ComunicadorResposta;
import com.touchcomp.basenativeequipments.comunicadorpostoscombustiveis.companytec.ComunicadorCompanytec;
import com.touchcomp.basenativeequipments.comunicadorpostoscombustiveis.companytec.constants.ConstEnumEquipamentos;
import com.touchcomp.basenativeequipments.comunicadorpostoscombustiveis.companytec.constants.ConstEnumModoLeitura;
import com.touchcomp.basenativeequipments.comunicadorpostoscombustiveis.companytec.constants.ConstEnumModos;
import com.touchcomp.basenativeequipments.comunicadorpostoscombustiveis.companytec.constants.ConstEnumTipoPreco;
import com.touchcomp.basenativeequipments.comunicadorpostoscombustiveis.companytec.model.ComunicadorTipoEquipamento;
import com.touchcomp.basenativeequipments.comunicadorpostoscombustiveis.companytec.model.LeituraAbastecimento;
import com.touchcomp.basenativeequipments.comunicadorpostoscombustiveis.companytec.model.LeituraAbastecimentoByRegistro;
import com.touchcomp.basenativeequipments.comunicadorpostoscombustiveis.companytec.model.LeituraAbastecimentoSimples;
import com.touchcomp.basenativeequipments.comunicadorpostoscombustiveis.companytec.model.LeituraStatusBombas;
import com.touchcomp.touchnfce.Main;
import com.touchcomp.touchnfce.StaticObjects;
import com.touchcomp.touchnfce.controller.Alerts;
import com.touchcomp.touchnfce.exceptions.ExceptionAutomacaoPosto;
import com.touchcomp.touchnfce.model.BicoBombaCombustivel;
import com.touchcomp.touchnfce.model.BombaCombustivel;
import com.touchcomp.touchnfce.model.NFCe;
import com.touchcomp.touchnfce.model.NFCeAfericaoPreAbastecimento;
import com.touchcomp.touchnfce.model.NFCeControleCaixa;
import com.touchcomp.touchnfce.model.NFCeEncerranteAbastecimento;
import com.touchcomp.touchnfce.model.NFCeGerenMaqAbastecimento;
import com.touchcomp.touchnfce.model.NFCeItem;
import com.touchcomp.touchnfce.model.NFCePreAbastecimento;
import com.touchcomp.touchnfce.print.impl.PrintAfericaoAbastecimento;
import com.touchcomp.touchnfce.service.impl.ServiceBicoBombaCombustivel;
import com.touchcomp.touchnfce.service.impl.ServiceBombaCombustivel;
import com.touchcomp.touchnfce.service.impl.ServiceNFCeAfericaoPreAbastecimento;
import com.touchcomp.touchnfce.service.impl.ServiceNFCeEncerranteAbastecimento;
import com.touchcomp.touchnfce.utils.UtilAbastecimento;
import com.touchcomp.touchnfce.utils.UtilNFCe;
import com.touchcomp.touchnfce.utils.UtilNFCeSerial;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javafx.application.Platform;

public class UtilCentralAbastecimento {
    private static final long SLEEP_TIME = 250L;
    private static final long MAX_SLEEP_TIME = 15000L;
    public static final String RETORNO_VAZIO = "0";
    public static final String RETORNO_ERRO = "-1";
    private ComunicadorCompanytec comunicador = null;
    public boolean socketLiberado = false;
    public boolean itemNTAbastCanc = false;
    private static UtilCentralAbastecimento instance;

    private UtilCentralAbastecimento() {
    }

    public static UtilCentralAbastecimento get() {
        if (instance == null) {
            instance = new UtilCentralAbastecimento();
        }
        return instance;
    }

    public boolean isConnectedSocketAutomacao() {
        if (this.comunicador == null) {
            System.out.println("Nao esta conectado na automacao.");
            return false;
        }
        return this.comunicador.isConnected();
    }

    public synchronized void checkAndConectAutomacao() throws ExceptionAutomacaoPosto {
        try {
            int count = 0;
            while (!this.comunicador.isConnected()) {
                if (count > 0) {
                    this.sleep(5000L);
                }
                try {
                    this.connectSocketAutomacao();
                }
                catch (Throwable ex) {
                    TLogger.get(this.getClass()).error(ex);
                }
                if (++count == 3) {
                    throw new ExceptionAutomacaoPosto("Nao foi possivel conectar na Automacao. Foram realizadas 3 tentativas: " + this.comunicador.getHost() + ":" + this.comunicador.getPort());
                }
                if (count < 3) continue;
                break;
            }
        }
        catch (Exception ex) {
            TLogger.get(this.getClass()).error((Throwable)ex);
            throw new ExceptionAutomacaoPosto("Ocorreu um erro ao comunicar com a Automa\u00e7\u00e3o: " + ex.getMessage(), ex);
        }
    }

    public synchronized void connectSocketAutomacao() throws Throwable {
        try {
            if (this.comunicador != null && this.comunicador.isConnected()) {
                return;
            }
            if (this.comunicador != null) {
                try {
                    this.comunicador.disconnect();
                }
                catch (Throwable ex) {
                    TLogger.get(this.getClass()).error(ex);
                }
            }
            this.comunicador = new ComunicadorCompanytec(new ComunicadorTipoEquipamento(ConstEnumEquipamentos.get((Object)StaticObjects.getOpcoes().getTipoAutomacaoPosto().getCodigo())));
            System.out.println("Conectando automacao: " + StaticObjects.getOpcoes().getHostAutomacao() + " - " + StaticObjects.getOpcoes().getPortAutomacao());
            this.comunicador.connect(StaticObjects.getOpcoes().getHostAutomacao(), StaticObjects.getOpcoes().getPortAutomacao().intValue());
        }
        catch (Throwable ex) {
            TLogger.get(this.getClass()).error(ex);
            throw ex;
        }
        finally {
            this.freeSocket();
        }
    }

    public ComunicadorResposta alterarRelogioModoNormal(Date newDate) throws Exception {
        try {
            this.checkAndConectAutomacao();
            this.waitForSocketAndBlock();
            ComunicadorResposta comunicadorResposta = this.comunicador.ajustaRelogio(newDate);
            return comunicadorResposta;
        }
        catch (Exception ex) {
            TLogger.get(this.getClass()).error((Throwable)ex);
            throw ex;
        }
        finally {
            this.freeSocket();
        }
    }

    public ComunicadorResposta alterarRelogioModoExtendido(Date newDate) throws Exception {
        try {
            this.checkAndConectAutomacao();
            this.waitForSocketAndBlock();
            ComunicadorResposta comunicadorResposta = this.comunicador.ajustaRelogioExtendido(newDate);
            return comunicadorResposta;
        }
        catch (Exception ex) {
            TLogger.get(this.getClass()).error((Throwable)ex);
            throw ex;
        }
        finally {
            this.freeSocket();
        }
    }

    public ComunicadorResposta<LeituraStatusBombas> getStatuAtualBombas() throws Exception {
        try {
            this.checkAndConectAutomacao();
            this.waitForSocketAndBlock();
            ComunicadorResposta ret = this.comunicador.comandoStatusBomba();
            System.out.println("\n\nStatus Bombas/Retorno: ");
            System.out.println("Status: " + String.valueOf(ret.getStatus()));
            System.out.println("Comando: " + ret.getCommando());
            System.out.println("Mensagem: " + ret.getMensagem());
            System.out.println("Dados: " + ret.getDados());
            System.out.println("Retorno: " + ret.getRetorno());
            System.out.println("\n\nStatus Bombas/Retorno: ");
            for (LeituraStatusBombas.StatusBico s : ((LeituraStatusBombas)ret.getResultado()).getStatusBicos()) {
                System.out.println("Status BICO: " + s.getNrSeqBico() + " Status: " + String.valueOf(s.getStatus()));
            }
            ComunicadorResposta comunicadorResposta = ret;
            return comunicadorResposta;
        }
        catch (Exception ex) {
            TLogger.get(this.getClass()).error((Throwable)ex);
            throw ex;
        }
        finally {
            this.freeSocket();
        }
    }

    public ComunicadorResposta alterarPrecoCombustivel(BicoBombaCombustivel bico, ConstEnumTipoPreco forma, Double preco) throws Exception {
        try {
            this.checkAndConectAutomacao();
            this.waitForSocketAndBlock();
            ComunicadorResposta comunicadorResposta = this.comunicador.alterarPreco(bico.getCodigoAutomacao(), forma, preco);
            return comunicadorResposta;
        }
        catch (Exception ex) {
            TLogger.get(this.getClass()).error((Throwable)ex);
            throw ex;
        }
        finally {
            this.freeSocket();
        }
    }

    public ComunicadorResposta autorizarAbastecimentoUnico(BicoBombaCombustivel bico) throws Exception {
        try {
            this.checkAndConectAutomacao();
            this.waitForSocketAndBlock();
            ComunicadorResposta comunicadorResposta = this.comunicador.comandoModoBomba(bico.getCodigoAutomacao(), ConstEnumModos.AUTORIZAR_BOMBA_ABASTECIMENTO_UNICO);
            return comunicadorResposta;
        }
        catch (Exception ex) {
            TLogger.get(this.getClass()).error((Throwable)ex);
            throw ex;
        }
        finally {
            this.freeSocket();
        }
    }

    public ComunicadorResposta bloqueiaBombaAbastecimento(BicoBombaCombustivel bico) throws Exception {
        ComunicadorResposta ret = new ComunicadorResposta(EnumConstantsStatus.ERRO, RETORNO_ERRO, RETORNO_ERRO, RETORNO_ERRO);
        try {
            this.checkAndConectAutomacao();
            this.waitForSocketAndBlock();
            this.setSocketLiberado(Boolean.FALSE);
            ComunicadorResposta comunicadorResposta = this.comunicador.comandoModoBomba(bico.getCodigoAutomacao(), ConstEnumModos.BLOQUEIA_BOMBA_ABASTECIMENTOS);
            return comunicadorResposta;
        }
        catch (Exception ex) {
            TLogger.get(this.getClass()).error((Throwable)ex);
            throw ex;
        }
        finally {
            this.freeSocket();
        }
    }

    public ComunicadorResposta pararAbastaecimento(BicoBombaCombustivel bico) throws Exception {
        try {
            this.checkAndConectAutomacao();
            this.waitForSocketAndBlock();
            this.setSocketLiberado(Boolean.FALSE);
            ComunicadorResposta comunicadorResposta = this.comunicador.comandoModoBomba(bico.getCodigoAutomacao(), ConstEnumModos.PARAR_ABASTECIMENTO);
            return comunicadorResposta;
        }
        catch (Exception ex) {
            TLogger.get(this.getClass()).error((Throwable)ex);
            throw ex;
        }
        finally {
            this.freeSocket();
        }
    }

    public ComunicadorResposta pausaAbastecimento(BicoBombaCombustivel bico) throws Exception {
        try {
            this.checkAndConectAutomacao();
            this.waitForSocketAndBlock();
            this.setSocketLiberado(Boolean.FALSE);
            ComunicadorResposta comunicadorResposta = this.comunicador.comandoModoBomba(bico.getCodigoAutomacao(), ConstEnumModos.PAUSA_ABASTECIMENTO);
            return comunicadorResposta;
        }
        catch (Exception ex) {
            TLogger.get(this.getClass()).error((Throwable)ex);
            throw ex;
        }
        finally {
            this.freeSocket();
        }
    }

    public ComunicadorResposta liberarBombaAbastecimento(BicoBombaCombustivel bico) throws Exception {
        try {
            this.checkAndConectAutomacao();
            this.waitForSocketAndBlock();
            this.setSocketLiberado(Boolean.FALSE);
            ComunicadorResposta comunicadorResposta = this.comunicador.comandoModoBomba(bico.getCodigoAutomacao(), ConstEnumModos.LIBERA_BOMBA_ABASTECIMENTOS);
            return comunicadorResposta;
        }
        catch (Exception ex) {
            TLogger.get(this.getClass()).error((Throwable)ex);
            throw ex;
        }
        finally {
            this.freeSocket();
        }
    }

    public ComunicadorResposta<LeituraAbastecimento> leituraAbastecimento() throws Exception {
        try {
            this.checkAndConectAutomacao();
            this.waitForSocketAndBlock();
            this.setSocketLiberado(Boolean.FALSE);
            ComunicadorResposta comunicadorResposta = this.comunicador.comandoAbastecimento52();
            return comunicadorResposta;
        }
        catch (Exception ex) {
            TLogger.get(this.getClass()).error((Throwable)ex);
            throw ex;
        }
        finally {
            this.freeSocket();
        }
    }

    public ComunicadorResposta incrementarPonteiroAbastecimento() throws Exception {
        try {
            this.checkAndConectAutomacao();
            this.waitForSocketAndBlock();
            this.setSocketLiberado(Boolean.FALSE);
            ComunicadorResposta comunicadorResposta = this.comunicador.incrementarAbastecimento();
            return comunicadorResposta;
        }
        catch (Exception ex) {
            TLogger.get(this.getClass()).error((Throwable)ex);
            throw ex;
        }
        finally {
            this.freeSocket();
        }
    }

    public Double leituraTotaisEncerrantesByValor(BicoBombaCombustivel bico) throws Exception {
        try {
            this.checkAndConectAutomacao();
            this.waitForSocketAndBlock();
            this.setSocketLiberado(Boolean.FALSE);
            Double d = (Double)this.comunicador.leituraTotaisEncerrantes(bico.getCodigoAutomacao(), ConstEnumModoLeitura.VALOR).getResultado();
            return d;
        }
        catch (Exception ex) {
            TLogger.get(this.getClass()).error((Throwable)ex);
            throw ex;
        }
        finally {
            this.freeSocket();
        }
    }

    public Double leituraTotaisEncerrantesByLitros(BicoBombaCombustivel bico) throws Exception {
        try {
            this.checkAndConectAutomacao();
            this.waitForSocketAndBlock();
            this.setSocketLiberado(Boolean.FALSE);
            Double d = (Double)this.comunicador.leituraTotaisEncerrantes(bico.getCodigoAutomacao(), ConstEnumModoLeitura.LITROS).getResultado();
            return d;
        }
        catch (Exception ex) {
            TLogger.get(this.getClass()).error((Throwable)ex);
            throw ex;
        }
        finally {
            this.freeSocket();
        }
    }

    public ComunicadorResposta<List<LeituraAbastecimentoSimples>> leituraAbastecimentoAndamento() throws Exception {
        try {
            this.checkAndConectAutomacao();
            this.waitForSocketAndBlock();
            this.setSocketLiberado(Boolean.FALSE);
            ComunicadorResposta ret = this.comunicador.comandoVisualizacaoAbastecimentoAndamento();
            StringBuilder str = new StringBuilder();
            for (LeituraAbastecimentoSimples l : (List)ret.getResultado()) {
                str.append("Bico: ").append(l.getCodBico()).append(" Total a pagar: ").append(ToolFormatter.formataNumero((Number)l.getTotalAPagar(), (int)2)).append(" \n");
            }
            if (str.length() == 0) {
                str.append("Nenhum abastecimento em andamento!");
            }
            Platform.runLater(() -> Alerts.showAlertInfo(str.toString()));
            ComunicadorResposta comunicadorResposta = ret;
            return comunicadorResposta;
        }
        catch (Exception ex) {
            TLogger.get(this.getClass()).error((Throwable)ex);
            throw ex;
        }
        finally {
            this.freeSocket();
        }
    }

    public BicoBombaCombustivel getBicoBomba(String codBico) {
        ServiceBicoBombaCombustivel service = Main.getBean(ServiceBicoBombaCombustivel.class);
        return service.findBicoBombaByCodigo(codBico, (short)1);
    }

    public List<ComunicadorResposta> bloqueiaAllBombaAbastecimento() throws Exception {
        ArrayList<ComunicadorResposta> listRet = new ArrayList<ComunicadorResposta>();
        try {
            this.checkAndConectAutomacao();
            this.waitForSocketAndBlock();
            this.setSocketLiberado(Boolean.FALSE);
            List<BombaCombustivel> listBombas = this.getAllBombasCombustivel();
            for (BombaCombustivel bc : listBombas) {
                for (BicoBombaCombustivel b : bc.getBicos()) {
                    ComunicadorResposta ret = this.comunicador.comandoModoBomba(b.getCodigoAutomacao(), ConstEnumModos.BLOQUEIA_BOMBA_ABASTECIMENTOS);
                    listRet.add(ret);
                }
            }
            ArrayList<ComunicadorResposta> arrayList = listRet;
            return arrayList;
        }
        catch (Exception ex) {
            TLogger.get(this.getClass()).error((Throwable)ex);
            throw ex;
        }
        finally {
            this.freeSocket();
        }
    }

    public List<ComunicadorResposta> liberarAllBombaAbastecimento() throws Exception {
        ArrayList<ComunicadorResposta> listRet = new ArrayList<ComunicadorResposta>();
        try {
            this.checkAndConectAutomacao();
            this.waitForSocketAndBlock();
            this.setSocketLiberado(Boolean.FALSE);
            List<BombaCombustivel> listBombas = this.getAllBombasCombustivel();
            for (BombaCombustivel bc : listBombas) {
                for (BicoBombaCombustivel b : bc.getBicos()) {
                    ComunicadorResposta ret = this.comunicador.comandoModoBomba(b.getCodigoAutomacao(), ConstEnumModos.LIBERA_BOMBA_ABASTECIMENTOS);
                    listRet.add(ret);
                }
            }
            ArrayList<ComunicadorResposta> arrayList = listRet;
            return arrayList;
        }
        catch (Exception ex) {
            TLogger.get(this.getClass()).error((Throwable)ex);
            throw ex;
        }
        finally {
            this.freeSocket();
        }
    }

    public List<BombaCombustivel> getAllBombasCombustivel() {
        ArrayList<BombaCombustivel> aux = new ArrayList<BombaCombustivel>();
        ServiceBombaCombustivel service = Main.getBean(ServiceBombaCombustivel.class);
        List result = service.getAll();
        if (result != null && !result.isEmpty()) {
            for (BombaCombustivel b : result) {
                if (b.getAtivo() == null || b.getAtivo() != 1) continue;
                aux.add(b);
            }
        }
        return aux;
    }

    public void disconnectSocketAutomacao() throws Exception {
        try {
            if (!this.isConnectedSocketAutomacao()) {
                return;
            }
            this.waitForSocketAndBlock();
            this.setSocketLiberado(Boolean.FALSE);
            this.comunicador.disconnect();
        }
        catch (Exception ex) {
            TLogger.get(this.getClass()).error((Throwable)ex);
            throw ex;
        }
        finally {
            this.freeSocket();
        }
    }

    public void createAndSaveEncerranteAbastecimento(NFCeControleCaixa cx, short status) throws Throwable {
        List<BombaCombustivel> listBombas = this.getAllBombasCombustivel();
        if (listBombas == null || listBombas.isEmpty()) {
            return;
        }
        this.connectSocketAutomacao();
        ArrayList<NFCeEncerranteAbastecimento> listEncerrantes = new ArrayList<NFCeEncerranteAbastecimento>();
        for (BombaCombustivel lb : listBombas) {
            for (BicoBombaCombustivel bc : lb.getBicos()) {
                if (bc.getAtivo() == null || !bc.getAtivo().equals((short)1)) continue;
                NFCeEncerranteAbastecimento encerramento = new NFCeEncerranteAbastecimento();
                Double valor = this.leituraTotaisEncerrantesByValor(bc);
                Double litros = this.leituraTotaisEncerrantesByLitros(bc);
                if (valor == null) {
                    valor = 0.0;
                }
                if (litros == null) {
                    litros = 0.0;
                }
                Double ajustado = this.ajustaEncerramente(litros, bc);
                encerramento.setBico(bc);
                encerramento.setSerialForSinc(UtilNFCeSerial.getSerial(StaticObjects.getNFCeCaixa()));
                encerramento.setControleCaixa(cx);
                encerramento.setQuantidade(ajustado);
                encerramento.setQuantidadeOrigAuto(litros);
                encerramento.setValor(valor);
                encerramento.setStatus(status);
                encerramento.setDataEncerramento(new Date());
                listEncerrantes.add(encerramento);
            }
        }
        if (!listEncerrantes.isEmpty()) {
            ServiceNFCeEncerranteAbastecimento serviceEncerrante = Main.getBean(ServiceNFCeEncerranteAbastecimento.class);
            serviceEncerrante.saveAll(listEncerrantes);
        }
        this.disconnectSocketAutomacao();
    }

    private Double ajustaEncerramente(Double litros, BicoBombaCombustivel bc) {
        NFCeEncerranteAbastecimento ultimo = Main.getBean(ServiceNFCeEncerranteAbastecimento.class).getUltimoEncerrante(bc);
        Double ultEncerrante = 0.0;
        if (ultimo != null) {
            ultEncerrante = ultimo.getQuantidade();
        }
        return UtilAbastecimento.calcAjustaEncerrante(litros, ultEncerrante, bc.getBombaCombustivel().getMedicaoInicial(), bc);
    }

    public List<NFCeEncerranteAbastecimento> getEncerranteAbastecimentoByControleCaixa(NFCeControleCaixa cx, short status) {
        ServiceNFCeEncerranteAbastecimento serviceEncerrante = Main.getBean(ServiceNFCeEncerranteAbastecimento.class);
        return serviceEncerrante.getEncerrantesAbastecimentoByControleCaixa(cx, status);
    }

    public List<NFCeEncerranteAbastecimento> getEncerranteAfericaoByControleCaixa(NFCeControleCaixa cx) {
        ServiceNFCeAfericaoPreAbastecimento serviceEncerrante = Main.getBean(ServiceNFCeAfericaoPreAbastecimento.class);
        return serviceEncerrante.getEncerrantesAfericoesByControleCaixa(cx);
    }

    public boolean isControlMaster() {
        String macAddress = this.getMacAddress();
        System.out.println("\n\n MAC ADDRESS: " + macAddress);
        for (NFCeGerenMaqAbastecimento g : StaticObjects.getOpcoes().getGerenciamentoMaquinas()) {
            String macAddressConf = g.getAdressMac();
            System.out.println("\n\n MAC Configurados em Opcoes: " + macAddressConf);
            macAddressConf = ToolString.refina((String)macAddressConf);
            macAddress = ToolString.refina((String)macAddress);
            if (!macAddressConf.toUpperCase().contains(macAddress.toUpperCase()) || !g.getAcessoMaster().equals((short)1)) continue;
            System.out.println("\n\n Configurado como MASTER - MAC ADDRESS: " + this.getMacAddress());
            return true;
        }
        System.out.println("\n\n Configurado como SLAVE - MAC ADDRESS: " + this.getMacAddress());
        return false;
    }

    public String getMacAddress() {
        Object macAddress = "";
        try {
            InetAddress address = InetAddress.getLocalHost();
            NetworkInterface ni = NetworkInterface.getByInetAddress(address);
            byte[] mac = ni.getHardwareAddress();
            if (mac != null) {
                for (int i = 0; i < mac.length; ++i) {
                    macAddress = (String)macAddress + String.format("%02X", mac[i]);
                    if (mac.length - 1 == i) continue;
                    macAddress = (String)macAddress + "-";
                }
            }
        }
        catch (UnknownHostException e) {
            e.printStackTrace();
        }
        catch (SocketException e) {
            e.printStackTrace();
        }
        return macAddress;
    }

    public ComunicadorResposta<LeituraAbastecimentoByRegistro> leituraComandoLeituraAbastecimentoByPonteiro(Integer numeroRegistro) throws Exception {
        try {
            this.checkAndConectAutomacao();
            this.waitForSocketAndBlock();
            this.setSocketLiberado(Boolean.FALSE);
            ComunicadorResposta comunicadorResposta = this.comunicador.comandoLeituraAbastecimentoByRegistro(numeroRegistro);
            return comunicadorResposta;
        }
        catch (Exception ex) {
            TLogger.get(this.getClass()).error((Throwable)ex);
            throw ex;
        }
        finally {
            this.freeSocket();
        }
    }

    public ComunicadorResposta preDeterminarValorAbastecimento(BicoBombaCombustivel bico, Double valorAbastecimento) throws Exception {
        try {
            this.checkAndConectAutomacao();
            this.waitForSocketAndBlock();
            this.setSocketLiberado(Boolean.FALSE);
            ComunicadorResposta comunicadorResposta = this.comunicador.preDeterminaValorAbastecimento(bico.getCodigoAutomacao(), valorAbastecimento);
            return comunicadorResposta;
        }
        catch (Exception ex) {
            TLogger.get(this.getClass()).error((Throwable)ex);
            throw ex;
        }
        finally {
            this.freeSocket();
        }
    }

    private void sleep(long timer) {
        try {
            Thread.sleep(timer);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public synchronized boolean isSocketLiberado() {
        System.out.println("Status Socket: " + this.socketLiberado);
        return this.socketLiberado;
    }

    protected synchronized void setSocketLiberado(boolean socketLiberado) {
        this.sleep(100L);
        this.socketLiberado = socketLiberado;
    }

    public void gerarAfericaoPreAbastecimento(List<NFCePreAbastecimento> listPreAbastecimento) throws Exception {
        if (listPreAbastecimento == null || listPreAbastecimento.isEmpty()) {
            return;
        }
        ArrayList<NFCeAfericaoPreAbastecimento> aux = new ArrayList<NFCeAfericaoPreAbastecimento>();
        for (NFCePreAbastecimento n : listPreAbastecimento) {
            NFCeAfericaoPreAbastecimento af = new NFCeAfericaoPreAbastecimento();
            af.setPreAbastecimento(n);
            if (af.getNfCeControleCaixa() == null) {
                af.setNfCeControleCaixa(StaticObjects.getControleCaixa());
            }
            af.setVlrEncerranteInicial(n.getValorEncerrante() - n.getQuantidade());
            af.setVlrEncerranteFinal(n.getValorEncerrante());
            af.setSerialForSinc(UtilNFCeSerial.getSerial(StaticObjects.getNFCeCaixa()));
            aux.add(af);
            this.sleep(1L);
        }
        ServiceNFCeAfericaoPreAbastecimento service = Main.getBean(ServiceNFCeAfericaoPreAbastecimento.class);
        service.saveAll(aux);
        this.imprimeComprovanteAfericao(aux);
        if (ToolMethods.isEquals((Object)StaticObjects.getOpcoes().getBloquearBombaAuto(), (Object)1)) {
            for (NFCeAfericaoPreAbastecimento n : aux) {
                if (n.getPreAbastecimento() == null) continue;
                this.liberarBombaAbastecimento(n.getPreAbastecimento().getBico());
            }
        }
    }

    private void imprimeComprovanteAfericao(List<NFCeAfericaoPreAbastecimento> list) throws Exception {
        try {
            new PrintAfericaoAbastecimento().printComprovanteAfericao(list);
        }
        catch (ExceptionJasperReports | ExceptionPrint ex) {
            TLogger.get(this.getClass()).error(ex);
            throw ex;
        }
    }

    public boolean isItemNTAbastCanc() {
        return this.itemNTAbastCanc;
    }

    public void setItemNTAbastCanc(boolean itemNTAbastCanc) {
        this.itemNTAbastCanc = itemNTAbastCanc;
    }

    public void setPlacaAndKMNFCePreAbastecimento(NFCe nfce, String placa, String km) {
        UtilNFCe.setPlaca(nfce, placa, km);
        for (NFCeItem i : nfce.getItens()) {
            if (i.getPreAbastecimento() == null) continue;
            i.getPreAbastecimento().setKm(km);
            i.getPreAbastecimento().setPlaca(placa);
        }
    }

    public void liberarAllBombaAbastecimentoExceto(List<BicoBombaCombustivel> bicos) throws Exception {
        List<BombaCombustivel> listBombas = this.getAllBombasCombustivel();
        for (BombaCombustivel b : listBombas) {
            for (BicoBombaCombustivel bb : b.getBicos()) {
                if (bicos.contains(bb)) continue;
                this.liberarBombaAbastecimento(bb);
            }
        }
    }

    private void waitForSocketAndBlock() throws ExceptionAutomacaoPosto {
        long timer = 0L;
        while (!this.isSocketLiberado()) {
            this.sleep(250L);
            if ((timer += 250L) <= 15000L) continue;
            throw new ExceptionAutomacaoPosto("Foi enviado um comando a automa\u00e7\u00e3o que n\u00e3o respondeu a solicita\u00e7\u00e3o. ");
        }
        this.setSocketLiberado(Boolean.FALSE);
    }

    private void freeSocket() {
        this.setSocketLiberado(Boolean.TRUE);
    }
}

