/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.touchnfce.utils.sitef;

import br.com.softwareexpress.sitef.JCliSiTefI;
import com.touchcomp.basementor.constants.enums.tef.EnumTEFTipoTef;
import com.touchcomp.basementorexceptions.exceptions.impl.tef.ExceptionTEF;
import com.touchcomp.touchnfce.StaticObjects;
import com.touchcomp.touchnfce.components.DialogsHelperShowInfoFrame;
import com.touchcomp.touchnfce.controller.Alerts;
import com.touchcomp.touchnfce.utils.sitef.UtilSitefConfigura;
import java.util.logging.Level;
import java.util.logging.Logger;

public class UtilSitef {
    public static void configurarSiTef() {
        if (StaticObjects.getNFCeCaixa().getTipoTEF().shortValue() == EnumTEFTipoTef.TIPO_TEF_NAO_UTILIZA.getValue()) {
            return;
        }
        String javaArch = System.getProperty("java.vm.name");
        try {
            if (javaArch != null && javaArch.contains("64")) {
                System.loadLibrary("CliSiTef64I");
                System.out.println("Arquitetura Java 64 bits");
            } else {
                System.loadLibrary("CliSiTef32I");
                System.out.println("Arquitetura Java 32bits");
            }
            System.loadLibrary("jCliSiTefI");
            String endereco = StaticObjects.getNFCeCaixa().getEnderecoSiTef();
            String idLoja = StaticObjects.getNFCeCaixa().getNrLojaSitef();
            String idTerminal = StaticObjects.getNFCeCaixa().getNrTerminalSitef();
            String cnpjEmpresa = StaticObjects.getEmpresa().getPessoa().getComplemento().getCnpj();
            String cnpjDesenvolvedor = "17254557000151";
            int ret = 0;
            try {
                ret = UtilSitefConfigura.configurarSiTef(endereco, idLoja, idTerminal, cnpjEmpresa, cnpjDesenvolvedor);
            }
            catch (ExceptionTEF ex) {
                Logger.getLogger(UtilSitef.class.getName()).log(Level.SEVERE, null, ex);
            }
            if (ret != 0) {
                Alerts.showAlertError("Erro ao configurar o servidor SiTef!");
            }
            JCliSiTefI j = new JCliSiTefI();
            ret = j.verificaPresencaPinPad();
            System.out.println("RETORNO: " + ret);
        }
        catch (Throwable t) {
            t.printStackTrace();
            DialogsHelperShowInfoFrame.show("N\u00e3o foi possivel configurar o Sitef/TEF. Arquitetura java: " + javaArch);
        }
    }
}

